/*
 * Decompiled with CFR 0.152.
 */
package glowredman.amazingtrophies.model;

import com.gtnewhorizons.angelica.config.AngelicaConfig;
import com.gtnewhorizons.angelica.mixins.interfaces.IModelCustomExt;
import glowredman.amazingtrophies.AmazingTrophies;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.client.model.ModelFormatException;

public abstract class ModelWrapper<T extends IModelCustom> {
    protected T model;

    public abstract void renderAll();

    public static ModelWrapper<? extends IModelCustom> get(ResourceLocation resource) throws IllegalArgumentException, ModelFormatException {
        if (AmazingTrophies.isAngelicaLoaded && AngelicaConfig.enableVBO) {
            return new ModelCustomWrapperExt(resource);
        }
        return new ModelCustomWrapper(resource);
    }

    private static class ModelCustomWrapperExt
    extends ModelWrapper<IModelCustomExt> {
        private ModelCustomWrapperExt(ResourceLocation resource) throws IllegalArgumentException, ModelFormatException {
            this.model = (IModelCustomExt)AdvancedModelLoader.loadModel((ResourceLocation)resource);
        }

        @Override
        public void renderAll() {
            if (AngelicaConfig.enableVBO) {
                ((IModelCustomExt)this.model).renderAllVBO();
            } else {
                ((IModelCustomExt)this.model).renderAll();
            }
        }
    }

    private static class ModelCustomWrapper
    extends ModelWrapper<IModelCustom> {
        private ModelCustomWrapper(ResourceLocation resource) throws IllegalArgumentException, ModelFormatException {
            this.model = AdvancedModelLoader.loadModel((ResourceLocation)resource);
        }

        @Override
        public void renderAll() {
            this.model.renderAll();
        }
    }
}

