/*
 * Decompiled with CFR 0.152.
 */
package glowredman.amazingtrophies.trophy;

import glowredman.amazingtrophies.trophy.TileEntityTrophy;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.UsernameCache;

public class ItemBlockTrophy
extends ItemBlock {
    public ItemBlockTrophy(Block p_i45328_1_) {
        super(p_i45328_1_);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advancedTooltips) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        long time = nbt.func_74763_f("time");
        String rawUUID = nbt.func_74779_i("uuid");
        if (rawUUID.isEmpty()) {
            return;
        }
        UUID uuid = null;
        try {
            uuid = UUID.fromString(rawUUID);
        }
        catch (IllegalArgumentException ignored) {
            tooltip.add(StatCollector.func_74838_a((String)"amazingtrophies.uuid.invalid"));
            return;
        }
        String name = nbt.func_74779_i("name");
        String cachedName = null;
        if (uuid != null && (cachedName = UsernameCache.getLastKnownUsername((UUID)uuid)) != null) {
            name = cachedName;
            nbt.func_74778_a("name", cachedName);
        }
        if (name.isEmpty()) {
            tooltip.add(StatCollector.func_74837_a((String)(this.field_150939_a.func_149739_a() + ".unknownUsername.name.desc"), (Object[])new Object[0]));
            tooltip.add(StatCollector.func_74837_a((String)(this.field_150939_a.func_149739_a() + ".unknownUsername.time.desc"), (Object[])new Object[]{time}));
            return;
        }
        tooltip.add(StatCollector.func_74837_a((String)(this.field_150939_a.func_149739_a() + ".name.desc"), (Object[])new Object[]{name}));
        tooltip.add(StatCollector.func_74837_a((String)(this.field_150939_a.func_149739_a() + ".time.desc"), (Object[])new Object[]{time}));
    }

    public String func_77667_c(ItemStack stack) {
        String prefix = this.field_150939_a.func_149739_a();
        if (!stack.func_77942_o()) {
            return prefix;
        }
        String id = stack.func_77978_p().func_74779_i("trophyID");
        if (id.isEmpty()) {
            return prefix;
        }
        return prefix + "." + id;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        TileEntity tileEntity;
        metadata = Math.round(-player.field_70177_z / 22.5f) & 0xF;
        boolean placed = super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata);
        if (placed && stack.func_77942_o() && (tileEntity = world.func_147438_o(x, y, z)) instanceof TileEntityTrophy) {
            TileEntityTrophy tileTrophy = (TileEntityTrophy)tileEntity;
            tileTrophy.copyFromNBT(stack.func_77978_p());
            if (!world.field_72995_K) {
                world.func_147471_g(x, y, z);
            }
        }
        return placed;
    }
}

