/*
 * Decompiled with CFR 0.152.
 */
package glowredman.amazingtrophies.model.complex;

import glowredman.amazingtrophies.model.complex.RenderFacesInfo;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class BaseModelStructure {
    protected RenderFacesInfo[][][] renderFacesArray;
    protected Map<Character, Pair<Block, Integer>> charToBlock = new HashMap<Character, Pair<Block, Integer>>();

    protected final int getXLength() {
        return this.getStructureString().length;
    }

    protected final int getYLength() {
        return this.getStructureString()[0][0].length();
    }

    protected final int getZLength() {
        return this.getStructureString()[0].length;
    }

    protected String[][] getStructureString() {
        return null;
    }

    protected final float maxAxisSize() {
        return Math.max(this.getXLength(), Math.max(this.getYLength(), this.getZLength()));
    }

    protected final Pair<Block, Integer> getAssociatedBlockInfo(char letter) {
        return this.charToBlock.get(Character.valueOf(letter));
    }

    protected static void reverseInnerArrays(String[][] array) {
        for (Object[] objectArray : array) {
            ArrayUtils.reverse((Object[])objectArray);
        }
    }

    protected static String[][] transpose(String[][] array) {
        String[][] newArray = new String[array[0].length][array.length];
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                newArray[j][i] = array[i][j];
            }
        }
        return newArray;
    }

    private static String[][] deepCopy(String[][] original) {
        if (original == null) {
            return null;
        }
        String[][] result = new String[original.length][];
        for (int i = 0; i < original.length; ++i) {
            result[i] = Arrays.copyOf(original[i], original[i].length);
        }
        return result;
    }

    protected void processStructureMap() {
        String[][] structureCopy = BaseModelStructure.deepCopy(this.getStructureString());
        Set<Character> transparentBlocks = this.getTransparentBlocks();
        this.removeTransparentBlocks(structureCopy, transparentBlocks);
        this.generateRenderFacesInfo(structureCopy);
    }

    private void generateRenderFacesInfo(String[][] structureCopy) {
        this.renderFacesArray = new RenderFacesInfo[this.getXLength()][this.getZLength()][this.getYLength()];
        for (int x = 0; x < this.getXLength(); ++x) {
            for (int y = 0; y < this.getYLength(); ++y) {
                for (int z = 0; z < this.getZLength(); ++z) {
                    RenderFacesInfo renderFacesInfo = new RenderFacesInfo(true);
                    int yNegBlock = 32;
                    if (z != 0) {
                        yNegBlock = structureCopy[x][z - 1].charAt(y);
                    }
                    if (yNegBlock != 32) {
                        renderFacesInfo.setYNeg(false);
                    }
                    int yPosBlock = 32;
                    if (z != this.getZLength() - 1) {
                        yPosBlock = structureCopy[x][z + 1].charAt(y);
                    }
                    if (yPosBlock != 32) {
                        renderFacesInfo.setYPos(false);
                    }
                    int xNegBlock = 32;
                    if (y != 0) {
                        xNegBlock = structureCopy[x][z].charAt(y - 1);
                    }
                    if (xNegBlock != 32) {
                        renderFacesInfo.setZNeg(false);
                    }
                    int xPosBlock = 32;
                    if (y != this.getYLength() - 1) {
                        xPosBlock = structureCopy[x][z].charAt(y + 1);
                    }
                    if (xPosBlock != 32) {
                        renderFacesInfo.setZPos(false);
                    }
                    int zNegBlock = 32;
                    if (x != 0) {
                        zNegBlock = structureCopy[x - 1][z].charAt(y);
                    }
                    if (zNegBlock != 32) {
                        renderFacesInfo.setXNeg(false);
                    }
                    int zPosBlock = 32;
                    if (x != this.getXLength() - 1) {
                        zPosBlock = structureCopy[x + 1][z].charAt(y);
                    }
                    if (zPosBlock != 32) {
                        renderFacesInfo.setXPos(false);
                    }
                    this.renderFacesArray[x][z][y] = renderFacesInfo;
                }
            }
        }
    }

    private void removeTransparentBlocks(String[][] structure, Set<Character> transparentBlocks) {
        if (structure == null || transparentBlocks == null) {
            return;
        }
        for (int i = 0; i < structure.length; ++i) {
            for (int j = 0; j < structure[i].length; ++j) {
                StringBuilder newStr = new StringBuilder();
                for (char c : structure[i][j].toCharArray()) {
                    if (!transparentBlocks.contains(Character.valueOf(c))) {
                        newStr.append(c);
                        continue;
                    }
                    newStr.append(' ');
                }
                structure[i][j] = newStr.toString();
            }
        }
    }

    private Set<Character> getTransparentBlocks() {
        HashSet<Character> transparentBlocks = new HashSet<Character>();
        for (Map.Entry<Character, Pair<Block, Integer>> entry : this.charToBlock.entrySet()) {
            Block block = (Block)entry.getValue().getLeft();
            if (block.func_149662_c()) continue;
            transparentBlocks.add(entry.getKey());
        }
        return transparentBlocks;
    }
}

