/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.util;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.parts.IPart;
import appeng.api.storage.data.IAEFluidStack;
import appeng.util.item.AEFluidStack;
import com.glodblock.github.common.item.ItemFluidPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public final class Util {
    public static EnumFacing from(ForgeDirection direction) {
        switch (direction) {
            case WEST: {
                return EnumFacing.EAST;
            }
            case EAST: {
                return EnumFacing.WEST;
            }
            case UNKNOWN: {
                return null;
            }
        }
        int o = direction.ordinal();
        return EnumFacing.values()[o];
    }

    public static ForgeDirection from(EnumFacing direction) {
        switch (direction) {
            case WEST: {
                return ForgeDirection.EAST;
            }
            case EAST: {
                return ForgeDirection.WEST;
            }
        }
        int o = direction.ordinal();
        return ForgeDirection.values()[o];
    }

    public static boolean hasPermission(EntityPlayer player, SecurityPermissions permission, IGrid grid) {
        return grid == null || Util.hasPermission(player, permission, (ISecurityGrid)grid.getCache(ISecurityGrid.class));
    }

    public static boolean hasPermission(EntityPlayer player, SecurityPermissions permission, IGridHost host) {
        return Util.hasPermission(player, permission, host, ForgeDirection.UNKNOWN);
    }

    public static boolean hasPermission(EntityPlayer player, SecurityPermissions permission, IGridHost host, ForgeDirection side) {
        return host == null || Util.hasPermission(player, permission, host.getGridNode(side));
    }

    public static boolean hasPermission(EntityPlayer player, SecurityPermissions permission, IGridNode host) {
        return host == null || Util.hasPermission(player, permission, host.getGrid());
    }

    public static boolean hasPermission(EntityPlayer player, SecurityPermissions permission, IPart part) {
        return part == null || Util.hasPermission(player, permission, part.getGridNode());
    }

    public static boolean hasPermission(EntityPlayer player, SecurityPermissions permission, ISecurityGrid securityGrid) {
        return player == null || permission == null || securityGrid == null || securityGrid.hasPermission(player, permission);
    }

    public static ItemStack copyStackWithSize(ItemStack itemStack, int size) {
        if (size == 0 || itemStack == null) {
            return null;
        }
        ItemStack copy = itemStack.func_77946_l();
        copy.field_77994_a = size;
        return copy;
    }

    public static FluidStack getFluidFromItem(ItemStack stack) {
        if (stack != null && (stack.func_77973_b() instanceof IFluidContainerItem || FluidContainerRegistry.isContainer((ItemStack)stack))) {
            FluidStack fluid;
            if (stack.func_77973_b() instanceof IFluidContainerItem && (fluid = ((IFluidContainerItem)stack.func_77973_b()).getFluid(stack)) != null) {
                FluidStack fluid0 = fluid.copy();
                fluid0.amount *= stack.field_77994_a;
                return fluid0;
            }
            if (FluidContainerRegistry.isContainer((ItemStack)stack) && (fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack)) != null) {
                FluidStack fluid0 = fluid.copy();
                fluid0.amount *= stack.field_77994_a;
                return fluid0;
            }
        }
        return null;
    }

    public static boolean isFluidPacket(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ItemFluidPacket;
    }

    public static FluidStack cloneFluidStack(FluidStack fluidStack) {
        if (fluidStack != null) {
            return fluidStack.copy();
        }
        return null;
    }

    public static IAEFluidStack loadFluidStackFromNBT(NBTTagCompound i) {
        FluidStack t = FluidRegistry.getFluidStack((String)i.func_74779_i("FluidName"), (int)1);
        AEFluidStack fluid = AEFluidStack.create((Object)t);
        fluid.setStackSize(i.func_74763_f("Cnt"));
        fluid.setCountRequestable(i.func_74763_f("Req"));
        fluid.setCraftable(i.func_74767_n("Craft"));
        return fluid;
    }

    public static boolean areFluidsEqual(FluidStack fluid1, FluidStack fluid2) {
        if (fluid1 == null || fluid2 == null) {
            return false;
        }
        return fluid1.isFluidEqual(fluid2);
    }
}

