/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.network;

import appeng.api.storage.data.IAEFluidStack;
import appeng.util.item.AEFluidStack;
import com.glodblock.github.client.gui.GuiFluidIO;
import com.glodblock.github.client.gui.GuiFluidInterface;
import com.glodblock.github.client.gui.GuiIngredientBuffer;
import com.glodblock.github.client.gui.GuiLargeIngredientBuffer;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;

public class SPacketFluidUpdate
implements IMessage {
    private Map<Integer, IAEFluidStack> list;

    public SPacketFluidUpdate() {
    }

    public SPacketFluidUpdate(Map<Integer, IAEFluidStack> data) {
        this.list = data;
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        this.list = new HashMap<Integer, IAEFluidStack>();
        try {
            for (int i = 0; i < size; ++i) {
                int id = buf.readInt();
                boolean isNull = buf.readBoolean();
                if (!isNull) {
                    this.list.put(id, null);
                    continue;
                }
                IAEFluidStack fluid = AEFluidStack.loadFluidStackFromPacket((ByteBuf)buf);
                this.list.put(id, fluid);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.list.size());
        try {
            for (Map.Entry<Integer, IAEFluidStack> fs : this.list.entrySet()) {
                buf.writeInt(fs.getKey().intValue());
                if (fs.getValue() == null) {
                    buf.writeBoolean(false);
                    continue;
                }
                buf.writeBoolean(true);
                fs.getValue().writeToPacket(buf);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class Handler
    implements IMessageHandler<SPacketFluidUpdate, IMessage> {
        public IMessage onMessage(SPacketFluidUpdate message, MessageContext ctx) {
            block5: {
                GuiScreen gs;
                block7: {
                    block6: {
                        block4: {
                            gs = Minecraft.func_71410_x().field_71462_r;
                            if (!(gs instanceof GuiIngredientBuffer)) break block4;
                            for (Map.Entry e : message.list.entrySet()) {
                                ((GuiIngredientBuffer)gs).update((Integer)e.getKey(), (IAEFluidStack)e.getValue());
                            }
                            break block5;
                        }
                        if (!(gs instanceof GuiLargeIngredientBuffer)) break block6;
                        for (Map.Entry e : message.list.entrySet()) {
                            ((GuiLargeIngredientBuffer)gs).update((Integer)e.getKey(), (IAEFluidStack)e.getValue());
                        }
                        break block5;
                    }
                    if (!(gs instanceof GuiFluidIO)) break block7;
                    for (Map.Entry e : message.list.entrySet()) {
                        ((GuiFluidIO)gs).update((Integer)e.getKey(), (IAEFluidStack)e.getValue());
                    }
                    break block5;
                }
                if (!(gs instanceof GuiFluidInterface)) break block5;
                for (Map.Entry e : message.list.entrySet()) {
                    ((GuiFluidInterface)gs).update((Integer)e.getKey(), (IAEFluidStack)e.getValue());
                }
            }
            return null;
        }
    }
}

