/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.nei.object;

import codechicken.nei.PositionedStack;
import com.glodblock.github.nei.object.IllegalOrderStackID;
import com.glodblock.github.util.Util;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class OrderStack<T> {
    private final T RealStack;
    private final int index;
    public static final int ITEM = 1;
    public static final int FLUID = 2;
    public static final int CUSTOM = 3;

    public OrderStack(T stack, int order) {
        if (stack == null || order < 0) {
            throw new IllegalArgumentException("Trying to create a null or negative order stack!");
        }
        this.RealStack = stack;
        this.index = order;
    }

    public T getStack() {
        return this.RealStack;
    }

    public int getIndex() {
        return this.index;
    }

    public static OrderStack<ItemStack> pack(PositionedStack stack, int index) {
        if (stack != null && stack.items != null && stack.items.length > 0) {
            if (Items.field_151008_G.getDamage(stack.items[0]) == Short.MAX_VALUE) {
                ItemStack tmp = stack.items[0].func_77946_l();
                tmp.func_77964_b(0);
                return new OrderStack<ItemStack>(tmp, index);
            }
            return new OrderStack<ItemStack>(stack.items[0].func_77946_l(), index);
        }
        return null;
    }

    public static OrderStack<?> packFluid(PositionedStack stack, int index) {
        if (stack != null && stack.items != null && stack.items.length > 0) {
            FluidStack fluid = Util.getFluidFromItem(stack.items[0]);
            if (fluid != null) {
                return new OrderStack<FluidStack>(fluid.copy(), index);
            }
            return OrderStack.pack(stack, index);
        }
        return null;
    }

    protected void customNBTWriter(NBTTagCompound buf) {
    }

    protected T customNBTReader(NBTTagCompound buf) {
        return null;
    }

    public final void writeToNBT(NBTTagCompound buf) {
        if (this.RealStack instanceof ItemStack) {
            NBTTagCompound tmp = new NBTTagCompound();
            tmp.func_74774_a("t", (byte)1);
            ((ItemStack)this.RealStack).func_77955_b(tmp);
            buf.func_74782_a(this.index + ":", (NBTBase)tmp);
        } else if (this.RealStack instanceof FluidStack) {
            NBTTagCompound tmp = new NBTTagCompound();
            tmp.func_74774_a("t", (byte)2);
            ((FluidStack)this.RealStack).writeToNBT(tmp);
            buf.func_74782_a(this.index + ":", (NBTBase)tmp);
        } else {
            NBTTagCompound tmp = new NBTTagCompound();
            tmp.func_74774_a("t", (byte)3);
            this.customNBTWriter(tmp);
            buf.func_74782_a(this.index + ":", (NBTBase)tmp);
        }
    }

    public static OrderStack<?> readFromNBT(NBTTagCompound buf, @Nullable OrderStack<?> dummy, int index) {
        if (!buf.func_74764_b(index + ":")) {
            return null;
        }
        NBTTagCompound info = buf.func_74775_l(index + ":");
        byte id = info.func_74771_c("t");
        switch (id) {
            case 1: {
                return new OrderStack<ItemStack>(ItemStack.func_77949_a((NBTTagCompound)info), index);
            }
            case 2: {
                return new OrderStack<FluidStack>(FluidStack.loadFluidStackFromNBT((NBTTagCompound)info), index);
            }
            case 3: {
                if (dummy == null) {
                    throw new IllegalOrderStackID(id);
                }
                return new OrderStack(dummy.customNBTReader(buf), index);
            }
        }
        throw new IllegalOrderStackID(id);
    }
}

