/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.parts;

import appeng.api.config.RedstoneMode;
import appeng.api.config.Upgrades;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.me.GridAccessException;
import appeng.parts.automation.PartUpgradeable;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.util.Platform;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.inventory.InventoryHandler;
import com.glodblock.github.inventory.gui.GuiType;
import com.glodblock.github.util.BlockPos;
import com.glodblock.github.util.Util;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public abstract class PartSharedFluidBus
extends PartUpgradeable
implements IGridTickable {
    private final AppEngInternalAEInventory config = new AppEngInternalAEInventory((IAEAppEngInventory)this, 9);
    private boolean lastRedstone;

    public PartSharedFluidBus(ItemStack is) {
        super(is);
    }

    public abstract IIcon getFaceIcon();

    public void upgradesChanged() {
        this.updateState();
    }

    public void onNeighborChanged() {
        this.updateState();
        if (this.lastRedstone != this.getHost().hasRedstone(this.getSide())) {
            boolean bl = this.lastRedstone = !this.lastRedstone;
            if (this.lastRedstone && this.getRSMode() == RedstoneMode.SIGNAL_PULSE) {
                this.doBusWork();
            }
        }
    }

    private void updateState() {
        try {
            if (!this.isSleeping()) {
                this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
            } else {
                this.getProxy().getTick().sleepDevice(this.getProxy().getNode());
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public boolean onPartActivate(EntityPlayer player, Vec3 pos) {
        if (player.func_70093_af()) {
            return false;
        }
        if (Platform.isServer()) {
            InventoryHandler.openGui(player, this.getHost().getTile().func_145831_w(), new BlockPos(this.getHost().getTile()), Objects.requireNonNull(Util.from(this.getSide())), GuiType.FLUID_BUS_IO);
        }
        return true;
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 13.0);
        bch.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
        bch.addBox(4.0, 4.0, 14.0, 12.0, 12.0, 16.0);
    }

    protected TileEntity getConnectedTE() {
        TileEntity self = this.getHost().getTile();
        return this.getTileEntity(self, new BlockPos(self).getOffSet(this.getSide()));
    }

    private TileEntity getTileEntity(TileEntity self, BlockPos pos) {
        World w = self.func_145831_w();
        if (w.func_72863_F().func_73149_a(pos.getX() >> 4, pos.getZ() >> 4)) {
            return w.func_147438_o(pos.getX(), pos.getY(), pos.getZ());
        }
        return null;
    }

    protected int calculateAmountToSend() {
        double amount = 1000.0;
        switch (this.getInstalledUpgrades(Upgrades.SPEED)) {
            case 4: {
                amount *= 1.5;
            }
            case 3: {
                amount *= 2.0;
            }
            case 2: {
                amount *= 4.0;
            }
            case 1: {
                amount *= 8.0;
            }
        }
        return (int)Math.floor(amount);
    }

    public void readFromNBT(NBTTagCompound extra) {
        super.readFromNBT(extra);
        this.config.readFromNBT(extra, "config");
    }

    public void writeToNBT(NBTTagCompound extra) {
        super.writeToNBT(extra);
        this.config.writeToNBT(extra, "config");
    }

    public IInventory getInventoryByName(String name) {
        if (name.equals("config")) {
            return this.config;
        }
        return super.getInventoryByName(name);
    }

    public void setFluidInSlot(int id, IAEFluidStack fluid) {
        ItemStack tmp = ItemFluidPacket.newDisplayStack(fluid == null ? null : fluid.getFluidStack());
        this.config.func_70299_a(id, tmp);
    }

    protected StorageChannel getChannel() {
        return StorageChannel.FLUIDS;
    }

    protected abstract TickRateModulation doBusWork();

    protected abstract boolean canDoBusWork();

    public int cableConnectionRenderTo() {
        return 5;
    }
}

