/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.parts;

import appeng.api.config.SecurityPermissions;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.IGridHost;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.core.sync.GuiBridge;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import com.glodblock.github.client.textures.FCPartsTexture;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.common.parts.FCBasePart;
import com.glodblock.github.inventory.BiggerAppEngInventory;
import com.glodblock.github.inventory.InventoryHandler;
import com.glodblock.github.inventory.gui.GuiType;
import com.glodblock.github.util.BlockPos;
import com.glodblock.github.util.Util;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;

public class PartFluidPatternTerminalEx
extends FCBasePart {
    private static final FCPartsTexture FRONT_BRIGHT_ICON = FCPartsTexture.PartFluidPatternTerminal_Bright;
    private static final FCPartsTexture FRONT_DARK_ICON = FCPartsTexture.PartFluidPatternTerminal_Colored;
    private static final FCPartsTexture FRONT_COLORED_ICON = FCPartsTexture.PartFluidPatternTerminal_Dark;
    private final AppEngInternalInventory crafting = new BiggerAppEngInventory(this, 32);
    private final AppEngInternalInventory output = new BiggerAppEngInventory(this, 32);
    private final AppEngInternalInventory pattern = new AppEngInternalInventory((IAEAppEngInventory)this, 2);
    private boolean substitute = false;
    private boolean combine = false;
    private boolean prioritize = false;
    private boolean inverted = false;
    private int activePage = 0;

    public PartFluidPatternTerminalEx(ItemStack is) {
        super(is, true);
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        for (ItemStack is : this.pattern) {
            if (is == null) continue;
            drops.add(is);
        }
    }

    @Override
    public boolean onPartActivate(EntityPlayer player, Vec3 pos) {
        TileEntity te = this.getTile();
        BlockPos tePos = new BlockPos(te);
        if (Platform.isWrench((EntityPlayer)player, (ItemStack)player.field_71071_by.func_70448_g(), (int)tePos.getX(), (int)tePos.getY(), (int)tePos.getZ())) {
            return super.onPartActivate(player, pos);
        }
        if (Platform.isServer()) {
            if (Util.hasPermission(player, SecurityPermissions.INJECT, (IGridHost)this) || Util.hasPermission(player, SecurityPermissions.EXTRACT, (IGridHost)this)) {
                InventoryHandler.openGui(player, te.func_145831_w(), tePos, Objects.requireNonNull(Util.from(this.getSide())), GuiType.FLUID_PATTERN_TERMINAL_EX);
            } else {
                player.func_146105_b((IChatComponent)new ChatComponentText("You don't have permission to view."));
            }
        }
        return true;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.setSubstitution(data.func_74767_n("substitute"));
        this.setCombineMode(data.func_74767_n("combine"));
        this.pattern.readFromNBT(data, "pattern");
        this.output.readFromNBT(data, "outputList");
        this.crafting.readFromNBT(data, "craftingGrid");
        this.setSubstitution(data.func_74767_n("substitute"));
        this.setPrioritization(data.func_74767_n("priorization"));
        this.setInverted(data.func_74767_n("inverted"));
        this.setActivePage(data.func_74762_e("activePage"));
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("substitute", this.substitute);
        data.func_74757_a("combine", this.combine);
        this.pattern.writeToNBT(data, "pattern");
        this.output.writeToNBT(data, "outputList");
        this.crafting.writeToNBT(data, "craftingGrid");
        data.func_74757_a("priorization", this.prioritize);
        data.func_74757_a("substitute", this.substitute);
        data.func_74757_a("inverted", this.inverted);
        data.func_74768_a("activePage", this.activePage);
    }

    @Override
    public GuiBridge getGui(EntityPlayer p) {
        int x = (int)p.field_70165_t;
        int y = (int)p.field_70163_u;
        int z = (int)p.field_70161_v;
        if (this.getHost().getTile() != null) {
            x = this.getTile().field_145851_c;
            y = this.getTile().field_145848_d;
            z = this.getTile().field_145849_e;
        }
        if (GuiBridge.GUI_PATTERN_TERMINAL.hasPermissions(this.getHost().getTile(), x, y, z, this.getSide(), p)) {
            return GuiBridge.GUI_PATTERN_TERMINAL;
        }
        return GuiBridge.GUI_ME;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        ICraftingPatternItem pattern;
        ICraftingPatternDetails details;
        ItemStack is;
        if (inv == this.pattern && slot == 1 && (is = inv.func_70301_a(1)) != null && is.func_77973_b() instanceof ICraftingPatternItem && (details = (pattern = (ICraftingPatternItem)is.func_77973_b()).getPatternForItem(is, this.getHost().getTile().func_145831_w())) != null) {
            ItemStack packet;
            IAEItemStack item;
            int i;
            int i2;
            IAEItemStack[] inItems = details.getInputs();
            IAEItemStack[] outItems = details.getOutputs();
            int inputsCount = 0;
            int outputCount = 0;
            for (i2 = 0; i2 < inItems.length; ++i2) {
                if (inItems[i2] == null) continue;
                ++inputsCount;
            }
            for (i2 = 0; i2 < outItems.length; ++i2) {
                if (outItems[i2] == null) continue;
                ++outputCount;
            }
            this.setSubstitution(details.canSubstitute());
            if (newStack != null) {
                NBTTagCompound data = newStack.func_77978_p();
                this.setCombineMode(data.func_74762_e("combine") == 1);
                this.setPrioritization(data.func_74762_e("prioritize") == 1);
            }
            this.setInverted(inputsCount <= 8 && outputCount >= 8);
            this.setActivePage(0);
            for (i = 0; i < this.crafting.func_70302_i_(); ++i) {
                this.crafting.func_70299_a(i, null);
            }
            for (i = 0; i < this.output.func_70302_i_(); ++i) {
                this.output.func_70299_a(i, null);
            }
            for (i = 0; i < this.crafting.func_70302_i_() && i < inItems.length; ++i) {
                item = inItems[i];
                if (item == null) continue;
                if (item.getItem() instanceof ItemFluidDrop) {
                    packet = ItemFluidPacket.newStack(ItemFluidDrop.getFluidStack(item.getItemStack()));
                    this.crafting.func_70299_a(i, packet);
                    continue;
                }
                this.crafting.func_70299_a(i, item.getItemStack());
            }
            if (this.inverted) {
                for (i = 0; i < this.output.func_70302_i_() && i < outItems.length; ++i) {
                    item = outItems[i];
                    if (item == null) continue;
                    if (item.getItem() instanceof ItemFluidDrop) {
                        packet = ItemFluidPacket.newStack(ItemFluidDrop.getFluidStack(item.getItemStack()));
                        this.output.func_70299_a(i, packet);
                        continue;
                    }
                    this.output.func_70299_a(i, item.getItemStack());
                }
            } else {
                for (i = 0; i < outItems.length && i < 8; ++i) {
                    item = outItems[i];
                    if (item == null) continue;
                    if (item.getItem() instanceof ItemFluidDrop) {
                        packet = ItemFluidPacket.newStack(ItemFluidDrop.getFluidStack(item.getItemStack()));
                        this.output.func_70299_a(i >= 4 ? 12 + i : i, packet);
                        continue;
                    }
                    this.output.func_70299_a(i >= 4 ? 12 + i : i, item.getItemStack());
                }
            }
        }
        this.getHost().markForSave();
    }

    public boolean shouldCombine() {
        return this.combine;
    }

    public void setCombineMode(boolean shouldCombine) {
        this.combine = shouldCombine;
    }

    public boolean isSubstitution() {
        return this.substitute;
    }

    public boolean isPrioritize() {
        return this.prioritize;
    }

    public void setSubstitution(boolean canSubstitute) {
        this.substitute = canSubstitute;
    }

    public void setPrioritization(boolean canPrioritize) {
        this.prioritize = canPrioritize;
    }

    public void onChangeCrafting(IAEItemStack[] newCrafting, IAEItemStack[] newOutput) {
        IInventory crafting = this.getInventoryByName("crafting");
        IInventory output = this.getInventoryByName("output");
        if (crafting instanceof AppEngInternalInventory && output instanceof AppEngInternalInventory) {
            IAEItemStack item;
            int x;
            for (x = 0; x < crafting.func_70302_i_() && x < newCrafting.length; ++x) {
                item = newCrafting[x];
                crafting.func_70299_a(x, item == null ? null : item.getItemStack());
            }
            for (x = 0; x < output.func_70302_i_() && x < newOutput.length; ++x) {
                item = newOutput[x];
                output.func_70299_a(x, item == null ? null : item.getItemStack());
            }
        }
    }

    public IInventory getInventoryByName(String name) {
        if (name.equals("crafting")) {
            return this.crafting;
        }
        if (name.equals("output")) {
            return this.output;
        }
        if (name.equals("pattern")) {
            return this.pattern;
        }
        return super.getInventoryByName(name);
    }

    @Override
    public FCPartsTexture getFrontBright() {
        return FRONT_BRIGHT_ICON;
    }

    @Override
    public FCPartsTexture getFrontColored() {
        return FRONT_COLORED_ICON;
    }

    @Override
    public FCPartsTexture getFrontDark() {
        return FRONT_DARK_ICON;
    }

    @Override
    public boolean isLightSource() {
        return false;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }

    public int getActivePage() {
        return this.activePage;
    }

    public void setActivePage(int activePage) {
        this.activePage = activePage;
    }
}

