/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.item;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.exceptions.MissingDefinition;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IItemList;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.items.AEBaseItem;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import com.glodblock.github.common.Config;
import com.glodblock.github.common.storage.CellType;
import com.glodblock.github.common.storage.IFluidCellInventory;
import com.glodblock.github.common.storage.IFluidCellInventoryHandler;
import com.glodblock.github.common.storage.IStorageFluidCell;
import com.glodblock.github.common.tabs.FluidCraftingTabs;
import com.glodblock.github.util.ModAndClassUtil;
import com.google.common.base.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;

public class ItemBasicFluidStorageCell
extends AEBaseItem
implements IStorageFluidCell {
    private final CellType component;
    private final int totalBytes;
    private final int perType;
    private final double idleDrain;
    private static final HashMap<Integer, IIcon> icon = new HashMap();

    public ItemBasicFluidStorageCell(CellType whichCell, int kilobytes) {
        super(Optional.of((Object)(kilobytes + "k")));
        this.func_77655_b("fluid_storage" + kilobytes);
        this.setFeature(EnumSet.of(AEFeature.StorageCells));
        this.func_77625_d(1);
        this.totalBytes = kilobytes * 1024;
        this.component = whichCell;
        switch (this.component) {
            case Cell1kPart: {
                this.idleDrain = 0.5;
                this.perType = 8;
                break;
            }
            case Cell4kPart: {
                this.idleDrain = 1.0;
                this.perType = 8;
                break;
            }
            case Cell16kPart: {
                this.idleDrain = 1.5;
                this.perType = 8;
                break;
            }
            case Cell64kPart: {
                this.idleDrain = 2.0;
                this.perType = 8;
                break;
            }
            case Cell256kPart: {
                this.idleDrain = 2.5;
                this.perType = 8;
                break;
            }
            case Cell1024kPart: {
                this.idleDrain = 3.0;
                this.perType = 8;
                break;
            }
            case Cell4096kPart: {
                this.idleDrain = 3.5;
                this.perType = 8;
                break;
            }
            default: {
                this.idleDrain = 0.0;
                this.perType = 8;
            }
        }
    }

    public ItemStack getComponent() {
        return this.component.stack(1);
    }

    public String func_77653_i(ItemStack stack) {
        return StatCollector.func_74837_a((String)("item.fluid_storage." + this.totalBytes / 1024 + ".name"), (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        icon.put(this.totalBytes / 1024, iconRegister.func_94245_a("ae2fc:fluid_storage." + this.totalBytes / 1024));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        int id = this.totalBytes / 1024;
        return icon.get(id);
    }

    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        IFluidCellInventoryHandler handler;
        IFluidCellInventory cellInventory;
        IMEInventoryHandler inventory = AEApi.instance().registries().cell().getCellInventory(stack, null, StorageChannel.FLUIDS);
        if (inventory instanceof IFluidCellInventoryHandler && (cellInventory = (handler = (IFluidCellInventoryHandler)inventory).getCellInv()) != null) {
            lines.add(cellInventory.getUsedBytes() + " " + GuiText.Of.getLocal() + ' ' + cellInventory.getTotalBytes() + ' ' + GuiText.BytesUsed.getLocal());
            lines.add(cellInventory.getStoredFluidTypes() + " " + GuiText.Of.getLocal() + ' ' + cellInventory.getTotalFluidTypes() + ' ' + GuiText.Types.getLocal());
            if (handler.isPreformatted()) {
                String list = (handler.getIncludeExcludeMode() == IncludeExclude.WHITELIST ? GuiText.Included : GuiText.Excluded).getLocal();
                lines.add(GuiText.Partitioned.getLocal() + " - " + list + ' ' + GuiText.Precise.getLocal());
            }
        }
    }

    @Override
    public int getBytes(ItemStack cellItem) {
        return this.totalBytes;
    }

    @Override
    public int getBytesPerType(ItemStack cellItem) {
        return this.perType;
    }

    @Override
    public boolean isBlackListed(ItemStack cellItem, IAEFluidStack requestedAddition) {
        if (Config.blacklistEssentiaGas && ModAndClassUtil.ThE && requestedAddition != null) {
            return ModAndClassUtil.essentiaGas.isInstance(requestedAddition.getFluid());
        }
        return false;
    }

    @Override
    public int getTotalTypes(ItemStack cellItem) {
        return 1;
    }

    @Override
    public boolean storableInStorageCell() {
        return false;
    }

    @Override
    public boolean isStorageCell(ItemStack i) {
        return true;
    }

    @Override
    public double getIdleDrain() {
        return this.idleDrain;
    }

    public boolean isEditable(ItemStack is) {
        return true;
    }

    public IInventory getUpgradesInventory(ItemStack is) {
        return new CellUpgrades(is, 0);
    }

    public IInventory getConfigInventory(ItemStack is) {
        return new CellConfig(is);
    }

    public FuzzyMode getFuzzyMode(ItemStack is) {
        String fz = Platform.openNbtData((ItemStack)is).func_74779_i("FuzzyMode");
        try {
            return FuzzyMode.valueOf((String)fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        Platform.openNbtData((ItemStack)is).func_74778_a("FuzzyMode", fzMode.name());
    }

    public String getOreFilter(ItemStack is) {
        return Platform.openNbtData((ItemStack)is).func_74779_i("OreFilter");
    }

    public void setOreFilter(ItemStack is, String filter) {
        Platform.openNbtData((ItemStack)is).func_74778_a("OreFilter", filter);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        this.disassembleDrive(stack, world, player);
        return stack;
    }

    private boolean disassembleDrive(ItemStack stack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            if (Platform.isClient()) {
                return false;
            }
            InventoryPlayer playerInventory = player.field_71071_by;
            IMEInventoryHandler inv = AEApi.instance().registries().cell().getCellInventory(stack, null, StorageChannel.FLUIDS);
            if (inv != null && playerInventory.func_70448_g() == stack) {
                InventoryAdaptor ia = InventoryAdaptor.getAdaptor((Object)player, (ForgeDirection)ForgeDirection.UNKNOWN);
                IItemList list = inv.getAvailableItems(StorageChannel.FLUIDS.createList());
                if (list.isEmpty() && ia != null) {
                    playerInventory.func_70299_a(playerInventory.field_70461_c, null);
                    ItemStack extraB = ia.addItems(this.component.stack(1));
                    if (extraB != null) {
                        player.func_71019_a(extraB, false);
                    }
                    IInventory upgradesInventory = this.getUpgradesInventory(stack);
                    for (int upgradeIndex = 0; upgradeIndex < upgradesInventory.func_70302_i_(); ++upgradeIndex) {
                        ItemStack upgradeStack = upgradesInventory.func_70301_a(upgradeIndex);
                        ItemStack leftStack = ia.addItems(upgradeStack);
                        if (leftStack == null || !(upgradeStack.func_77973_b() instanceof IUpgradeModule)) continue;
                        player.func_71019_a(upgradeStack, false);
                    }
                    for (ItemStack storageCellStack : AEApi.instance().definitions().materials().emptyStorageCell().maybeStack(1).asSet()) {
                        ItemStack extraA = ia.addItems(storageCellStack);
                        if (extraA == null) continue;
                        player.func_71019_a(extraA, false);
                    }
                    if (player.field_71069_bz != null) {
                        player.field_71069_bz.func_75142_b();
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (ForgeEventFactory.onItemUseStart((EntityPlayer)player, (ItemStack)stack, (int)1) <= 0) {
            return true;
        }
        return this.disassembleDrive(stack, world, player);
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        Iterator iterator = AEApi.instance().definitions().materials().emptyStorageCell().maybeStack(1).asSet().iterator();
        if (iterator.hasNext()) {
            ItemStack stack = (ItemStack)iterator.next();
            return stack;
        }
        throw new MissingDefinition("Tried to use empty storage cells while basic storage cells are defined.");
    }

    public boolean hasContainerItem(ItemStack stack) {
        return AEConfig.instance.isFeatureEnabled(AEFeature.EnableDisassemblyCrafting);
    }

    public ItemBasicFluidStorageCell register() {
        if (!Config.fluidCells) {
            return null;
        }
        GameRegistry.registerItem((Item)this, (String)("fluid_storage" + this.totalBytes / 1024), (String)"ae2fc");
        this.func_77637_a(FluidCraftingTabs.INSTANCE);
        return this;
    }

    public ItemStack stack(int size) {
        return new ItemStack((Item)this, size);
    }

    public ItemStack stack() {
        return new ItemStack((Item)this, 1);
    }
}

