/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui.container;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.implementations.guiobjects.IPortableCell;
import appeng.api.implementations.tiles.IMEChest;
import appeng.api.implementations.tiles.IViewCellStorage;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.parts.IPart;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.container.AEBaseContainer;
import appeng.container.guisync.GuiSync;
import appeng.container.slot.SlotRestrictedInput;
import appeng.core.AELog;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.me.helpers.ChannelPowerSrc;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import com.glodblock.github.FluidCraft;
import com.glodblock.github.network.SPacketMEInventoryUpdate;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.io.IOException;
import java.nio.BufferOverflowException;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class FCBaseMonitorContain
extends AEBaseContainer
implements IConfigManagerHost,
IConfigurableObject,
IMEMonitorHandlerReceiver<IAEItemStack> {
    private final SlotRestrictedInput[] cellView = new SlotRestrictedInput[5];
    private final IMEMonitor<IAEItemStack> monitor;
    private final IItemList<IAEItemStack> items = AEApi.instance().storage().createItemList();
    private final IConfigManager clientCM;
    private final ITerminalHost host;
    @GuiSync(value=99)
    public boolean canAccessViewCells = false;
    @GuiSync(value=98)
    public boolean hasPower = false;
    private IConfigManagerHost gui;
    private IConfigManager serverCM;
    private IGridNode networkNode;

    public FCBaseMonitorContain(InventoryPlayer ip, ITerminalHost monitorable) {
        this(ip, monitorable, true);
    }

    protected FCBaseMonitorContain(InventoryPlayer ip, ITerminalHost monitorable, boolean bindInventory) {
        super(ip, monitorable instanceof TileEntity ? (TileEntity)monitorable : null, monitorable instanceof IPart ? (IPart)monitorable : null);
        this.host = monitorable;
        this.clientCM = new ConfigManager((IConfigManagerHost)this);
        this.clientCM.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        this.clientCM.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        this.clientCM.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
        if (Platform.isServer()) {
            this.serverCM = monitorable.getConfigManager();
            this.monitor = monitorable.getItemInventory();
            if (this.monitor != null) {
                IGridNode node;
                this.monitor.addListener((IMEMonitorHandlerReceiver)this, null);
                this.setCellInventory((IMEInventoryHandler)this.monitor);
                if (monitorable instanceof IPortableCell) {
                    this.setPowerSource((IEnergySource)monitorable);
                } else if (monitorable instanceof IMEChest) {
                    this.setPowerSource((IEnergySource)monitorable);
                } else if (monitorable instanceof IGridHost && (node = ((IGridHost)monitorable).getGridNode(ForgeDirection.UNKNOWN)) != null) {
                    this.networkNode = node;
                    IGrid g = node.getGrid();
                    if (g != null) {
                        this.setPowerSource((IEnergySource)new ChannelPowerSrc(this.networkNode, (IEnergySource)g.getCache(IEnergyGrid.class)));
                    }
                }
            } else {
                this.setValidContainer(false);
            }
        } else {
            this.monitor = null;
        }
        this.canAccessViewCells = false;
        if (monitorable instanceof IViewCellStorage) {
            for (int y = 0; y < 5; ++y) {
                this.cellView[y] = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.VIEW_CELL, ((IViewCellStorage)monitorable).getViewCellStorage(), y, 206, y * 18 + 8, this.getInventoryPlayer());
                this.cellView[y].setAllowEdit(this.canAccessViewCells);
                this.func_75146_a((Slot)this.cellView[y]);
            }
        }
        if (bindInventory) {
            this.bindPlayerInventory(ip, 0, 0);
        }
    }

    public IGridNode getNetworkNode() {
        return this.networkNode;
    }

    public void func_75142_b() {
        if (Platform.isServer()) {
            if (this.monitor != this.host.getItemInventory()) {
                this.setValidContainer(false);
            }
            for (Settings set : this.serverCM.getSettings()) {
                Enum sideRemote;
                Enum sideLocal = this.serverCM.getSetting(set);
                if (sideLocal == (sideRemote = this.clientCM.getSetting(set))) continue;
                this.clientCM.putSetting(set, sideLocal);
                for (Object crafter : this.field_75149_d) {
                    try {
                        NetworkHandler.instance.sendTo((AppEngPacket)new PacketValueConfig(set.name(), sideLocal.name()), (EntityPlayerMP)crafter);
                    }
                    catch (IOException e) {
                        AELog.debug((Throwable)e);
                    }
                }
            }
            if (!this.items.isEmpty()) {
                IItemList monitorCache = this.monitor.getStorageList();
                SPacketMEInventoryUpdate piu = new SPacketMEInventoryUpdate();
                for (IAEItemStack is : this.items) {
                    IAEItemStack send = (IAEItemStack)monitorCache.findPrecise((IAEStack)is);
                    if (send == null) {
                        is.setStackSize(0L);
                        piu.appendItem(is);
                        continue;
                    }
                    piu.appendItem(send);
                }
                if (!piu.isEmpty()) {
                    this.items.resetStatus();
                    for (Object c : this.field_75149_d) {
                        if (!(c instanceof EntityPlayer)) continue;
                        FluidCraft.proxy.netHandler.sendTo((IMessage)piu, (EntityPlayerMP)c);
                    }
                }
            }
            this.updatePowerStatus();
            boolean oldAccessible = this.canAccessViewCells;
            boolean bl = this.canAccessViewCells = this.host instanceof WirelessTerminalGuiObject || this.hasAccess(SecurityPermissions.BUILD, false);
            if (this.canAccessViewCells != oldAccessible) {
                for (int y = 0; y < 5; ++y) {
                    if (this.cellView[y] == null) continue;
                    this.cellView[y].setAllowEdit(this.canAccessViewCells);
                }
            }
            super.func_75142_b();
        }
    }

    protected void updatePowerStatus() {
        try {
            if (this.networkNode != null) {
                this.setPowered(this.networkNode.isActive());
            } else if (this.getPowerSource() instanceof IEnergyGrid) {
                this.setPowered(((IEnergyGrid)this.getPowerSource()).isNetworkPowered());
            } else {
                this.setPowered(this.getPowerSource().extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 0.8);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onUpdate(String field, Object oldValue, Object newValue) {
        if (field.equals("canAccessViewCells")) {
            for (int y = 0; y < 5; ++y) {
                if (this.cellView[y] == null) continue;
                this.cellView[y].setAllowEdit(this.canAccessViewCells);
            }
        }
        super.onUpdate(field, oldValue, newValue);
    }

    public void func_75132_a(ICrafting c) {
        super.func_75132_a(c);
        this.queueInventory(c);
    }

    private void queueInventory(ICrafting c) {
        if (Platform.isServer() && c instanceof EntityPlayer && this.monitor != null) {
            SPacketMEInventoryUpdate piu = new SPacketMEInventoryUpdate();
            IItemList monitorCache = this.monitor.getStorageList();
            for (IAEItemStack send : monitorCache) {
                try {
                    piu.appendItem(send);
                }
                catch (BufferOverflowException boe) {
                    FluidCraft.proxy.netHandler.sendTo((IMessage)piu, (EntityPlayerMP)c);
                    piu = new SPacketMEInventoryUpdate();
                    piu.appendItem(send);
                }
            }
            FluidCraft.proxy.netHandler.sendTo((IMessage)piu, (EntityPlayerMP)c);
        }
    }

    public void func_82847_b(ICrafting c) {
        super.func_82847_b(c);
        if (this.field_75149_d.isEmpty() && this.monitor != null) {
            this.monitor.removeListener((IMEMonitorHandlerReceiver)this);
        }
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (this.monitor != null) {
            this.monitor.removeListener((IMEMonitorHandlerReceiver)this);
        }
    }

    public boolean isValid(Object verificationToken) {
        return true;
    }

    public void postChange(IBaseMonitor<IAEItemStack> monitor, Iterable<IAEItemStack> change, BaseActionSource source) {
        for (IAEItemStack is : change) {
            this.items.add((IAEStack)is);
        }
    }

    public void onListUpdate() {
        for (Object c : this.field_75149_d) {
            if (!(c instanceof ICrafting)) continue;
            ICrafting cr = (ICrafting)c;
            this.queueInventory(cr);
        }
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        if (this.getGui() != null) {
            this.getGui().updateSetting(manager, settingName, newValue);
        }
    }

    public IConfigManager getConfigManager() {
        if (Platform.isServer()) {
            return this.serverCM;
        }
        return this.clientCM;
    }

    public ItemStack[] getViewCells() {
        ItemStack[] list = new ItemStack[this.cellView.length];
        for (int x = 0; x < this.cellView.length; ++x) {
            list[x] = this.cellView[x].func_75211_c();
        }
        return list;
    }

    public SlotRestrictedInput getCellViewSlot(int index) {
        return this.cellView[index];
    }

    public boolean isPowered() {
        return this.hasPower;
    }

    private void setPowered(boolean isPowered) {
        this.hasPower = isPowered;
    }

    private IConfigManagerHost getGui() {
        return this.gui;
    }

    public void setGui(@Nonnull IConfigManagerHost gui) {
        this.gui = gui;
    }
}

