/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui.container;

import appeng.api.config.SecurityPermissions;
import appeng.container.AEBaseContainer;
import appeng.helpers.InventoryAction;
import appeng.util.Platform;
import com.glodblock.github.FluidCraft;
import com.glodblock.github.common.tile.TileLevelMaintainer;
import com.glodblock.github.inventory.AeItemStackHandler;
import com.glodblock.github.inventory.slot.SlotFluidConvertingFake;
import com.glodblock.github.network.SPacketLevelMaintainerGuiUpdate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerLevelMaintainer
extends AEBaseContainer {
    private final TileLevelMaintainer tile;
    private final SlotFluidConvertingFake[] requestSlots = new SlotFluidConvertingFake[5];
    private static final int UPDATE_INTERVAL = 20;
    private boolean isFirstUpdate = true;
    private int updateCount = 20;

    public ContainerLevelMaintainer(InventoryPlayer ipl, TileLevelMaintainer tile) {
        super(ipl, (Object)tile);
        this.tile = tile;
        AeItemStackHandler request = new AeItemStackHandler(tile.getRequestSlots());
        for (int y = 0; y < 5; ++y) {
            SlotFluidConvertingFake slot = new SlotFluidConvertingFake(request, y, 27, 20 + y * 19);
            this.func_75146_a((Slot)slot);
            this.requestSlots[y] = slot;
        }
        this.bindPlayerInventory(ipl, 0, 130);
    }

    public TileLevelMaintainer getTile() {
        return this.tile;
    }

    public SlotFluidConvertingFake[] getRequestSlots() {
        return this.requestSlots;
    }

    public void doAction(EntityPlayerMP player, InventoryAction action, int slotId, long id) {
        Slot slot = this.func_75139_a(slotId);
        if (slot instanceof SlotFluidConvertingFake) {
            SlotFluidConvertingFake slot2 = (SlotFluidConvertingFake)slot;
            ItemStack stack = player.field_71071_by.func_70445_o();
            switch (action) {
                case PICKUP_OR_SET_DOWN: 
                case PLACE_SINGLE: 
                case SPLIT_OR_PLACE_SINGLE: {
                    if (stack == null) {
                        slot2.func_75215_d(null);
                        break;
                    }
                    slot2.putConvertedStack(stack);
                    break;
                }
            }
        } else {
            super.doAction(player, action, slotId, id);
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int idx) {
        if (Platform.isClient()) {
            return null;
        }
        for (int i = 0; i < this.getRequestSlots().length; ++i) {
            SlotFluidConvertingFake slot = this.getRequestSlots()[i];
            if (slot.func_75216_d()) continue;
            ItemStack itemStack = ((Slot)this.field_75151_b.get(idx)).func_75211_c();
            this.tile.updateStack(i, itemStack.func_77946_l());
            break;
        }
        this.func_75142_b();
        return null;
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (Platform.isClient()) {
            return;
        }
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (this.updateCount++ >= 20) {
            this.updateGui();
        }
    }

    public void updateGui() {
        FluidCraft.proxy.netHandler.sendTo(new SPacketLevelMaintainerGuiUpdate(this.tile.requests, !this.isFirstUpdate), (EntityPlayerMP)this.getInventoryPlayer().field_70458_d);
        this.isFirstUpdate = false;
        this.updateCount = 0;
    }
}

