/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.network;

import appeng.api.config.CraftingMode;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.container.ContainerOpenContext;
import appeng.container.implementations.ContainerCraftAmount;
import appeng.container.implementations.ContainerCraftConfirm;
import appeng.core.AELog;
import appeng.me.cache.CraftingGridCache;
import com.glodblock.github.inventory.InventoryHandler;
import com.glodblock.github.inventory.gui.GuiType;
import com.glodblock.github.inventory.item.IWirelessTerminal;
import com.glodblock.github.util.BlockPos;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class CPacketCraftRequest
implements IMessage {
    private long amount;
    private boolean heldShift;
    private CraftingMode craftingMode;

    public CPacketCraftRequest() {
    }

    public CPacketCraftRequest(int craftAmt, boolean shift) {
        this(craftAmt, shift, CraftingMode.STANDARD);
    }

    public CPacketCraftRequest(int craftAmt, boolean shift, CraftingMode craftingMode) {
        this.amount = craftAmt;
        this.heldShift = shift;
        this.craftingMode = craftingMode;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.amount);
        buf.writeBoolean(this.heldShift);
        buf.writeBoolean(this.craftingMode == CraftingMode.STANDARD);
    }

    public void fromBytes(ByteBuf buf) {
        this.amount = buf.readLong();
        this.heldShift = buf.readBoolean();
        this.craftingMode = buf.readBoolean() ? CraftingMode.STANDARD : CraftingMode.IGNORE_MISSING;
    }

    public static class Handler
    implements IMessageHandler<CPacketCraftRequest, IMessage> {
        @Nullable
        public IMessage onMessage(CPacketCraftRequest message, MessageContext ctx) {
            Container container = ctx.getServerHandler().field_147369_b.field_71070_bA;
            if (container instanceof ContainerCraftAmount) {
                ContainerCraftAmount cca = (ContainerCraftAmount)container;
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                Object target = cca.getTarget();
                if (target instanceof IGridHost) {
                    IGridHost gh = (IGridHost)target;
                    IGridNode gn = gh.getGridNode(ForgeDirection.UNKNOWN);
                    if (gn == null) {
                        return null;
                    }
                    IGrid g = gn.getGrid();
                    if (g == null || cca.getItemToCraft() == null) {
                        return null;
                    }
                    cca.getItemToCraft().setStackSize(message.amount);
                    Future futureJob = null;
                    try {
                        ICraftingGrid cg = (ICraftingGrid)g.getCache(ICraftingGrid.class);
                        if (cg instanceof CraftingGridCache) {
                            CraftingGridCache cgc = (CraftingGridCache)cg;
                            futureJob = cgc.beginCraftingJob(cca.getWorld(), cca.getGrid(), cca.getActionSrc(), cca.getItemToCraft(), message.craftingMode, null);
                        } else {
                            futureJob = cg.beginCraftingJob(cca.getWorld(), cca.getGrid(), cca.getActionSrc(), cca.getItemToCraft(), null);
                        }
                        ContainerOpenContext context = cca.getOpenContext();
                        if (context != null) {
                            TileEntity te = context.getTile();
                            if (te != null) {
                                InventoryHandler.openGui((EntityPlayer)player, player.field_70170_p, new BlockPos(te), Objects.requireNonNull(context.getSide()), GuiType.FLUID_CRAFTING_CONFIRM);
                            } else if (target instanceof IWirelessTerminal) {
                                InventoryHandler.openGui((EntityPlayer)player, player.field_70170_p, new BlockPos(((IWirelessTerminal)target).getInventorySlot(), 0, 0), Objects.requireNonNull(context.getSide()), GuiType.FLUID_CRAFTING_CONFIRM_ITEM);
                            }
                            Container container2 = player.field_71070_bA;
                            if (container2 instanceof ContainerCraftConfirm) {
                                ContainerCraftConfirm ccc = (ContainerCraftConfirm)container2;
                                ccc.setItemToCraft(cca.getItemToCraft());
                                ccc.setAutoStart(message.heldShift);
                                ccc.setJob(futureJob);
                                cca.func_75142_b();
                            }
                        }
                    }
                    catch (Throwable e) {
                        if (futureJob != null) {
                            futureJob.cancel(true);
                        }
                        AELog.debug((Throwable)e);
                    }
                }
            }
            return null;
        }
    }
}

