/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.parts;

import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.tile.inventory.BiggerAppEngInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import com.glodblock.github.client.textures.FCPartsTexture;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.common.parts.base.FCFluidEncodeTerminal;
import com.glodblock.github.inventory.gui.GuiType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class PartFluidPatternTerminalEx
extends FCFluidEncodeTerminal {
    private static final FCPartsTexture FRONT_BRIGHT_ICON = FCPartsTexture.PartFluidPatternTerminal_Bright;
    private static final FCPartsTexture FRONT_DARK_ICON = FCPartsTexture.PartFluidPatternTerminal_Colored;
    private static final FCPartsTexture FRONT_COLORED_ICON = FCPartsTexture.PartFluidPatternTerminal_Dark;

    public PartFluidPatternTerminalEx(ItemStack is) {
        super(is);
        this.crafting = new BiggerAppEngInventory((IAEAppEngInventory)this, 32);
        this.output = new BiggerAppEngInventory((IAEAppEngInventory)this, 32);
        this.craftingMode = false;
    }

    @Override
    public GuiType getGui() {
        return GuiType.FLUID_PATTERN_TERMINAL_EX;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        ICraftingPatternItem craftingPatternItem;
        ICraftingPatternDetails details;
        Item item;
        ItemStack is;
        if (inv == this.pattern && slot == 1 && (is = inv.func_70301_a(1)) != null && (item = is.func_77973_b()) instanceof ICraftingPatternItem && (details = (craftingPatternItem = (ICraftingPatternItem)item).getPatternForItem(is, this.getHost().getTile().func_145831_w())) != null) {
            int i;
            IAEItemStack[] inItems = details.getInputs();
            IAEItemStack[] outItems = details.getOutputs();
            int inputsCount = 0;
            int outputCount = 0;
            for (IAEItemStack inItem : inItems) {
                if (inItem == null) continue;
                ++inputsCount;
            }
            for (IAEItemStack outItem : outItems) {
                if (outItem == null) continue;
                ++outputCount;
            }
            this.setSubstitution(details.canSubstitute());
            if (newStack != null) {
                NBTTagCompound data = newStack.func_77978_p();
                this.setCombineMode(data.func_74762_e("combine") == 1);
                this.setBeSubstitute(details.canBeSubstitute());
            }
            this.setInverted(inputsCount <= 8 && outputCount > 8);
            this.setActivePage(0);
            for (i = 0; i < this.crafting.func_70302_i_(); ++i) {
                this.crafting.func_70299_a(i, null);
            }
            for (i = 0; i < this.output.func_70302_i_(); ++i) {
                this.output.func_70299_a(i, null);
            }
            for (i = 0; i < this.crafting.func_70302_i_() && i < inItems.length; ++i) {
                IAEItemStack item2 = inItems[i];
                if (item2 == null) continue;
                if (item2.getItem() instanceof ItemFluidDrop) {
                    ItemStack packet = ItemFluidPacket.newStack(ItemFluidDrop.getFluidStack(item2.getItemStack()));
                    this.crafting.func_70299_a(i, packet);
                    continue;
                }
                this.crafting.func_70299_a(i, item2.getItemStack());
            }
            if (this.inverted) {
                for (i = 0; i < this.output.func_70302_i_() && i < outItems.length; ++i) {
                    IAEItemStack item3 = outItems[i];
                    if (item3 == null) continue;
                    if (item3.getItem() instanceof ItemFluidDrop) {
                        ItemStack packet = ItemFluidPacket.newStack(ItemFluidDrop.getFluidStack(item3.getItemStack()));
                        this.output.func_70299_a(i, packet);
                        continue;
                    }
                    this.output.func_70299_a(i, item3.getItemStack());
                }
            } else {
                for (i = 0; i < outItems.length && i < 8; ++i) {
                    IAEItemStack item4 = outItems[i];
                    if (item4 == null) continue;
                    if (item4.getItem() instanceof ItemFluidDrop) {
                        ItemStack packet = ItemFluidPacket.newStack(ItemFluidDrop.getFluidStack(item4.getItemStack()));
                        this.output.func_70299_a(i >= 4 ? 12 + i : i, packet);
                        continue;
                    }
                    this.output.func_70299_a(i >= 4 ? 12 + i : i, item4.getItemStack());
                }
            }
        }
        this.getHost().markForSave();
    }

    @Override
    public void setCraftingRecipe(boolean craftingMode) {
        this.craftingMode = false;
    }

    @Override
    public boolean isCraftingRecipe() {
        return false;
    }

    @Override
    public FCPartsTexture getFrontBright() {
        return FRONT_BRIGHT_ICON;
    }

    @Override
    public FCPartsTexture getFrontColored() {
        return FRONT_COLORED_ICON;
    }

    @Override
    public FCPartsTexture getFrontDark() {
        return FRONT_DARK_ICON;
    }

    @Override
    public boolean isLightSource() {
        return false;
    }
}

