/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.crossmod.opencomputers;

import appeng.api.storage.data.IAEItemStack;
import appeng.util.item.AEItemStack;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.common.tile.TileLevelMaintainer;
import com.glodblock.github.inventory.AeItemStackHandler;
import com.glodblock.github.loader.ItemAndBlockHolder;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import li.cil.oc.api.driver.EnvironmentProvider;
import li.cil.oc.api.driver.NamedBlock;
import li.cil.oc.api.internal.Database;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Component;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import li.cil.oc.integration.ManagedTileEntityEnvironment;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class DriverLevelMaintainer
extends DriverSidedTileEntity {
    public Class<?> getTileEntityClass() {
        return TileLevelMaintainer.class;
    }

    public ManagedEnvironment createEnvironment(World world, int x, int y, int z, ForgeDirection forgeDirection) {
        return new Environment((TileLevelMaintainer)world.func_147438_o(x, y, z));
    }

    public static class Environment
    extends ManagedTileEntityEnvironment<TileLevelMaintainer>
    implements NamedBlock {
        public Environment(TileLevelMaintainer tileEntity) {
            super((Object)tileEntity, "level_maintainer");
        }

        private int getSlot(Arguments args, IInventory inv, int index, int def) {
            if (index >= 0 && index < args.count()) {
                int slot = args.checkInteger(index) - 1;
                if (slot < 0 || slot >= inv.func_70302_i_()) {
                    throw new IllegalArgumentException("Invalid slot");
                }
                return slot;
            }
            return def;
        }

        private boolean isDone(Arguments args) {
            int slot = args.checkInteger(0) - 1;
            if (slot < 0 || slot >= 5) {
                throw new IllegalArgumentException("Invalid slot");
            }
            return ((TileLevelMaintainer)this.tileEntity).requests.isDone(slot);
        }

        private boolean isEnable(Arguments args) {
            int slot = args.checkInteger(0) - 1;
            if (slot < 0 || slot >= 5) {
                throw new IllegalArgumentException("Invalid slot");
            }
            return ((TileLevelMaintainer)this.tileEntity).requests.isEnable(slot);
        }

        private boolean setEnable(Arguments args) {
            if (args.count() != 2) {
                throw new IllegalArgumentException("Invalid args!");
            }
            int slot = args.checkInteger(0) - 1;
            if (slot < 0 || slot >= 5) {
                throw new IllegalArgumentException("Invalid slot");
            }
            boolean enable = args.checkBoolean(1);
            ((TileLevelMaintainer)this.tileEntity).requests.updateStatus(slot, enable);
            return true;
        }

        private void updateOrder(int slot, int quantity, int batch) {
            ((TileLevelMaintainer)this.tileEntity).updateQuantity(slot, quantity);
            ((TileLevelMaintainer)this.tileEntity).updateBatchSize(slot, batch);
        }

        @Callback(doc="function([slot:number]):table -- Get the slot status.")
        public Object[] getSlot(Context context, Arguments args) {
            int slot;
            IInventory config = ((TileLevelMaintainer)this.tileEntity).getInventory();
            ItemStack stack = config.func_70301_a(slot = this.getSlot(args, config, 0, 0));
            if (stack != null) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("damage", stack.func_77960_j());
                result.put("hasTag", stack.func_77942_o());
                result.put("label", stack.func_82833_r());
                result.put("maxDamage", stack.func_77958_k());
                result.put("name", GameRegistry.findUniqueIdentifierFor((Item)stack.func_77973_b()).toString());
                result.put("quantity", ((TileLevelMaintainer)this.tileEntity).requests.getQuantity(slot));
                result.put("batch", ((TileLevelMaintainer)this.tileEntity).requests.getBatchSize(slot));
                result.put("isFluid", ItemFluidDrop.isFluidStack(stack));
                if (ItemFluidDrop.isFluidStack(stack)) {
                    result.put("fluid", ItemFluidDrop.getFluidStack(stack));
                }
                result.put("isEnable", ((TileLevelMaintainer)this.tileEntity).requests.isEnable(slot));
                result.put("isDone", ((TileLevelMaintainer)this.tileEntity).requests.isDone(slot));
                return new Object[]{result};
            }
            return new Object[]{null};
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void setSlot(int slot, String address, int index) {
            Node node = this.node().network().node(address);
            if (!(node instanceof Component)) throw new IllegalArgumentException("No such component");
            if (!(node.host() instanceof Database)) throw new IllegalArgumentException("Not a database");
            ItemStack dbStack = ((Database)node.host()).getStackInSlot(index);
            if (dbStack == null) {
                throw new IllegalArgumentException("Invalid slot");
            }
            dbStack.field_77994_a = 1;
            ((AeItemStackHandler)((TileLevelMaintainer)this.tileEntity).getInventory()).getAeInventory().setStack(slot, (IAEItemStack)AEItemStack.create((ItemStack)dbStack));
        }

        @Callback(doc="function(slot:number[,database:address[,index:number]],quantity:number,batch:number):boolean -- Configuration the slot.")
        public Object[] setSlot(Context context, Arguments args) {
            int slot = args.checkInteger(0) - 1;
            if (slot < 0 || slot >= 5) {
                throw new IllegalArgumentException("Invalid slot");
            }
            if (args.count() == 5) {
                String address = args.checkString(1);
                int index = args.checkInteger(2) - 1;
                int quantity = args.checkInteger(3);
                int batch = args.checkInteger(4);
                this.setSlot(slot, address, index);
                this.updateOrder(slot, quantity, batch);
            } else if (args.count() == 3) {
                int quantity = args.checkInteger(1);
                int batch = args.checkInteger(2);
                this.updateOrder(slot, quantity, batch);
            } else {
                throw new IllegalArgumentException("Invalid args");
            }
            return new Object[]{true};
        }

        private boolean isActive() {
            return ((TileLevelMaintainer)this.tileEntity).isActive();
        }

        @Callback(doc="function(slot:number):boolean -- Get the crafting task state.")
        public Object[] isDone(Context context, Arguments args) {
            return new Object[]{this.isDone(args)};
        }

        @Callback(doc="function(slot:number):boolean -- Get the crafting state of slot.")
        public Object[] isEnable(Context context, Arguments args) {
            return new Object[]{this.isEnable(args)};
        }

        @Callback(doc="function(slot:number,value:boolean):boolean -- Set the crafting state of slot.")
        public Object[] setEnable(Context context, Arguments args) {
            return new Object[]{this.setEnable(args)};
        }

        @Callback(doc="function():boolean Get Level Maintainer state")
        public Object[] active(Context context, Arguments args) {
            return new Object[]{this.isActive()};
        }

        public String preferredName() {
            return "level_maintainer";
        }

        public int priority() {
            return 6;
        }
    }

    public static class Provider
    implements EnvironmentProvider {
        Provider() {
        }

        public Class<?> getEnvironment(ItemStack itemStack) {
            if (itemStack != null && itemStack.func_77969_a(ItemAndBlockHolder.LEVEL_MAINTAINER.stack())) {
                return Environment.class;
            }
            return null;
        }
    }
}

