/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.block;

import appeng.api.implementations.items.IAEWrench;
import com.glodblock.github.common.block.BaseBlockContainer;
import com.glodblock.github.common.item.ItemCertusQuartzTank;
import com.glodblock.github.common.tabs.FluidCraftingTabs;
import com.glodblock.github.common.tile.TileCertusQuartzTank;
import com.glodblock.github.loader.ChannelLoader;
import com.glodblock.github.loader.IRegister;
import com.glodblock.github.loader.ItemAndBlockHolder;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BlockCertusQuartzTank
extends BaseBlockContainer
implements IRegister<BlockCertusQuartzTank> {
    IIcon breakIcon;
    IIcon topIcon;
    IIcon bottomIcon;
    IIcon sideIcon;
    IIcon sideMiddleIcon;
    IIcon sideTopIcon;
    IIcon sideBottomIcon;

    public BlockCertusQuartzTank() {
        super(Material.field_151592_s);
        this.func_149663_c("certus_quartz_tank");
        this.func_149752_b(10.0f);
        this.func_149711_c(2.0f);
        this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 1.0f, 0.9375f);
    }

    public boolean canRenderInPass(int pass) {
        return true;
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileCertusQuartzTank();
    }

    public ItemStack getDropWithNBT(World world, int x, int y, int z) {
        NBTTagCompound tileEntity = new NBTTagCompound();
        TileEntity worldTE = world.func_147438_o(x, y, z);
        if (worldTE instanceof TileCertusQuartzTank) {
            ItemStack dropStack = new ItemStack((Block)ItemAndBlockHolder.CERTUS_QUARTZ_TANK, 1);
            ((TileCertusQuartzTank)worldTE).writeToNBTWithoutCoords(tileEntity);
            if (!tileEntity.func_74764_b("Empty")) {
                dropStack.func_77982_d(new NBTTagCompound());
                dropStack.field_77990_d.func_74782_a("tileEntity", (NBTBase)tileEntity);
            }
            return dropStack;
        }
        return null;
    }

    public IIcon func_149691_a(int side, int meta) {
        switch (meta) {
            case 1: {
                return this.sideTopIcon;
            }
            case 2: {
                return this.sideBottomIcon;
            }
            case 3: {
                return this.sideMiddleIcon;
            }
        }
        return side == 0 ? this.bottomIcon : (side == 1 ? this.topIcon : this.sideIcon);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        return this.getDropWithNBT(world, x, y, z);
    }

    public boolean func_149662_c() {
        return false;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileCertusQuartzTank) {
            TileCertusQuartzTank tank = (TileCertusQuartzTank)tile;
            return tank.getFluidLightLevel();
        }
        return super.getLightValue(world, x, y, z);
    }

    public boolean func_149727_a(World worldObj, int x, int y, int z, EntityPlayer entityplayer, int blockID, float offsetX, float offsetY, float offsetZ) {
        ItemStack current = entityplayer.field_71071_by.func_70448_g();
        if (entityplayer.func_70093_af() && current != null && current.func_77973_b() instanceof IAEWrench && ((IAEWrench)current.func_77973_b()).canWrench(current, entityplayer, x, y, z)) {
            this.func_149642_a(worldObj, x, y, z, this.getDropWithNBT(worldObj, x, y, z));
            worldObj.func_147468_f(x, y, z);
            return true;
        }
        if (current != null) {
            ItemStack filled;
            FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)current);
            TileCertusQuartzTank tank = (TileCertusQuartzTank)worldObj.func_147438_o(x, y, z);
            if (liquid != null) {
                int amountFilled = tank.fill(ForgeDirection.UNKNOWN, liquid, true);
                if (amountFilled != 0 && !entityplayer.field_71075_bZ.field_75098_d && current.func_77973_b() != null) {
                    if (current.field_77994_a > 1) {
                        --entityplayer.field_71071_by.field_70462_a[entityplayer.field_71071_by.field_70461_c].field_77994_a;
                        entityplayer.field_71071_by.func_70441_a(current.func_77973_b().getContainerItem(current));
                    } else {
                        entityplayer.field_71071_by.field_70462_a[entityplayer.field_71071_by.field_70461_c] = current.func_77973_b().getContainerItem(current);
                    }
                }
                return true;
            }
            FluidStack available = tank.getTankInfo((ForgeDirection)ForgeDirection.UNKNOWN)[0].fluid;
            if (available != null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)(filled = FluidContainerRegistry.fillFluidContainer((FluidStack)available, (ItemStack)current)))) != null) {
                tank.drain(ForgeDirection.UNKNOWN, liquid.amount, true);
                if (!entityplayer.field_71075_bZ.field_75098_d) {
                    if (current.field_77994_a == 1) {
                        entityplayer.field_71071_by.field_70462_a[entityplayer.field_71071_by.field_70461_c] = filled;
                    } else {
                        --entityplayer.field_71071_by.field_70462_a[entityplayer.field_71071_by.field_70461_c].field_77994_a;
                        if (!entityplayer.field_71071_by.func_70441_a(filled)) {
                            entityplayer.func_70099_a(filled, 0.0f);
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighborBlock) {
        if (!world.field_72995_K) {
            ChannelLoader.sendPacketToAllPlayers(world.func_147438_o(x, y, z).func_145844_m(), world);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (stack != null && stack.func_77942_o() && FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("tileEntity")) != null) {
            list.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l((String)"tileEntity")).amount + "mB");
        }
    }

    public void func_149651_a(IIconRegister iconregister) {
        String folder = "ae2fc:certus_quartz_tank/";
        this.breakIcon = iconregister.func_94245_a(folder + "cube");
        this.topIcon = iconregister.func_94245_a(folder + "top");
        this.bottomIcon = iconregister.func_94245_a(folder + "bottom");
        this.sideIcon = iconregister.func_94245_a(folder + "side");
        this.sideMiddleIcon = iconregister.func_94245_a(folder + "side_mid");
        this.sideTopIcon = iconregister.func_94245_a(folder + "side_top");
        this.sideBottomIcon = iconregister.func_94245_a(folder + "side_bottom");
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public BlockCertusQuartzTank register() {
        GameRegistry.registerBlock((Block)this, ItemCertusQuartzTank.class, (String)"certus_quartz_tank");
        GameRegistry.registerTileEntity(TileCertusQuartzTank.class, (String)"certus_quartz_tank");
        this.func_149647_a(FluidCraftingTabs.INSTANCE);
        return this;
    }
}

