/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui.container;

import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketCompressedNBT;
import appeng.helpers.DualityInterface;
import appeng.helpers.IInterfaceHost;
import appeng.helpers.InventoryAction;
import appeng.items.misc.ItemEncodedPattern;
import appeng.parts.AEBasePart;
import appeng.parts.misc.PartInterface;
import appeng.parts.p2p.PartP2PInterface;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.misc.TileInterface;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorIInventory;
import appeng.util.inv.AdaptorPlayerHand;
import appeng.util.inv.ItemSlot;
import appeng.util.inv.WrapperInvSlot;
import com.glodblock.github.client.gui.container.base.FCBaseContainer;
import com.glodblock.github.common.parts.PartFluidInterface;
import com.glodblock.github.common.tile.TileFluidInterface;
import com.glodblock.github.inventory.item.IWirelessTerminal;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class ContainerInterfaceWireless
extends FCBaseContainer {
    private static long autoBase = Long.MIN_VALUE;
    private final Multimap<IInterfaceHost, InvTracker> diList = HashMultimap.create();
    private final Map<Long, InvTracker> byId = new HashMap<Long, InvTracker>();
    private IGrid grid;
    private NBTTagCompound data = new NBTTagCompound();

    public ContainerInterfaceWireless(InventoryPlayer ip, IWirelessTerminal monitorable) {
        super(ip, monitorable);
        if (Platform.isServer()) {
            this.grid = monitorable.getActionableNode().getGrid();
        }
        this.bindPlayerInventory(ip, 14, 0);
    }

    private Set<IGridNode> getMachineNodes() {
        HashSet<IGridNode> union = new HashSet<IGridNode>();
        this.grid.getMachines(TileFluidInterface.class).forEach(union::add);
        this.grid.getMachines(TileInterface.class).forEach(union::add);
        this.grid.getMachines(PartFluidInterface.class).forEach(union::add);
        this.grid.getMachines(PartInterface.class).forEach(union::add);
        this.grid.getMachines(PartP2PInterface.class).forEach(union::add);
        return union;
    }

    @Override
    public void func_75142_b() {
        IGridNode agn;
        if (Platform.isClient()) {
            return;
        }
        super.func_75142_b();
        if (this.grid == null) {
            return;
        }
        int total = 0;
        boolean missing = false;
        IActionHost host = this.getActionHost();
        if (host != null && (agn = host.getActionableNode()) != null && agn.isActive()) {
            for (IGridNode gn : this.getMachineNodes()) {
                InterfaceCheck interfaceCheck = new InterfaceCheck().invoke(gn);
                total += interfaceCheck.getTotal();
                missing |= interfaceCheck.isMissing();
            }
        }
        if (total != this.diList.size() || missing) {
            this.regenList(this.data);
        } else {
            for (InvTracker inv : this.diList.values()) {
                for (int x = 0; x < inv.client.func_70302_i_(); ++x) {
                    if (!this.isDifferent(inv.server.func_70301_a(inv.offset + x), inv.client.func_70301_a(x))) continue;
                    this.addItems(this.data, inv, x, 1);
                }
            }
        }
        if (!this.data.func_82582_d()) {
            try {
                NetworkHandler.instance.sendTo((AppEngPacket)new PacketCompressedNBT(this.data), (EntityPlayerMP)this.getPlayerInv().field_70458_d);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.data = new NBTTagCompound();
        }
    }

    public void doAction(EntityPlayerMP player, InventoryAction action, int slot, long id) {
        InvTracker inv = this.byId.get(id);
        if (inv != null) {
            ItemStack is = inv.server.func_70301_a(slot + inv.offset);
            boolean hasItemInHand = player.field_71071_by.func_70445_o() != null;
            AdaptorPlayerHand playerHand = new AdaptorPlayerHand((EntityPlayer)player);
            PatternInvSlot slotInv = new PatternInvSlot(inv.server);
            IInventory theSlot = slotInv.getWrapper(slot + inv.offset);
            AdaptorIInventory interfaceSlot = new AdaptorIInventory(theSlot);
            IInventory interfaceHandler = inv.server;
            boolean canInsert = true;
            switch (action) {
                case PICKUP_OR_SET_DOWN: {
                    if (hasItemInHand) {
                        for (int s = 0; s < interfaceHandler.func_70302_i_(); ++s) {
                            if (!Platform.isSameItemPrecise((ItemStack)interfaceHandler.func_70301_a(s), (ItemStack)player.field_71071_by.func_70445_o())) continue;
                            canInsert = false;
                            break;
                        }
                        if (!canInsert) break;
                        ItemStack inSlot = theSlot.func_70301_a(0);
                        if (inSlot == null) {
                            player.field_71071_by.func_70437_b(interfaceSlot.addItems(player.field_71071_by.func_70445_o()));
                            break;
                        }
                        inSlot = inSlot.func_77946_l();
                        ItemStack inHand = player.field_71071_by.func_70445_o().func_77946_l();
                        theSlot.func_70299_a(0, null);
                        player.field_71071_by.func_70437_b(null);
                        player.field_71071_by.func_70437_b(interfaceSlot.addItems(inHand.func_77946_l()));
                        if (player.field_71071_by.func_70445_o() == null) {
                            player.field_71071_by.func_70437_b(inSlot);
                            break;
                        }
                        player.field_71071_by.func_70437_b(inHand);
                        theSlot.func_70299_a(0, inSlot);
                        break;
                    }
                    IInventory mySlot = slotInv.getWrapper(slot + inv.offset);
                    mySlot.func_70299_a(0, playerHand.addItems(mySlot.func_70301_a(0)));
                    break;
                }
                case SPLIT_OR_PLACE_SINGLE: {
                    if (hasItemInHand) {
                        for (int s = 0; s < interfaceHandler.func_70302_i_(); ++s) {
                            if (!Platform.isSameItemPrecise((ItemStack)interfaceHandler.func_70301_a(s), (ItemStack)player.field_71071_by.func_70445_o())) continue;
                            canInsert = false;
                            break;
                        }
                        if (!canInsert) break;
                        ItemStack extra = playerHand.removeItems(1, null, null);
                        if (extra != null && !interfaceSlot.containsItems()) {
                            extra = interfaceSlot.addItems(extra);
                        }
                        if (extra == null) break;
                        playerHand.addItems(extra);
                        break;
                    }
                    if (is == null) break;
                    ItemStack extra = interfaceSlot.removeItems((is.field_77994_a + 1) / 2, null, null);
                    if (extra != null) {
                        extra = playerHand.addItems(extra);
                    }
                    if (extra == null) break;
                    interfaceSlot.addItems(extra);
                    break;
                }
                case SHIFT_CLICK: {
                    IInventory mySlot = slotInv.getWrapper(slot + inv.offset);
                    InventoryAdaptor playerInv = InventoryAdaptor.getAdaptor((Object)player, (ForgeDirection)ForgeDirection.UNKNOWN);
                    mySlot.func_70299_a(0, this.mergeToPlayerInventory(playerInv, mySlot.func_70301_a(0)));
                    break;
                }
                case MOVE_REGION: {
                    InventoryAdaptor playerInvAd = InventoryAdaptor.getAdaptor((Object)player, (ForgeDirection)ForgeDirection.UNKNOWN);
                    for (int x = 0; x < inv.client.func_70302_i_(); ++x) {
                        inv.server.func_70299_a(x + inv.offset, this.mergeToPlayerInventory(playerInvAd, inv.server.func_70301_a(x + inv.offset)));
                    }
                    break;
                }
                case CREATIVE_DUPLICATE: {
                    if (!player.field_71075_bZ.field_75098_d || hasItemInHand) break;
                    player.field_71071_by.func_70437_b(is == null ? null : is.func_77946_l());
                    break;
                }
                default: {
                    return;
                }
            }
            this.updateHeld(player);
        }
    }

    private ItemStack mergeToPlayerInventory(InventoryAdaptor playerInv, ItemStack stack) {
        if (stack == null) {
            return null;
        }
        for (ItemSlot slot : playerInv) {
            if (!Platform.isSameItemPrecise((ItemStack)slot.getItemStack(), (ItemStack)stack) || slot.getItemStack().field_77994_a >= slot.getItemStack().func_77976_d()) continue;
            ++slot.getItemStack().field_77994_a;
            return null;
        }
        return playerInv.addItems(stack);
    }

    private void regenList(NBTTagCompound data) {
        IGridNode agn;
        this.byId.clear();
        this.diList.clear();
        IActionHost host = this.getActionHost();
        if (host != null && (agn = host.getActionableNode()) != null && agn.isActive()) {
            for (IGridNode gn : this.getMachineNodes()) {
                IInterfaceHost ih = (IInterfaceHost)gn.getMachine();
                DualityInterface dual = ih.getInterfaceDuality();
                if (!gn.isActive() || dual.getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) != YesNo.YES) continue;
                for (int i = 0; i <= dual.getInstalledUpgrades(Upgrades.PATTERN_CAPACITY); ++i) {
                    this.diList.put((Object)ih, (Object)new InvTracker(dual, dual.getPatterns(), dual.getTermName(), i * 9, 9));
                }
            }
        }
        data.func_74757_a("clear", true);
        for (InvTracker inv : this.diList.values()) {
            this.byId.put(inv.which, inv);
            this.addItems(data, inv, 0, inv.client.func_70302_i_());
        }
    }

    @Override
    protected boolean isWirelessTerminal() {
        return true;
    }

    private boolean isDifferent(ItemStack a, ItemStack b) {
        if (a == null && b == null) {
            return false;
        }
        if (a == null || b == null) {
            return true;
        }
        return !ItemStack.func_77989_b((ItemStack)a, (ItemStack)b);
    }

    private void addItems(NBTTagCompound data, InvTracker inv, int offset, int length) {
        String name = '=' + Long.toString(inv.which, 36);
        NBTTagCompound tag = data.func_74775_l(name);
        if (tag.func_82582_d()) {
            tag.func_74772_a("sortBy", inv.sortBy);
            tag.func_74778_a("un", inv.unlocalizedName);
            tag.func_74768_a("x", inv.X);
            tag.func_74768_a("y", inv.Y);
            tag.func_74768_a("z", inv.Z);
            tag.func_74768_a("dim", inv.dim);
            tag.func_74768_a("side", inv.side.ordinal());
        }
        for (int x = 0; x < length; ++x) {
            NBTTagCompound itemNBT = new NBTTagCompound();
            ItemStack is = inv.server.func_70301_a(x + offset + inv.offset);
            inv.client.func_70299_a(offset + x, is == null ? null : is.func_77946_l());
            if (is != null) {
                is.func_77955_b(itemNBT);
            }
            tag.func_74782_a(Integer.toString(x + offset), (NBTBase)itemNBT);
        }
        data.func_74782_a(name, (NBTBase)tag);
    }

    static /* synthetic */ long access$1108() {
        return autoBase++;
    }

    private class InterfaceCheck {
        int total = 0;
        boolean missing = false;

        public int getTotal() {
            return this.total;
        }

        public boolean isMissing() {
            return this.missing;
        }

        public InterfaceCheck invoke(IGridNode gn) {
            if (gn.isActive()) {
                IInterfaceHost ih = (IInterfaceHost)gn.getMachine();
                if (ih.getInterfaceDuality().getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) == YesNo.NO || ih instanceof PartP2PInterface && ((PartP2PInterface)ih).isOutput()) {
                    return this;
                }
                Collection t = ContainerInterfaceWireless.this.diList.get((Object)ih);
                if (t.isEmpty()) {
                    this.missing = true;
                } else {
                    DualityInterface dual = ih.getInterfaceDuality();
                    for (InvTracker it : t) {
                        if (it.unlocalizedName.equals(dual.getTermName())) continue;
                        this.missing = true;
                    }
                }
                this.total += ih.getInterfaceDuality().getInstalledUpgrades(Upgrades.PATTERN_CAPACITY) + 1;
            }
            return this;
        }
    }

    private static class PatternInvSlot
    extends WrapperInvSlot {
        public PatternInvSlot(IInventory inv) {
            super(inv);
        }

        public boolean isItemValid(ItemStack itemstack) {
            return itemstack != null && itemstack.func_77973_b() instanceof ItemEncodedPattern;
        }
    }

    private static class InvTracker {
        private final long sortBy;
        private final long which = ContainerInterfaceWireless.access$1108();
        private final String unlocalizedName;
        private final IInventory client;
        private final IInventory server;
        private final int offset;
        private final int X;
        private final int Y;
        private final int Z;
        private final int dim;
        private final ForgeDirection side;

        public InvTracker(DualityInterface dual, IInventory patterns, String unlocalizedName, int offset, int size) {
            this.server = patterns;
            this.client = new AppEngInternalInventory(null, size);
            this.unlocalizedName = unlocalizedName;
            this.sortBy = dual.getSortValue() + (long)offset << 16;
            this.offset = offset;
            this.X = dual.getLocation().x;
            this.Y = dual.getLocation().y;
            this.Z = dual.getLocation().z;
            this.dim = dual.getLocation().getDimension();
            this.side = dual.getHost() instanceof AEBasePart ? ((AEBasePart)dual.getHost()).getSide() : ForgeDirection.UNKNOWN;
        }
    }
}

