/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.network;

import appeng.api.AEApi;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import com.glodblock.github.client.gui.container.ContainerItemMonitor;
import com.glodblock.github.client.gui.container.base.FCContainerEncodeTerminal;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.nei.NEIUtils;
import com.glodblock.github.nei.object.OrderStack;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class CPacketTransferRecipe
implements IMessage {
    private List<OrderStack<?>> inputs;
    private List<OrderStack<?>> outputs;
    private boolean isCraft;
    private static final int MAX_INDEX = 32;
    private boolean shift;

    public CPacketTransferRecipe() {
    }

    public CPacketTransferRecipe(List<OrderStack<?>> IN, List<OrderStack<?>> OUT, boolean craft) {
        this(IN, OUT, craft, false);
    }

    public CPacketTransferRecipe(List<OrderStack<?>> IN, List<OrderStack<?>> OUT, boolean craft, boolean shift) {
        this.inputs = IN;
        this.outputs = OUT;
        this.isCraft = craft;
        this.shift = shift;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.isCraft);
        buf.writeBoolean(this.shift);
        NBTTagCompound nbt_m = new NBTTagCompound();
        NBTTagCompound nbt_i = new NBTTagCompound();
        NBTTagCompound nbt_o = new NBTTagCompound();
        for (OrderStack<?> stack : this.inputs) {
            stack.writeToNBT(nbt_i);
        }
        for (OrderStack<?> stack : this.outputs) {
            stack.writeToNBT(nbt_o);
        }
        nbt_m.func_74782_a("i", (NBTBase)nbt_i);
        nbt_m.func_74782_a("o", (NBTBase)nbt_o);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)nbt_m);
    }

    public void fromBytes(ByteBuf buf) {
        OrderStack<?> tmp;
        int i;
        this.isCraft = buf.readBoolean();
        this.shift = buf.readBoolean();
        this.inputs = new LinkedList();
        this.outputs = new LinkedList();
        NBTTagCompound nbt_m = ByteBufUtils.readTag((ByteBuf)buf);
        NBTTagCompound nbt_i = nbt_m.func_74775_l("i");
        NBTTagCompound nbt_o = nbt_m.func_74775_l("o");
        for (i = 0; i < 32; ++i) {
            tmp = OrderStack.readFromNBT(nbt_i, null, i);
            if (tmp == null) continue;
            this.inputs.add(tmp);
        }
        for (i = 0; i < 32; ++i) {
            tmp = OrderStack.readFromNBT(nbt_o, null, i);
            if (tmp == null) continue;
            this.outputs.add(tmp);
        }
    }

    public static class Handler
    implements IMessageHandler<CPacketTransferRecipe, IMessage> {
        @Nullable
        public IMessage onMessage(CPacketTransferRecipe message, MessageContext ctx) {
            Container c = ctx.getServerHandler().field_147369_b.field_71070_bA;
            if (c instanceof ContainerItemMonitor) {
                IMEMonitor monitor = ((ContainerItemMonitor)c).getMonitor();
                IItemList storageList = AEApi.instance().storage().createItemList();
                if (monitor != null) {
                    storageList = monitor.getStorageList();
                }
                if (c instanceof FCContainerEncodeTerminal) {
                    int i;
                    FCContainerEncodeTerminal cf = (FCContainerEncodeTerminal)c;
                    boolean combine = cf.combine;
                    cf.getPatternTerminal().setCraftingRecipe(message.isCraft);
                    IInventory inputSlot = cf.getInventoryByName("crafting");
                    IInventory outputSlot = cf.getInventoryByName("output");
                    for (i = 0; i < inputSlot.func_70302_i_(); ++i) {
                        inputSlot.func_70299_a(i, null);
                    }
                    for (i = 0; i < outputSlot.func_70302_i_(); ++i) {
                        outputSlot.func_70299_a(i, null);
                    }
                    if (!message.isCraft) {
                        if (combine) {
                            message.inputs = NEIUtils.compress(message.inputs);
                            message.outputs = NEIUtils.compress(message.outputs);
                        }
                        message.inputs = NEIUtils.clearNull(message.inputs);
                        message.outputs = NEIUtils.clearNull(message.outputs);
                    }
                    if (message.shift && !storageList.isEmpty()) {
                        for (OrderStack stack : message.inputs) {
                            IAEItemStack iaeItemStack;
                            if (stack.getStack() instanceof FluidStack || stack.getItems() == null || storageList.findPrecise((IAEStack)(iaeItemStack = AEApi.instance().storage().createItemStack((ItemStack)stack.getStack()))) != null) continue;
                            for (ItemStack replaceItemStack : stack.getItems()) {
                                if (storageList.findPrecise((IAEStack)AEApi.instance().storage().createItemStack(replaceItemStack)) == null) continue;
                                stack.putStack(replaceItemStack);
                            }
                        }
                    }
                    this.transferPack(message.inputs, inputSlot);
                    this.transferPack(message.outputs, outputSlot);
                    c.func_75130_a(inputSlot);
                    c.func_75130_a(outputSlot);
                }
            }
            return null;
        }

        private void transferPack(List<OrderStack<?>> packs, IInventory inv) {
            for (OrderStack<?> stack : packs) {
                ItemStack stack1;
                if (stack == null) continue;
                int index = stack.getIndex();
                if (stack.getStack() instanceof ItemStack) {
                    stack1 = ((ItemStack)stack.getStack()).func_77946_l();
                } else if (stack.getStack() instanceof FluidStack) {
                    stack1 = ItemFluidPacket.newStack((FluidStack)stack.getStack());
                } else {
                    throw new UnsupportedOperationException("Trying to get an unsupported item!");
                }
                if (index >= inv.func_70302_i_()) continue;
                inv.func_70299_a(index, stack1);
            }
        }
    }
}

