/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.util.calendar;

import com.darkona.adventurebackpack.util.calendar.CalendarDate;

public class CalendarImpl {
    private int[] month_list = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public static int getWeekday(int absDate) {
        return absDate % 7;
    }

    public int getLastDayOfGregorianMonth(int month, int year) {
        if (month == 2 && year % 4 == 0 && year % 400 != 100 && year % 400 != 200 && year % 400 != 300) {
            return 29;
        }
        return this.month_list[month - 1];
    }

    public int absoluteFromGregorianDate(CalendarDate date) {
        int value = date.getDay();
        for (int m = 1; m < date.getMonth(); ++m) {
            value += this.getLastDayOfGregorianMonth(m, date.getYear());
        }
        value += 365 * (date.getYear() - 1);
        value += (date.getYear() - 1) / 4;
        value -= (date.getYear() - 1) / 100;
        return value += (date.getYear() - 1) / 400;
    }

    public CalendarDate gregorianDateFromAbsolute(int absDate) {
        int temp;
        int approx;
        int y = approx = absDate / 366;
        while (absDate >= (temp = this.absoluteFromGregorianDate(new CalendarDate(1, 1, y + 1)))) {
            ++y;
        }
        int year = y;
        int m = 1;
        while (absDate > (temp = this.absoluteFromGregorianDate(new CalendarDate(this.getLastDayOfGregorianMonth(m, year), m, year)))) {
            ++m;
        }
        int month = m;
        temp = this.absoluteFromGregorianDate(new CalendarDate(1, month, year));
        int day = absDate - temp + 1;
        return new CalendarDate(day, month, year);
    }

    public boolean hebrewLeapYear(int year) {
        return (year * 7 + 1) % 19 < 7;
    }

    public int getLastMonthOfJewishYear(int year) {
        if (this.hebrewLeapYear(year)) {
            return 13;
        }
        return 12;
    }

    public int getLastDayOfJewishMonth(int month, int year) {
        if (month == 2 || month == 4 || month == 6 || month == 10 || month == 13) {
            return 29;
        }
        if (month == 12 && !this.hebrewLeapYear(year)) {
            return 29;
        }
        if (month == 8 && !this.longHeshvan(year)) {
            return 29;
        }
        if (month == 9 && this.shortKislev(year)) {
            return 29;
        }
        return 30;
    }

    private int hebrewCalendarElapsedDays(int year) {
        int value;
        int monthsElapsed = value = 235 * ((year - 1) / 19);
        value = 12 * ((year - 1) % 19);
        monthsElapsed += value;
        value = ((year - 1) % 19 * 7 + 1) / 19;
        int partsElapsed = (monthsElapsed += value) % 1080 * 793 + 204;
        int hoursElapsed = 5 + monthsElapsed * 12 + monthsElapsed / 1080 * 793 + partsElapsed / 1080;
        int day = 1 + 29 * monthsElapsed + hoursElapsed / 24;
        int parts = hoursElapsed % 24 * 1080 + partsElapsed % 1080;
        int alternativeDay = parts >= 19440 || day % 7 == 2 && parts >= 9924 && !this.hebrewLeapYear(year) || day % 7 == 1 && parts >= 16789 && this.hebrewLeapYear(year - 1) ? day + 1 : day;
        if (alternativeDay % 7 == 0 || alternativeDay % 7 == 3 || alternativeDay % 7 == 5) {
            ++alternativeDay;
        }
        return alternativeDay;
    }

    private int daysInHebrewYear(int year) {
        return this.hebrewCalendarElapsedDays(year + 1) - this.hebrewCalendarElapsedDays(year);
    }

    private boolean longHeshvan(int year) {
        return this.daysInHebrewYear(year) % 10 == 5;
    }

    private boolean shortKislev(int year) {
        return this.daysInHebrewYear(year) % 10 == 3;
    }

    public int absoluteFromJewishDate(CalendarDate date) {
        int value;
        int returnValue = value = date.getDay();
        if (date.getMonth() < 7) {
            int m;
            for (m = 7; m <= this.getLastMonthOfJewishYear(date.getYear()); ++m) {
                value = this.getLastDayOfJewishMonth(m, date.getYear());
                returnValue += value;
            }
            for (m = 1; m < date.getMonth(); ++m) {
                value = this.getLastDayOfJewishMonth(m, date.getYear());
                returnValue += value;
            }
        } else {
            for (int m = 7; m < date.getMonth(); ++m) {
                value = this.getLastDayOfJewishMonth(m, date.getYear());
                returnValue += value;
            }
        }
        value = this.hebrewCalendarElapsedDays(date.getYear());
        returnValue += value;
        value = 1373429;
        return returnValue -= value;
    }

    public CalendarDate jewishDateFromAbsolute(int absDate) {
        int temp;
        int approx;
        int y = approx = (absDate + 1373429) / 366;
        while (absDate >= (temp = this.absoluteFromJewishDate(new CalendarDate(1, 7, y + 1)))) {
            ++y;
        }
        int year = y;
        temp = this.absoluteFromJewishDate(new CalendarDate(1, 1, year));
        int start = absDate < temp ? 7 : 1;
        int m = start;
        while (absDate > (temp = this.absoluteFromJewishDate(new CalendarDate(this.getLastDayOfJewishMonth(m, year), m, year)))) {
            ++m;
        }
        int month = m;
        temp = this.absoluteFromJewishDate(new CalendarDate(1, month, year));
        int day = absDate - temp + 1;
        return new CalendarDate(day, month, year);
    }
}

