/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.client.gui;

import com.darkona.adventurebackpack.client.gui.GuiImageButtonNormal;
import com.darkona.adventurebackpack.client.gui.GuiTank;
import com.darkona.adventurebackpack.client.gui.GuiWithTanks;
import com.darkona.adventurebackpack.common.Constants;
import com.darkona.adventurebackpack.config.ConfigHandler;
import com.darkona.adventurebackpack.inventory.ContainerCopter;
import com.darkona.adventurebackpack.inventory.InventoryCopterPack;
import com.darkona.adventurebackpack.reference.GeneralReference;
import com.darkona.adventurebackpack.util.Resources;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidTank;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.opengl.GL11;

public class GuiCopterPack
extends GuiWithTanks {
    private static final ResourceLocation TEXTURE = Resources.guiTextures("guiCopterPack");
    private static GuiImageButtonNormal equipButton = new GuiImageButtonNormal(150, 64, 18, 18);
    private static GuiImageButtonNormal unequipButton = new GuiImageButtonNormal(150, 64, 18, 18);
    private static GuiTank fuelTank = new GuiTank(8, 8, 72, 32, ConfigHandler.typeTankRender);
    private InventoryCopterPack inventory;

    public GuiCopterPack(EntityPlayer player, InventoryCopterPack inv, Constants.Source source) {
        super(new ContainerCopter(player, inv, source));
        this.player = player;
        this.inventory = inv;
        this.source = source;
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    protected void func_146976_a(float p_146976_1_, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.source == Constants.Source.WEARING) {
            if (unequipButton.inButton(this, mouseX, mouseY)) {
                unequipButton.draw(this, 20, 186);
            } else {
                unequipButton.draw(this, 1, 186);
            }
        } else if (this.source == Constants.Source.HOLDING) {
            if (equipButton.inButton(this, mouseX, mouseY)) {
                equipButton.draw(this, 20, 167);
            } else {
                equipButton.draw(this, 1, 167);
            }
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        this.inventory.func_70295_k_();
        FluidTank tank = this.inventory.getFuelTank();
        fuelTank.draw(this, tank);
        GL11.glPushMatrix();
        boolean isFilled = tank.getFluid() != null;
        String name = isFilled ? WordUtils.capitalize((String)tank.getFluid().getFluid().getName()) : "None";
        String amount = isFilled ? "" + tank.getFluid().amount : "0";
        String capacity = Integer.toString(tank.getCapacity());
        int offsetY = 8;
        int offsetX = 83;
        this.field_146289_q.func_85187_a(name, 1 + offsetX, offsetY, 0x373737, false);
        this.field_146289_q.func_85187_a(amount, 1 + offsetX, 10 + offsetY, 0x373737, false);
        this.field_146289_q.func_85187_a(capacity, 1 + offsetX, 20 + offsetY, 0x373737, false);
        if (isFilled) {
            Float rate = GeneralReference.getFuelRate(name.toLowerCase());
            String conLev = rate != null ? rate.toString() : "0";
            this.field_146289_q.func_85187_a("Consumption: " + conLev, 1 + offsetX, 40 + offsetY, 0x373737, false);
        }
        GL11.glPopMatrix();
    }

    @Override
    protected GuiImageButtonNormal getEquipButton() {
        return equipButton;
    }

    @Override
    protected GuiImageButtonNormal getUnequipButton() {
        return unequipButton;
    }
}

