/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.reference;

import com.darkona.adventurebackpack.config.ConfigHandler;
import com.darkona.adventurebackpack.reference.LoadedMods;
import com.darkona.adventurebackpack.util.LogHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fluids.FluidRegistry;

public class GeneralReference {
    private static HashMap<String, Float> liquidFuels = new HashMap();
    private static Set<Integer> dimensionBlacklist = new HashSet<Integer>();
    private static final float MAX_RATE = 20.0f;
    private static final float MIN_RATE = 0.05f;

    public static void init() {
        GeneralReference.parseLiquidFuelsConfig();
        GeneralReference.parseDimensionBlacklistConfig();
        if (LoadedMods.DEV_ENV) {
            liquidFuels.put("holywater", Float.valueOf(0.0f));
        }
    }

    private static void parseDimensionBlacklistConfig() {
        for (String dim : ConfigHandler.forbiddenDimensions) {
            int dimID;
            try {
                dimID = Integer.parseInt(dim);
            }
            catch (NumberFormatException nfe) {
                LogHelper.error("Cannot parse Forbidden Dimension ID for " + dim + ". Ignored");
                continue;
            }
            if (DimensionManager.isDimensionRegistered((int)dimID)) {
                dimensionBlacklist.add(dimID);
                LogHelper.info("Dimension " + dimID + " is registered as Forbidden for Adventure Backpack");
                continue;
            }
            LogHelper.info("Not found dimension " + dimID + ". Skipped");
        }
    }

    private static void parseLiquidFuelsConfig() {
        int wrongCount = 0;
        int unregCount = 0;
        for (String fuel : ConfigHandler.copterFuels) {
            String[] arrFuel = fuel.replaceAll(" ", "").split(",");
            if (arrFuel.length != 2) {
                ++wrongCount;
                continue;
            }
            String fluid = arrFuel[0];
            if (FluidRegistry.isFluidRegistered((String)fluid)) {
                float rate;
                try {
                    rate = Float.parseFloat(arrFuel[1]);
                }
                catch (NumberFormatException nfe) {
                    rate = 20.0f;
                    LogHelper.error("Cannot parse consumption rate for " + fluid + ". Setting MAX rate");
                }
                rate = rate < 0.05f ? 0.05f : (rate > 20.0f ? 20.0f : rate);
                liquidFuels.put(fluid, Float.valueOf(rate));
                LogHelper.info("Registered " + fluid + " as Copter fuel with consumption rate " + rate);
                continue;
            }
            ++unregCount;
        }
        if (wrongCount > 0 || unregCount > 0) {
            LogHelper.info("Skipped " + (wrongCount > 0 ? wrongCount + " incorrect entr" + (wrongCount > 1 ? "ies" : "y") : "") + (wrongCount > 0 && unregCount > 0 ? " and " : "") + (unregCount > 0 ? unregCount + " unregistered fluid" + (unregCount > 1 ? "s" : "") : ""));
        }
    }

    public static boolean isDimensionAllowed(@Nonnull EntityPlayer player) {
        return GeneralReference.isDimensionAllowed(player.field_70170_p.field_73011_w.field_76574_g);
    }

    public static boolean isDimensionAllowed(int dimID) {
        return !dimensionBlacklist.contains(dimID);
    }

    public static boolean isValidFuel(String fluidName) {
        return liquidFuels.containsKey(fluidName);
    }

    @Nullable
    public static Float getFuelRate(String fluidName) {
        return liquidFuels.get(fluidName);
    }
}

