/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.common;

import com.darkona.adventurebackpack.block.BlockSleepingBag;
import com.darkona.adventurebackpack.block.TileAdventureBackpack;
import com.darkona.adventurebackpack.config.ConfigHandler;
import com.darkona.adventurebackpack.fluids.FluidEffectRegistry;
import com.darkona.adventurebackpack.init.ModNetwork;
import com.darkona.adventurebackpack.inventory.InventoryBackpack;
import com.darkona.adventurebackpack.inventory.InventoryCoalJetpack;
import com.darkona.adventurebackpack.inventory.SlotTool;
import com.darkona.adventurebackpack.item.ItemCopterPack;
import com.darkona.adventurebackpack.item.ItemHose;
import com.darkona.adventurebackpack.network.messages.EntitySoundPacket;
import com.darkona.adventurebackpack.playerProperties.BackpackProperty;
import com.darkona.adventurebackpack.reference.BackpackTypes;
import com.darkona.adventurebackpack.reference.GeneralReference;
import com.darkona.adventurebackpack.util.BackpackUtils;
import com.darkona.adventurebackpack.util.CoordsUtils;
import com.darkona.adventurebackpack.util.Wearing;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class ServerActions {
    public static final boolean HOSE_SWITCH = false;
    public static final boolean HOSE_TOGGLE = true;

    public static void cycleTool(EntityPlayer player, boolean isWheelUp) {
        if (!GeneralReference.isDimensionAllowed(player)) {
            return;
        }
        int playerSlot = player.field_71071_by.field_70461_c;
        ItemStack current = player.func_71045_bC();
        if (SlotTool.isValidTool(current)) {
            int backpackSlot = isWheelUp ? 48 : 49;
            InventoryBackpack backpack = Wearing.getWearingBackpackInv(player);
            player.field_71071_by.func_70299_a(playerSlot, backpack.func_70301_a(backpackSlot));
            backpack.func_70299_a(backpackSlot, current);
        }
    }

    public static boolean setFluidEffect(World world, EntityPlayer player, FluidTank tank) {
        FluidStack drained = tank.drain(1000, false);
        boolean done = false;
        if (drained != null && drained.amount >= 1000 && FluidEffectRegistry.hasFluidEffect(drained.getFluid())) {
            done = FluidEffectRegistry.executeFluidEffectsForFluid(drained.getFluid(), (Entity)player, world);
        }
        return done;
    }

    public static void switchHose(EntityPlayer player, boolean isWheelUp, boolean action) {
        if (Wearing.isHoldingHose(player)) {
            NBTTagCompound tag;
            ItemStack hose = player.field_71071_by.func_70448_g();
            NBTTagCompound nBTTagCompound = tag = hose.func_77942_o() ? hose.field_77990_d : new NBTTagCompound();
            if (!action) {
                int mode = ItemHose.getHoseMode(hose);
                mode = !ConfigHandler.enableHoseDrink ? (mode + 1) % 2 : (isWheelUp ? (mode + 1) % 3 : (mode - 1 < 0 ? 2 : mode - 1));
                tag.func_74768_a("mode", mode);
            }
            if (action) {
                int tank = ItemHose.getHoseTank(hose);
                tank = (tank + 1) % 2;
                tag.func_74768_a("tank", tank);
            }
            hose.func_77982_d(tag);
        }
    }

    public static void electrify(EntityPlayer player) {
        ItemStack backpack = Wearing.getWearingBackpack(player);
        if (BackpackTypes.getType(backpack) == BackpackTypes.PIG) {
            BackpackUtils.setBackpackType(backpack, BackpackTypes.PIGMAN);
        } else if (BackpackTypes.getType(backpack) == BackpackTypes.DIAMOND) {
            BackpackUtils.setBackpackType(backpack, BackpackTypes.ELECTRIC);
        }
    }

    public static void leakArrow(EntityPlayer player, ItemStack bow, int charge) {
        boolean flag;
        World world = player.field_70170_p;
        Random itemRand = new Random();
        InventoryBackpack backpack = new InventoryBackpack(Wearing.getWearingBackpack(player));
        boolean bl = flag = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)bow) > 0;
        if (flag || backpack.hasItem(Items.field_151032_g)) {
            int punch;
            int power;
            float f = (float)charge / 20.0f;
            if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
                return;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            EntityArrow entityarrow = new EntityArrow(world, (EntityLivingBase)player, f * 2.0f);
            if (f == 1.0f) {
                entityarrow.func_70243_d(true);
            }
            if ((power = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)bow)) > 0) {
                entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)power * 0.5 + 0.5);
            }
            if ((punch = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)bow)) > 0) {
                entityarrow.func_70240_a(punch);
            }
            if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)bow) > 0) {
                entityarrow.func_70015_d(100);
            }
            bow.func_77972_a(1, (EntityLivingBase)player);
            world.func_72956_a((Entity)player, "random.bow", 1.0f, 1.0f / (itemRand.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            if (flag) {
                entityarrow.field_70251_a = 2;
            } else {
                backpack.consumeInventoryItem(Items.field_151032_g);
                backpack.dirtyInventory();
            }
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)entityarrow);
            }
        }
    }

    public static void toggleSleepingBag(EntityPlayer player, boolean isTile, int cX, int cY, int cZ) {
        World world = player.field_70170_p;
        if (!world.field_73011_w.func_76567_e() || world.func_72807_a(cX, cZ) == BiomeGenBase.field_76778_j) {
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("adventurebackpack:messages.cant.sleep.here", new Object[0]));
            player.func_71053_j();
            return;
        }
        if (isTile && world.func_147438_o(cX, cY, cZ) instanceof TileAdventureBackpack) {
            TileAdventureBackpack te = (TileAdventureBackpack)world.func_147438_o(cX, cY, cZ);
            if (!te.isSleepingBagDeployed()) {
                int[] can = CoordsUtils.canDeploySleepingBag(world, player, cX, cY, cZ, true);
                if (can[0] > -1) {
                    if (te.deploySleepingBag(player, world, can[0], can[1], can[2], can[3])) {
                        player.func_71053_j();
                    }
                } else if (!world.field_72995_K) {
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation("adventurebackpack:messages.backpack.cant.bag", new Object[0]));
                }
            } else {
                te.removeSleepingBag(world);
            }
            player.func_71053_j();
        } else if (!isTile && Wearing.isWearingBackpack(player)) {
            int[] can = CoordsUtils.canDeploySleepingBag(world, player, cX, cY, cZ, false);
            if (can[0] > -1) {
                Block portableBag;
                InventoryBackpack inv = Wearing.getWearingBackpackInv(player);
                if (inv.deploySleepingBag(player, world, can[0], can[1], can[2], can[3]) && (portableBag = world.func_147439_a(can[1], can[2], can[3])) instanceof BlockSleepingBag) {
                    inv.getExtendedProperties().func_74757_a("sleepingInBag", true);
                    ((BlockSleepingBag)portableBag).onPortableBlockActivated(world, player, can[1], can[2], can[3]);
                }
            } else if (!world.field_72995_K) {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("adventurebackpack:messages.backpack.cant.bag", new Object[0]));
            }
            player.func_71053_j();
        }
    }

    public static void pistonBootsJump(EntityPlayer player) {
        if (ConfigHandler.allowSoundPiston) {
            player.func_85030_a("tile.piston.out", 0.5f, player.func_70681_au().nextFloat() * 0.25f + 0.6f);
        }
        player.field_70181_x += (double)((float)ConfigHandler.pistonBootsJumpHeight / 10.0f);
        player.field_70747_aH = (float)((double)player.field_70747_aH + 0.3);
    }

    public static void copterSoundAtLogin(EntityPlayer player) {
        byte status = BackpackUtils.getWearableCompound(BackpackProperty.get(player).getWearable()).func_74771_c("status");
        if (!player.field_70170_p.field_72995_K && status != ItemCopterPack.OFF_MODE) {
            ModNetwork.sendToNearby(new EntitySoundPacket.Message(1, (Entity)player), player);
        }
    }

    public static void jetpackSoundAtLogin(EntityPlayer player) {
        boolean isBoiling = BackpackUtils.getWearableCompound(BackpackProperty.get(player).getWearable()).func_74767_n("boiling");
        if (!player.field_70170_p.field_72995_K && isBoiling) {
            ModNetwork.net.sendTo((IMessage)new EntitySoundPacket.Message(3, (Entity)player), (EntityPlayerMP)player);
        }
    }

    public static void toggleCopterPack(EntityPlayer player, ItemStack copter, byte type) {
        String message = "";
        boolean actionPerformed = false;
        byte mode = BackpackUtils.getWearableCompound(copter).func_74771_c("status");
        byte newMode = ItemCopterPack.OFF_MODE;
        if (type == 0) {
            if (mode == ItemCopterPack.OFF_MODE) {
                newMode = ItemCopterPack.NORMAL_MODE;
                message = "adventurebackpack:messages.copterpack.normal";
                actionPerformed = true;
                if (!player.field_70170_p.field_72995_K) {
                    ModNetwork.sendToNearby(new EntitySoundPacket.Message(1, (Entity)player), player);
                }
            } else {
                newMode = ItemCopterPack.OFF_MODE;
                message = "adventurebackpack:messages.copterpack.off";
                actionPerformed = true;
            }
        }
        if (type == 1 && mode != ItemCopterPack.OFF_MODE) {
            if (mode == ItemCopterPack.NORMAL_MODE) {
                newMode = ItemCopterPack.HOVER_MODE;
                message = "adventurebackpack:messages.copterpack.hover";
                actionPerformed = true;
            }
            if (mode == ItemCopterPack.HOVER_MODE) {
                newMode = ItemCopterPack.NORMAL_MODE;
                message = "adventurebackpack:messages.copterpack.normal";
                actionPerformed = true;
            }
        }
        if (actionPerformed) {
            BackpackUtils.getWearableCompound(copter).func_74774_a("status", newMode);
            if (player.field_70170_p.field_72995_K) {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation(message, new Object[0]));
            }
        }
    }

    public static void toggleToolCycling(EntityPlayer player, ItemStack backpack) {
        InventoryBackpack inv = new InventoryBackpack(backpack);
        if (ConfigHandler.enableToolsCycling) {
            if (inv.getDisableCycling()) {
                inv.setDisableCycling(false);
                inv.func_70296_d();
                if (player.field_70170_p.field_72995_K) {
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation("adventurebackpack:messages.cycling.on", new Object[0]));
                }
            } else {
                inv.setDisableCycling(true);
                inv.func_70296_d();
                if (player.field_70170_p.field_72995_K) {
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation("adventurebackpack:messages.cycling.off", new Object[0]));
                }
            }
        }
    }

    public static void toggleNightVision(EntityPlayer player, ItemStack backpack) {
        InventoryBackpack inv = new InventoryBackpack(backpack);
        if (inv.getDisableNVision()) {
            inv.setDisableNVision(false);
            inv.func_70296_d();
            if (player.field_70170_p.field_72995_K) {
                player.func_85030_a("mob.bat.idle", 0.2f, 1.0f);
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("adventurebackpack:messages.nightvision.on", new Object[0]));
            }
        } else {
            inv.setDisableNVision(true);
            inv.func_70296_d();
            if (player.field_70170_p.field_72995_K) {
                player.func_85030_a("mob.bat.death", 0.2f, 2.0f);
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("adventurebackpack:messages.nightvision.off", new Object[0]));
            }
        }
    }

    public static void toggleCoalJetpack(EntityPlayer player, ItemStack jetpack) {
        InventoryCoalJetpack inv = new InventoryCoalJetpack(jetpack);
        if (inv.getStatus()) {
            inv.setStatus(false);
            inv.func_70296_d();
            if (player.field_70170_p.field_72995_K) {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("adventurebackpack:messages.jetpack.off", new Object[0]));
            }
        } else {
            inv.setStatus(true);
            inv.func_70296_d();
            if (player.field_70170_p.field_72995_K) {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("adventurebackpack:messages.jetpack.on", new Object[0]));
            }
        }
    }
}

