/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.block;

import com.darkona.adventurebackpack.AdventureBackpack;
import com.darkona.adventurebackpack.block.BackpackMaterial;
import com.darkona.adventurebackpack.block.TileAdventureBackpack;
import com.darkona.adventurebackpack.client.Icons;
import com.darkona.adventurebackpack.reference.BackpackTypes;
import com.darkona.adventurebackpack.reference.GeneralReference;
import com.darkona.adventurebackpack.util.BackpackUtils;
import com.darkona.adventurebackpack.util.CoordsUtils;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockAdventureBackpack
extends BlockContainer {
    public BlockAdventureBackpack() {
        super((Material)new BackpackMaterial());
        this.func_149711_c(1.0f);
        this.func_149672_a(field_149775_l);
        this.func_149752_b(2000.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        ChunkCoordinates enchTable;
        if (this.getAssociatedTileBackpackType((IBlockAccess)world, x, y, z) == BackpackTypes.BOOKSHELF && (enchTable = CoordsUtils.findBlock3D(world, x, y, z, Blocks.field_150381_bn, 2, 2)) != null) {
            if (!world.func_147437_c((enchTable.field_71574_a - x) / 2 + x, enchTable.field_71572_b, (enchTable.field_71573_c - z) / 2 + z)) {
                return;
            }
            for (int o = 0; o < 4; ++o) {
                world.func_72869_a("enchantmenttable", (double)enchTable.field_71574_a + 0.5, (double)enchTable.field_71572_b + 2.0, (double)enchTable.field_71573_c + 0.5, (double)((float)(x - enchTable.field_71574_a) + random.nextFloat()) - 0.5, (double)((float)(y - enchTable.field_71572_b) - random.nextFloat() - 1.0f), (double)((float)(z - enchTable.field_71573_c) + random.nextFloat()) - 0.5);
            }
        }
    }

    public int func_149656_h() {
        return 0;
    }

    public String getHarvestTool(int metadata) {
        return null;
    }

    public int getHarvestLevel(int metadata) {
        return 0;
    }

    public boolean isToolEffective(String type, int metadata) {
        return true;
    }

    private BackpackTypes getAssociatedTileBackpackType(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        return tile instanceof TileAdventureBackpack ? ((TileAdventureBackpack)tile).getType() : BackpackTypes.UNKNOWN;
    }

    public boolean canRenderInPass(int pass) {
        return true;
    }

    public boolean canEntityDestroy(IBlockAccess world, int x, int y, int z, Entity entity) {
        return false;
    }

    public float getEnchantPowerBonus(World world, int x, int y, int z) {
        return this.getAssociatedTileBackpackType((IBlockAccess)world, x, y, z) == BackpackTypes.BOOKSHELF ? 10.0f : 0.0f;
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean isWood(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean isLeaves(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 0;
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return true;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (this.getAssociatedTileBackpackType((IBlockAccess)world, x, y, z) == BackpackTypes.CACTUS) {
            entity.func_70097_a(DamageSource.field_76367_g, 1.0f);
        }
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return false;
    }

    public String func_149739_a() {
        return "blockAdventureBackpack";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        Icons.milkStill = iconRegister.func_94245_a("adventurebackpack:fluid.milk");
        Icons.melonJuiceStill = iconRegister.func_94245_a("adventurebackpack:fluid.melonJuiceStill");
        Icons.melonJuiceFlowing = iconRegister.func_94245_a("adventurebackpack:fluid.melonJuiceFlowing");
        Icons.mushRoomStewStill = iconRegister.func_94245_a("adventurebackpack:fluid.mushroomStewStill");
        Icons.mushRoomStewFlowing = iconRegister.func_94245_a("adventurebackpack:fluid.mushroomStewFlowing");
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        if (this.getAssociatedTileBackpackType(world, x, y, z) == BackpackTypes.GLOWSTONE) {
            return 15;
        }
        if (world.func_147438_o(x, y, z) != null && world.func_147438_o(x, y, z) instanceof TileAdventureBackpack) {
            return ((TileAdventureBackpack)world.func_147438_o(x, y, z)).getLuminosity();
        }
        return 0;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int meta) {
        return this.getAssociatedTileBackpackType(world, x, y, z) == BackpackTypes.REDSTONE ? 15 : 0;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return this.getAssociatedTileBackpackType(world, x, y, z) == BackpackTypes.REDSTONE;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && GeneralReference.isDimensionAllowed(player)) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)AdventureBackpack.instance, (int)0, (World)world, (int)x, (int)y, (int)z);
            return true;
        }
        return false;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        return BackpackUtils.createBackpackStack(this.getAssociatedTileBackpackType((IBlockAccess)world, x, y, z));
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public void func_149719_a(IBlockAccess blockAccess, int x, int y, int z) {
        int meta = blockAccess.func_72805_g(x, y, z);
        meta = (meta & 8) >= 8 ? meta - 8 : meta;
        meta = (meta & 4) >= 4 ? meta - 4 : meta;
        switch (meta) {
            case 0: 
            case 2: {
                this.func_149676_a(0.0f, 0.0f, 0.4f, 1.0f, 0.6f, 0.6f);
                break;
            }
            case 1: 
            case 3: {
                this.func_149676_a(0.4f, 0.0f, 0.0f, 0.6f, 0.6f, 1.0f);
            }
        }
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        int dir = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (stack != null && stack.field_77990_d != null && stack.field_77990_d.func_74764_b("color")) {
            if (stack.field_77990_d.func_74779_i("color").contains("BlockRedstone")) {
                dir |= 8;
            }
            if (stack.field_77990_d.func_74779_i("color").contains("Lightgem")) {
                dir |= 4;
            }
        }
        world.func_72921_c(x, y, z, dir, 3);
        this.func_149915_a(world, world.func_72805_g(x, y, z));
    }

    public boolean func_149707_d(World par1World, int par2, int par3, int par4, int side) {
        return ForgeDirection.getOrientation((int)side) == ForgeDirection.UP;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149633_g(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int par2) {
        return Blocks.field_150325_L.func_149691_a(par1, par2);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149731_a(world, x, y, z, start, end);
    }

    public boolean func_149705_a(World p_149705_1_, int p_149705_2_, int p_149705_3_, int p_149705_4_, int p_149705_5_, ItemStack p_149705_6_) {
        return false;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean harvest) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileAdventureBackpack && !world.field_72995_K && player != null) {
            if (player.func_70093_af() ? ((TileAdventureBackpack)tile).equip(world, player, x, y, z) : ((TileAdventureBackpack)tile).drop(world, player, x, y, z)) {
                return world.func_147480_a(x, y, z, false);
            }
        } else {
            return world.func_147480_a(x, y, z, false);
        }
        return false;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof IInventory) {
            IInventory inventory = (IInventory)te;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack stack = inventory.func_70304_b(i);
                if (stack == null) continue;
                float spawnX = (float)x + world.field_73012_v.nextFloat();
                float spawnY = (float)y + world.field_73012_v.nextFloat();
                float spawnZ = (float)z + world.field_73012_v.nextFloat();
                float mult = 0.05f;
                EntityItem droppedItem = new EntityItem(world, (double)spawnX, (double)spawnY, (double)spawnZ, stack);
                droppedItem.field_70159_w = -0.5f + world.field_73012_v.nextFloat() * mult;
                droppedItem.field_70181_x = 4.0f + world.field_73012_v.nextFloat() * mult;
                droppedItem.field_70179_y = -0.5 + (double)(world.field_73012_v.nextFloat() * mult);
                world.func_72838_d((Entity)droppedItem);
            }
        }
        super.func_149749_a(world, x, y, z, world.func_147439_a(x, y, z), meta);
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileAdventureBackpack();
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return this.createTileEntity(world, metadata);
    }

    public boolean func_149659_a(Explosion p_149659_1_) {
        return false;
    }

    public void func_149723_a(World world, int x, int y, int z, Explosion explosion) {
        world.func_147480_a(x, y, z, false);
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
    }
}

