/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.network;

import com.darkona.adventurebackpack.common.ServerActions;
import com.darkona.adventurebackpack.util.Wearing;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class WearableModePacket
implements IMessageHandler<Message, Message> {
    public static final byte COPTER_ON_OFF = 0;
    public static final byte COPTER_TOGGLE = 1;
    public static final byte JETPACK_ON_OFF = 2;
    public static final byte CYCLING_ON_OFF = 3;
    public static final byte NIGHTVISION_ON_OFF = 4;

    public Message onMessage(Message message, MessageContext ctx) {
        EntityPlayerMP player;
        if (ctx.side.isServer() && (player = ctx.getServerHandler().field_147369_b) != null) {
            if (message.type == 0 || message.type == 1) {
                ServerActions.toggleCopterPack((EntityPlayer)player, Wearing.getWearingCopter((EntityPlayer)player), message.type);
            }
            if (message.type == 2) {
                ServerActions.toggleCoalJetpack((EntityPlayer)player, Wearing.getWearingJetpack((EntityPlayer)player));
            }
            if (message.type == 3) {
                ServerActions.toggleToolCycling((EntityPlayer)player, Wearing.getWearingBackpack((EntityPlayer)player));
            }
            if (message.type == 4) {
                ServerActions.toggleNightVision((EntityPlayer)player, Wearing.getWearingBackpack((EntityPlayer)player));
            }
        }
        if (ctx.side.isClient()) {
            // empty if block
        }
        return null;
    }

    public static class Message
    implements IMessage {
        private byte type;
        private String playerID;

        public Message() {
        }

        public Message(byte type, String playerID) {
            this.type = type;
            this.playerID = playerID;
        }

        public void fromBytes(ByteBuf buf) {
            this.type = buf.readByte();
            this.playerID = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }

        public void toBytes(ByteBuf buf) {
            buf.writeByte((int)this.type);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerID);
        }
    }
}

