/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.handlers;

import com.darkona.adventurebackpack.block.BlockSleepingBag;
import com.darkona.adventurebackpack.common.ServerActions;
import com.darkona.adventurebackpack.config.ConfigHandler;
import com.darkona.adventurebackpack.entity.EntityFriendlySpider;
import com.darkona.adventurebackpack.entity.ai.EntityAIHorseFollowOwner;
import com.darkona.adventurebackpack.init.ModBlocks;
import com.darkona.adventurebackpack.init.ModItems;
import com.darkona.adventurebackpack.item.IBackWearableItem;
import com.darkona.adventurebackpack.item.ItemAdventureBackpack;
import com.darkona.adventurebackpack.playerProperties.BackpackProperty;
import com.darkona.adventurebackpack.proxy.ServerProxy;
import com.darkona.adventurebackpack.reference.BackpackTypes;
import com.darkona.adventurebackpack.util.EnchUtils;
import com.darkona.adventurebackpack.util.LogHelper;
import com.darkona.adventurebackpack.util.Wearing;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemNameTag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;

public class PlayerEventHandler {
    private boolean pistonBootsStepHeight = false;

    @SubscribeEvent
    public void registerBackpackProperty(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer && BackpackProperty.get((EntityPlayer)event.entity) == null) {
            BackpackProperty.register((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void joinPlayer(EntityJoinWorldEvent event) {
        if (!event.world.field_72995_K && event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            LogHelper.info("Joined EntityPlayer of name: " + event.entity.func_70005_c_());
            NBTTagCompound playerData = ServerProxy.extractPlayerProps(player.func_110124_au());
            if (playerData != null) {
                BackpackProperty.get(player).loadNBTData(playerData);
                BackpackProperty.sync(player);
                LogHelper.info("Stored properties retrieved");
            }
        }
    }

    @SubscribeEvent
    public void playerLogsIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayer player = event.player;
            BackpackProperty.sync(player);
            if (Wearing.isWearingCopter(player)) {
                ServerActions.copterSoundAtLogin(player);
            }
            if (Wearing.isWearingJetpack(player)) {
                ServerActions.jetpackSoundAtLogin(player);
            }
        }
    }

    @SubscribeEvent
    public void playerTravelsAcrossDimensions(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            BackpackProperty.sync(event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        EntityPlayer player;
        if (event.entity != null && event.entityLiving instanceof EntityPlayer && Wearing.isWearingBoots(player = (EntityPlayer)event.entity) && player.field_70122_E) {
            ServerActions.pistonBootsJump(player);
        }
    }

    @SubscribeEvent
    public void pistonBootsUnequipped(LivingEvent.LivingUpdateEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            if (Wearing.isWearingBoots(player)) {
                if (!this.pistonBootsStepHeight) {
                    this.pistonBootsStepHeight = true;
                }
            } else if (this.pistonBootsStepHeight) {
                player.field_70138_W = 0.5001f;
                this.pistonBootsStepHeight = false;
            }
        }
    }

    @SubscribeEvent
    public void onFall(LivingFallEvent event) {
        if (event.entity != null) {
            EntityCreature creature;
            if (event.entityLiving instanceof EntityCreature && ConfigHandler.fixLead && (creature = (EntityCreature)event.entityLiving).func_110167_bD() && creature.func_110166_bE() != null && creature.func_110166_bE() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)creature.func_110166_bE();
                if (creature.field_70181_x > -2.0 && player.field_70181_x > -2.0) {
                    event.setCanceled(true);
                }
            }
            if (event.entityLiving instanceof EntityFriendlySpider && ((EntityFriendlySpider)event.entityLiving).field_70153_n != null && ((EntityFriendlySpider)event.entityLiving).field_70153_n instanceof EntityPlayer && event.distance < 5.0f) {
                event.setCanceled(true);
            }
            if (event.entityLiving instanceof EntityPlayer) {
                if (Wearing.isWearingBoots((EntityPlayer)event.entityLiving) && event.distance < 8.0f) {
                    event.setCanceled(true);
                }
                if (Wearing.isWearingTheRightBackpack((EntityPlayer)event.entityLiving, BackpackTypes.IRON_GOLEM) && ConfigHandler.backpackAbilities) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void playerDies(LivingDeathEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            if (!player.field_70170_p.field_72995_K) {
                ChunkCoordinates lastCampFire;
                BackpackProperty props = BackpackProperty.get(player);
                if (ConfigHandler.enableCampfireSpawn && props.isForcedCampFire() && (lastCampFire = props.getCampFire()) != null) {
                    player.setSpawnChunk(lastCampFire, false, player.field_71093_bK);
                }
                if (Wearing.isWearingWearable(player)) {
                    if (Wearing.isWearingTheRightBackpack(player, BackpackTypes.CREEPER)) {
                        player.field_70170_p.func_72876_a((Entity)player, player.field_70165_t, player.field_70163_u, player.field_70161_v, 4.0f, false);
                    }
                    if (player.func_130014_f_().func_82736_K().func_82766_b("keepInventory")) {
                        ((IBackWearableItem)props.getWearable().func_77973_b()).onPlayerDeath(player.field_70170_p, player, props.getWearable());
                        ServerProxy.storePlayerProps(player);
                    }
                }
            }
        }
        event.setResult(Event.Result.ALLOW);
    }

    @SubscribeEvent
    public void playerDeathDrop(PlayerDropsEvent event) {
        EntityPlayer player = event.entityPlayer;
        if (Wearing.isWearingWearable(player)) {
            ItemStack pack = Wearing.getWearingWearable(player);
            BackpackProperty props = BackpackProperty.get(player);
            if (EnchUtils.isSoulBounded(pack) || ConfigHandler.backpackDeathPlace && pack.func_77973_b() instanceof ItemAdventureBackpack) {
                ((IBackWearableItem)props.getWearable().func_77973_b()).onPlayerDeath(player.field_70170_p, player, props.getWearable());
                ServerProxy.storePlayerProps(player);
            } else {
                event.drops.add(new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, pack));
                props.setWearable(null);
            }
        }
    }

    @SubscribeEvent
    public void playerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            BackpackProperty.sync(event.player);
        }
    }

    @SubscribeEvent
    public void playerCraftsBackpack(PlayerEvent.ItemCraftedEvent event) {
        if (event.crafting.func_77973_b() == ModItems.adventureBackpack) {
            LogHelper.info("Player crafted a backpack, and that backpack's appearance is: " + BackpackTypes.getSkinName(event.crafting));
            if (!ConfigHandler.consumeDragonEgg && BackpackTypes.getType(event.crafting) == BackpackTypes.DRAGON) {
                event.player.func_71019_a(new ItemStack(Blocks.field_150380_bt, 1), false);
                event.player.func_85030_a("mob.enderdragon.growl", 1.0f, 5.0f);
            }
        }
    }

    @SubscribeEvent
    public void interactWithCreatures(EntityInteractEvent event) {
        EntityPlayer player = event.entityPlayer;
        if (!player.field_70170_p.field_72995_K) {
            if (event.target instanceof EntitySpider && Wearing.isWearingTheRightBackpack(player, BackpackTypes.SPIDER)) {
                EntityFriendlySpider pet = new EntityFriendlySpider(event.target.field_70170_p);
                pet.func_70012_b(event.target.field_70165_t, event.target.field_70163_u, event.target.field_70161_v, event.target.field_70177_z, event.target.field_70125_A);
                event.target.func_70106_y();
                event.entityPlayer.field_70170_p.func_72838_d((Entity)pet);
                event.entityPlayer.func_70078_a((Entity)pet);
            }
            if (event.target instanceof EntityHorse) {
                EntityHorse horse = (EntityHorse)event.target;
                ItemStack stack = player.func_71045_bC();
                if (stack != null && stack.func_77973_b() != null && stack.func_77973_b() instanceof ItemNameTag && stack.func_82837_s() && (horse.func_94057_bL() == null || horse.func_94057_bL().equals("") && horse.func_110248_bS())) {
                    horse.func_110263_g(player);
                    horse.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIHorseFollowOwner(horse, 1.5, 2.0f, 20.0f));
                    if (horse.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111265_b) != null) {
                        horse.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111265_b).func_111128_a(100.0);
                        LogHelper.info("The horse follow range is now: " + horse.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111125_b());
                    }
                }
            }
        }
        event.setResult(Event.Result.ALLOW);
    }

    @SubscribeEvent
    public void playerWokeUp(PlayerWakeUpEvent event) {
        if (event.entity.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer player = event.entityPlayer;
        ChunkCoordinates bedLocation = player.getBedLocation(player.field_71093_bK);
        if (bedLocation != null && player.field_70170_p.func_147439_a(bedLocation.field_71574_a, bedLocation.field_71572_b, bedLocation.field_71573_c) == ModBlocks.blockSleepingBag) {
            if (BlockSleepingBag.isSleepingInPortableBag(player)) {
                BlockSleepingBag.packPortableSleepingBag(player);
                BackpackProperty.get(player).setWakingUpInPortableBag(true);
                LogHelper.info("Player just woke up in a portable sleeping bag.");
            } else {
                BackpackProperty.get(player).setForceCampFire(true);
                LogHelper.info("Player just woke up in a sleeping bag, forcing respawn in the last lighted campfire, if there's any");
            }
        } else {
            BackpackProperty.get(player).setForceCampFire(false);
        }
    }

    @SubscribeEvent
    public void tickPlayer(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (player != null && !player.field_70128_L && Wearing.isWearingWearable(player)) {
            if (event.phase == TickEvent.Phase.START) {
                BackpackProperty.get(player).executeWearableUpdateProtocol();
            }
            if (event.phase == TickEvent.Phase.END && !player.field_70170_p.field_72995_K && BackpackProperty.get(player).isWakingUpInPortableBag() && Wearing.isWearingBackpack(player)) {
                BlockSleepingBag.restoreOriginalSpawn(player, Wearing.getWearingBackpackInv(player).getExtendedProperties());
                BackpackProperty.get(player).setWakingUpInPortableBag(false);
            }
        }
    }
}

