/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.client.gui;

import codechicken.lib.render.TextureUtils;
import com.darkona.adventurebackpack.client.gui.GuiTank;
import com.darkona.adventurebackpack.config.ConfigHandler;
import com.darkona.adventurebackpack.inventory.IInventoryTanks;
import com.darkona.adventurebackpack.item.ItemHose;
import com.darkona.adventurebackpack.reference.LoadedMods;
import com.darkona.adventurebackpack.reference.ToolHandler;
import com.darkona.adventurebackpack.util.GregtechUtils;
import com.darkona.adventurebackpack.util.LogHelper;
import com.darkona.adventurebackpack.util.ThaumcraftUtils;
import com.darkona.adventurebackpack.util.TinkersUtils;
import com.darkona.adventurebackpack.util.Wearing;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.boss.BossStatus;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import org.lwjgl.opengl.GL11;

public class GuiOverlay
extends Gui {
    private static final ResourceLocation GUI_ICONS = new ResourceLocation("textures/gui/icons.png");
    private static final ResourceLocation GUI_INVENTORY = new ResourceLocation("textures/gui/container/inventory.png");
    private static final ResourceLocation TANKS_OVERLAY = new ResourceLocation("adventurebackpack", "textures/gui/overlay.png");
    private static final int BUFF_ICON_SIZE = 18;
    private static final int BUFF_ICON_SPACING = 2;
    private static final int BUFF_ICON_BASE_U_OFFSET = 0;
    private static final int BUFF_ICON_BASE_V_OFFSET = 198;
    private static final int BUFF_ICONS_PER_ROW = 8;
    private static final RenderItem itemRender = new RenderItem();
    private final Minecraft mc;
    private final FontRenderer fontRenderer;
    private int screenWidth;

    public GuiOverlay(Minecraft mc) {
        this.mc = mc;
        this.fontRenderer = mc.field_71466_p;
        GuiOverlay.itemRender.field_77024_a = false;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderExperienceBar(RenderGameOverlayEvent.Post event) {
        IInventoryTanks inv;
        if (event.type != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        EntityClientPlayerMP player = this.mc.field_71439_g;
        this.screenWidth = event.resolution.func_78326_a();
        int screenHeight = event.resolution.func_78328_b();
        GL11.glPushAttrib((int)20544);
        if (ConfigHandler.bossBarIndent != 0) {
            if (GuiIngameForge.renderBossHealth) {
                GuiIngameForge.renderBossHealth = false;
                LogHelper.info("Forge boss bar render: disabled");
            }
            this.drawBossBar();
        }
        if (ConfigHandler.statusOverlay) {
            Collection activePotionEffects;
            int yPos;
            int xStep = ConfigHandler.statusOverlayLeft ? 20 : -20;
            int xPos = ConfigHandler.statusOverlayLeft ? ConfigHandler.statusOverlayIndentH : this.screenWidth - 18 - ConfigHandler.statusOverlayIndentH;
            int n = yPos = ConfigHandler.statusOverlayTop ? ConfigHandler.statusOverlayIndentV : screenHeight - 18 - ConfigHandler.statusOverlayIndentV;
            if (LoadedMods.THAUMCRAFT && ConfigHandler.statusOverlayThaumcraft && ConfigHandler.statusOverlayLeft && ConfigHandler.statusOverlayTop == !ThaumcraftUtils.DIAL_BOTTOM && ThaumcraftUtils.isTool(player.field_71071_by.func_70448_g())) {
                xPos += 50;
            }
            if (!(activePotionEffects = this.mc.field_71439_g.func_70651_bq()).isEmpty()) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)2896);
                this.mc.field_71446_o.func_110577_a(GUI_INVENTORY);
                for (PotionEffect potionEffect : activePotionEffects) {
                    Potion potion = Potion.field_76425_a[potionEffect.func_76456_a()];
                    if (potion != null && potion.func_76400_d()) {
                        int iconIndex = potion.func_76392_e();
                        this.func_73729_b(xPos, yPos, 0 + iconIndex % 8 * 18, 198 + iconIndex / 8 * 18, 18, 18);
                    }
                    xPos += xStep;
                }
            }
        }
        if (ConfigHandler.tanksOverlay && (inv = Wearing.getWearingWearableInv((EntityPlayer)player)) != null) {
            inv.func_70295_k_();
            int textureHeight = 23;
            int textureWidth = 10;
            int xPos = ConfigHandler.tanksOverlayRight ? this.screenWidth - textureWidth * 2 - ConfigHandler.tanksOverlayIndentH : ConfigHandler.tanksOverlayIndentH;
            int yPos = ConfigHandler.tanksOverlayBottom ? screenHeight - textureHeight - ConfigHandler.tanksOverlayIndentV : ConfigHandler.tanksOverlayIndentV;
            int tankX = xPos;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            if (inv.getTanksArray().length == 1 && ConfigHandler.tanksOverlayRight) {
                tankX += textureWidth + 1;
            }
            for (Potion tank : inv.getTanksArray()) {
                this.mc.field_71446_o.func_110577_a(TANKS_OVERLAY);
                this.func_73729_b(tankX, yPos, 10, 0, textureWidth, textureHeight);
                this.drawTank((FluidTank)tank, tankX + 1, yPos + 1, textureHeight - 2, textureWidth - 2);
                ++tankX;
                tankX += textureWidth;
            }
            if (Wearing.isWearingBackpack((EntityPlayer)player)) {
                int[] u = new int[]{10, 10};
                int[] v = new int[]{0, 0};
                int[] xStart = new int[]{xPos, xPos + textureWidth + 1};
                int[] yStart = new int[]{yPos, yPos};
                int tank = -1;
                if (Wearing.isHoldingHose((EntityPlayer)player)) {
                    tank = (short)ItemHose.getHoseTank(player.func_70694_bm());
                }
                if (tank > -1) {
                    u[0] = tank == 0 ? 0 : 10;
                    u[1] = tank == 1 ? 0 : 10;
                }
                this.mc.field_71446_o.func_110577_a(TANKS_OVERLAY);
                this.func_73729_b(xStart[0], yStart[0], u[0], v[0], textureWidth, textureHeight);
                this.func_73729_b(xStart[1], yStart[0], u[1], v[1], textureWidth, textureHeight);
                RenderHelper.func_74519_b();
                RenderHelper.func_74520_c();
                GL11.glPushMatrix();
                GL11.glTranslatef((float)(xStart[0] - textureWidth), (float)yStart[0], (float)0.0f);
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                if (ConfigHandler.enableToolsRender) {
                    ItemStack upperStack = inv.func_70301_a(48);
                    ItemStack lowerStack = inv.func_70301_a(49);
                    this.drawItemStack(upperStack, ToolHandler.getToolHandler(upperStack), 0, 0);
                    this.drawItemStack(lowerStack, ToolHandler.getToolHandler(lowerStack), 0, 16);
                }
                GL11.glPopMatrix();
                RenderHelper.func_74518_a();
            }
        }
        GL11.glPopAttrib();
    }

    private void drawTank(FluidTank tank, int startX, int startY, int height, int width) {
        int liquidPerPixel = tank.getCapacity() / height;
        FluidStack fluid = tank.getFluid();
        if (fluid != null) {
            try {
                IIcon icon = fluid.getFluid().getStillIcon();
                TextureUtils.bindAtlas((int)fluid.getFluid().getSpriteNumber());
                int top = startY + height - fluid.amount / liquidPerPixel;
                for (int j = startY + height - 1; j >= top; --j) {
                    for (int i = startX; i <= startX + width - 1; ++i) {
                        GL11.glPushMatrix();
                        if (j >= top + 5) {
                            GL11.glColor4f((float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f);
                        } else {
                            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        }
                        GuiTank.drawFluidPixelFromIcon(i, j, icon, 1, 1, 0, 0, 0, 0, 1.0f);
                        GL11.glPopMatrix();
                    }
                }
            }
            catch (Exception oops) {
                LogHelper.error("Exception while trying to render the fluid in the GUI");
            }
        }
    }

    private void drawItemStack(ItemStack stack, ToolHandler toolHandler, int x, int y) {
        if (stack == null) {
            return;
        }
        this.field_73735_i = 200.0f;
        GuiOverlay.itemRender.field_77023_b = 200.0f;
        switch (toolHandler) {
            case GREGTECH: {
                GL11.glTranslatef((float)x, (float)y, (float)32.0f);
                GregtechUtils.renderTool(stack, IItemRenderer.ItemRenderType.INVENTORY);
                break;
            }
            case TCONSTRUCT: {
                TextureManager tm = this.mc.func_110434_K();
                tm.func_110577_a(tm.func_130087_a(stack.func_94608_d()));
                GL11.glTranslatef((float)x, (float)y, (float)32.0f);
                TinkersUtils.renderTool(stack, IItemRenderer.ItemRenderType.INVENTORY);
                break;
            }
            case THAUMCRAFT: {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)(x - 2), (float)(y + 3), (float)(-3.0f + this.field_73735_i));
                GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
                GL11.glTranslatef((float)1.0f, (float)0.5f, (float)1.0f);
                GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
                GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                ThaumcraftUtils.renderTool(stack, IItemRenderer.ItemRenderType.INVENTORY);
                GL11.glPopMatrix();
                break;
            }
            default: {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
                FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
                if (font == null) {
                    font = this.fontRenderer;
                }
                itemRender.func_77015_a(font, this.mc.func_110434_K(), stack, x, y);
            }
        }
        this.field_73735_i = 0.0f;
        GuiOverlay.itemRender.field_77023_b = 0.0f;
    }

    private void drawBossBar() {
        if (BossStatus.field_82827_c != null && BossStatus.field_82826_b > 0) {
            --BossStatus.field_82826_b;
            GL11.glEnable((int)3042);
            int barWidth = 182;
            int posX = this.screenWidth / 2 - barWidth / 2;
            int posY = ConfigHandler.bossBarIndent;
            int bossHealthWidth = (int)(BossStatus.field_82828_a * (float)(barWidth + 1));
            this.mc.func_110434_K().func_110577_a(GUI_ICONS);
            this.func_73729_b(posX, posY, 0, 74, barWidth, 5);
            this.func_73729_b(posX, posY, 0, 74, barWidth, 5);
            if (bossHealthWidth > 0) {
                this.func_73729_b(posX, posY, 0, 79, bossHealthWidth, 5);
            }
            String s = BossStatus.field_82827_c;
            this.fontRenderer.func_78261_a(s, this.screenWidth / 2 - this.fontRenderer.func_78256_a(s) / 2, posY - 10, 0xFFFFFF);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)3042);
        }
    }
}

