/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.inventory;

import com.darkona.adventurebackpack.inventory.InventoryActions;
import com.darkona.adventurebackpack.inventory.InventoryAdventure;
import com.darkona.adventurebackpack.item.ItemCopterPack;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidTank;

public class InventoryCopterPack
extends InventoryAdventure {
    private FluidTank fuelTank = new FluidTank(16000);
    private byte status = ItemCopterPack.OFF_MODE;
    private int tickCounter = 0;

    public InventoryCopterPack(ItemStack copterPack) {
        super(copterPack, 2);
        this.detectAndConvertFromOldNBTFormat(this.containerStack.field_77990_d);
        this.func_70295_k_();
    }

    @Override
    public ItemStack[] getInventory() {
        return this.inventory;
    }

    public FluidTank getFuelTank() {
        return this.fuelTank;
    }

    @Override
    public FluidTank[] getTanksArray() {
        return new FluidTank[]{this.fuelTank};
    }

    @Override
    public int[] getSlotsOnClosing() {
        return new int[]{0, 1};
    }

    @Override
    public void loadFromNBT(NBTTagCompound compound) {
        NBTTagCompound copterTag = compound.func_74775_l("wearableData");
        this.setInventoryFromTagList(copterTag.func_150295_c("inventory", 10));
        this.fuelTank.readFromNBT(copterTag.func_74775_l("fuelTank"));
        this.status = copterTag.func_74771_c("status");
        this.tickCounter = copterTag.func_74762_e("tickCounter");
    }

    @Override
    public void saveToNBT(NBTTagCompound compound) {
        NBTTagCompound copterTag = new NBTTagCompound();
        copterTag.func_74782_a("inventory", (NBTBase)this.getInventoryTagList());
        copterTag.func_74782_a("fuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        copterTag.func_74774_a("status", this.status);
        copterTag.func_74768_a("tickCounter", this.tickCounter);
        compound.func_74782_a("wearableData", (NBTBase)copterTag);
    }

    @Override
    public boolean updateTankSlots() {
        boolean changesMade = false;
        while (InventoryActions.transferContainerTank(this, this.getFuelTank(), 0)) {
            changesMade = true;
        }
        return changesMade;
    }

    @Override
    public void dirtyTanks() {
        this.getWearableCompound().func_74782_a("fuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
    }

    public void dirtyStatus() {
        this.getWearableCompound().func_74774_a("status", this.status);
    }

    public boolean canConsumeFuel(int quantity) {
        return this.fuelTank.drain(quantity, false) != null && this.fuelTank.drain((int)quantity, (boolean)false).amount > 0;
    }

    public void consumeFuel(int quantity) {
        this.fuelTank.drain(quantity, true);
        this.dirtyTanks();
    }

    public byte getStatus() {
        return this.status;
    }

    public void setStatus(byte status) {
        this.status = status;
    }

    public int getTickCounter() {
        return this.tickCounter;
    }

    public void setTickCounter(int ticks) {
        this.tickCounter = ticks;
    }

    private void detectAndConvertFromOldNBTFormat(NBTTagCompound compound) {
        if (compound == null || compound.func_74764_b("wearableData")) {
            return;
        }
        if (compound.func_74764_b("status")) {
            compound.func_82580_o("status");
        }
        if (compound.func_74764_b("tickCounter")) {
            compound.func_82580_o("tickCounter");
        }
        this.fuelTank.readFromNBT(compound.func_74775_l("fuelTank"));
        NBTTagCompound newCopterTag = new NBTTagCompound();
        newCopterTag.func_74782_a("fuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        compound.func_74782_a("wearableData", (NBTBase)newCopterTag);
        compound.func_82580_o("fuelTank");
    }
}

