/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.entity.ai;

import com.darkona.adventurebackpack.reference.BackpackTypes;
import com.darkona.adventurebackpack.util.Wearing;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.world.World;

public class EntityAIHorseFollowOwner
extends EntityAIBase {
    private EntityHorse theHorse;
    private EntityPlayer theOwner;
    World theWorld;
    private double speed;
    private PathNavigate petPathfinder;
    private int tickCounter;
    float maxDist;
    float minDist;
    private boolean avoidWater;

    public EntityAIHorseFollowOwner(EntityHorse horse, double speed, float minDist, float maxDist) {
        this.theHorse = horse;
        this.theWorld = horse.field_70170_p;
        this.theOwner = this.theWorld.func_152378_a(UUID.fromString(this.theHorse.func_152119_ch()));
        this.speed = speed * 2.0;
        this.petPathfinder = horse.func_70661_as();
        this.minDist = minDist;
        this.maxDist = maxDist;
    }

    public double getDistanceSquaredToOwner() {
        double relX = this.theHorse.field_70165_t - this.theOwner.field_70165_t;
        double relY = this.theHorse.field_70163_u - this.theOwner.field_70163_u;
        double relZ = this.theHorse.field_70161_v - this.theOwner.field_70161_v;
        return relX * relX + relY * relY + relZ * relZ;
    }

    public boolean func_75250_a() {
        if (!this.theHorse.func_110248_bS() || this.theHorse.func_110167_bD() || !this.theHorse.func_94056_bM()) {
            return false;
        }
        if (this.theOwner == null) {
            this.theOwner = this.theWorld.func_152378_a(UUID.fromString(this.theHorse.func_152119_ch()));
            if (this.theOwner == null) {
                return false;
            }
        }
        if (!Wearing.isWearingTheRightBackpack(this.theOwner, BackpackTypes.HORSE)) {
            return false;
        }
        return !(this.theHorse.func_70068_e((Entity)this.theOwner) < (double)(this.minDist * this.minDist * 20.0f));
    }

    public boolean func_75253_b() {
        return Wearing.isWearingTheRightBackpack(this.theOwner, BackpackTypes.HORSE) && !this.petPathfinder.func_75500_f() && this.theHorse.func_70068_e((Entity)this.theOwner) > (double)(this.maxDist * this.maxDist * 2.0f);
    }

    public void func_75249_e() {
        this.tickCounter = 0;
        this.avoidWater = this.theHorse.func_70661_as().func_75486_a();
        this.petPathfinder = this.theHorse.func_70661_as();
    }

    public void func_75251_c() {
        this.theOwner = null;
        this.petPathfinder.func_75499_g();
        this.theHorse.func_70661_as().func_75491_a(this.avoidWater);
    }

    public void func_75246_d() {
        if (--this.tickCounter <= 0) {
            this.tickCounter = 10;
            if (!this.theHorse.func_110167_bD() && !this.petPathfinder.func_75497_a((Entity)this.theOwner, this.speed)) {
                return;
            }
        }
    }
}

