/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.client.render;

import com.darkona.adventurebackpack.client.render.CopygirlRenderUtils;
import com.darkona.adventurebackpack.reference.ToolHandler;
import com.darkona.adventurebackpack.util.GregtechUtils;
import com.darkona.adventurebackpack.util.ThaumcraftUtils;
import com.darkona.adventurebackpack.util.TinkersUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RendererStack
extends ModelRenderer {
    private static final Minecraft MC = Minecraft.func_71410_x();
    private boolean isLowerSlot;
    private ItemStack stack;
    private ToolHandler toolHandler = ToolHandler.VANILLA;

    public RendererStack(ModelBase modelBase, boolean isLowerSlot) {
        super(modelBase);
        this.isLowerSlot = isLowerSlot;
        this.func_78792_a(new Thing(modelBase));
    }

    public void setStack(ItemStack stack, ToolHandler toolHandler) {
        this.stack = stack;
        this.toolHandler = toolHandler;
    }

    private class Thing
    extends ModelRenderer {
        public Thing(ModelBase modelBase) {
            super(modelBase);
        }

        @SideOnly(value=Side.CLIENT)
        public void func_78785_a(float par1) {
            if (RendererStack.this.stack == null) {
                return;
            }
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)1048575);
            if (RendererStack.this.isLowerSlot) {
                GL11.glScalef((float)0.6f, (float)0.6f, (float)0.6f);
                GL11.glPushMatrix();
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                GL11.glScalef((float)0.7f, (float)0.7f, (float)0.7f);
                GL11.glPushMatrix();
            }
            GL11.glRotatef((float)this.getToolRotationAngle(RendererStack.this.stack, RendererStack.this.isLowerSlot, RendererStack.this.toolHandler), (float)0.0f, (float)0.0f, (float)1.0f);
            switch (RendererStack.this.toolHandler) {
                case GREGTECH: {
                    GregtechUtils.renderTool(RendererStack.this.stack, IItemRenderer.ItemRenderType.ENTITY);
                    break;
                }
                case TCONSTRUCT: {
                    TextureManager tm = MC.func_110434_K();
                    tm.func_110577_a(tm.func_130087_a(RendererStack.this.stack.func_94608_d()));
                    GL11.glTranslatef((float)-0.06f, (float)-0.1f, (float)0.0f);
                    TinkersUtils.renderTool(RendererStack.this.stack, IItemRenderer.ItemRenderType.ENTITY);
                    break;
                }
                case THAUMCRAFT: {
                    GL11.glTranslatef((float)0.0f, (float)-0.375f, (float)0.0f);
                    ThaumcraftUtils.renderTool(RendererStack.this.stack, IItemRenderer.ItemRenderType.ENTITY);
                    break;
                }
                default: {
                    CopygirlRenderUtils.renderItemIn3d(RendererStack.this.stack);
                }
            }
            GL11.glPopAttrib();
            GL11.glPopMatrix();
            GL11.glPopMatrix();
        }

        private float getToolRotationAngle(ItemStack stack, boolean isLowerSlot, ToolHandler toolHandler) {
            switch (toolHandler) {
                case GREGTECH: {
                    return GregtechUtils.getToolRotationAngle(stack, isLowerSlot);
                }
                case TCONSTRUCT: {
                    return TinkersUtils.getToolRotationAngle(stack, isLowerSlot);
                }
                case THAUMCRAFT: {
                    return ThaumcraftUtils.getToolRotationAngle(stack, isLowerSlot);
                }
            }
            return isLowerSlot ? -225.0f : 45.0f;
        }
    }
}

