/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.inventory;

import com.darkona.adventurebackpack.inventory.IInventoryBackpack;
import com.darkona.adventurebackpack.inventory.IInventoryTanks;
import com.darkona.adventurebackpack.inventory.SlotFluid;
import com.darkona.adventurebackpack.item.ItemHose;
import com.darkona.adventurebackpack.util.FluidUtils;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class InventoryActions {
    public static boolean transferContainerTank(IInventoryTanks inventory, FluidTank tank, int slotIn) {
        if (tank == null) {
            return false;
        }
        int slotOut = slotIn + 1;
        ItemStack stackHose = inventory.func_70301_a(slotOut);
        if (stackHose != null && stackHose.func_77973_b() instanceof ItemHose && tank.getFluidAmount() > 0) {
            tank.drain(tank.getFluidAmount(), true);
            return true;
        }
        ItemStack stackIn = inventory.func_70301_a(slotIn);
        if (stackIn == null) {
            return false;
        }
        if (FluidContainerRegistry.isFilledContainer((ItemStack)stackIn)) {
            int fill = tank.fill(FluidContainerRegistry.getFluidForFilledItem((ItemStack)stackIn), false);
            if (fill > 0 && FluidContainerRegistry.getContainerCapacity((ItemStack)stackIn) + tank.getFluidAmount() <= tank.getCapacity()) {
                int maxStack;
                ItemStack stackOut = FluidContainerRegistry.drainFluidContainer((ItemStack)stackIn);
                if (inventory.func_70301_a(slotOut) == null || stackOut == null) {
                    tank.fill(FluidContainerRegistry.getFluidForFilledItem((ItemStack)stackIn), true);
                    inventory.decrStackSizeNoSave(slotIn, 1);
                    inventory.setInventorySlotContentsNoSave(slotOut, stackOut);
                    return true;
                }
                if (inventory.func_70301_a(slotOut).func_77973_b().equals(stackOut.func_77973_b()) && stackOut.func_77960_j() == inventory.func_70301_a(slotOut).func_77960_j() && (maxStack = inventory.func_70301_a(slotOut).func_77976_d()) > 1 && inventory.func_70301_a((int)slotOut).field_77994_a + 1 <= maxStack) {
                    tank.fill(FluidContainerRegistry.getFluidForFilledItem((ItemStack)stackIn), true);
                    inventory.decrStackSizeNoSave(slotIn, 1);
                    ++inventory.func_70301_a((int)slotOut).field_77994_a;
                    return true;
                }
            }
        } else if (tank.getFluid() != null && tank.getFluidAmount() > 0 && FluidUtils.isEmptyContainerForFluid(stackIn, tank.getFluid().getFluid())) {
            int amount = FluidContainerRegistry.getContainerCapacity((FluidStack)tank.getFluid(), (ItemStack)stackIn);
            FluidStack drain = tank.drain(amount, false);
            if (amount > 0 && drain.amount == amount) {
                int maxStack;
                ItemStack stackOut = FluidContainerRegistry.fillFluidContainer((FluidStack)drain, (ItemStack)stackIn);
                if (inventory.func_70301_a(slotOut) == null || stackOut == null) {
                    tank.drain(amount, true);
                    inventory.decrStackSizeNoSave(slotIn, 1);
                    inventory.setInventorySlotContentsNoSave(slotOut, stackOut);
                    return true;
                }
                if (stackOut.func_77973_b().equals(inventory.func_70301_a(slotOut).func_77973_b()) && stackOut.func_77960_j() == inventory.func_70301_a(slotOut).func_77960_j() && (maxStack = inventory.func_70301_a(slotOut).func_77976_d()) > 1 && inventory.func_70301_a((int)slotOut).field_77994_a + 1 <= maxStack) {
                    tank.drain(amount, true);
                    inventory.decrStackSizeNoSave(slotIn, 1);
                    ++inventory.func_70301_a((int)slotOut).field_77994_a;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean areStacksCompatible(ItemStack stackA, ItemStack stackB) {
        return stackA.func_77973_b() == stackB.func_77973_b() && (!stackA.func_77981_g() || stackA.func_77960_j() == stackB.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stackA, (ItemStack)stackB);
    }

    public static void consumeItemInInventory(IInventory backpack, Item item) {
        int i = -1;
        for (int j = 0; j < 47; ++j) {
            if (backpack.func_70301_a(j) == null || backpack.func_70301_a(j).func_77973_b() != item) continue;
            i = j;
            break;
        }
        if (i >= 0) {
            backpack.func_70298_a(i, 1);
        }
    }

    public static boolean hasItem(IInventoryBackpack backpack, Item item) {
        ItemStack[] inventory;
        for (ItemStack slotStack : inventory = backpack.getInventory()) {
            if (slotStack == null || !slotStack.func_77973_b().equals(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasBlockItem(IInventoryBackpack backpack, Block item) {
        ItemStack[] inventory;
        for (ItemStack slotStack : inventory = backpack.getInventory()) {
            if (slotStack == null || !slotStack.func_77973_b().equals(Item.func_150898_a((Block)item))) continue;
            return true;
        }
        return false;
    }

    public static boolean areContainersOfSameType(ItemStack stackIn, ItemStack stackOut) {
        if (stackIn == null || stackOut == null) {
            return false;
        }
        if (SlotFluid.isFilled(stackIn) && SlotFluid.isEmpty(stackOut)) {
            ItemStack emptyIn = SlotFluid.getEmptyContainer(stackIn);
            return stackOut.func_77985_e() && InventoryActions.areStacksCompatible(emptyIn, stackOut);
        }
        if (SlotFluid.isEmpty(stackIn) && SlotFluid.isFilled(stackOut)) {
            ItemStack emptyOut = SlotFluid.getEmptyContainer(stackOut);
            return stackOut.func_77985_e() && InventoryActions.areStacksCompatible(stackIn, emptyOut);
        }
        return false;
    }
}

