/*
 * Decompiled with CFR 0.152.
 */
package alkalus.main.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.emoniph.witchery.brewing.AltarPower;
import com.emoniph.witchery.brewing.WitcheryBrewRegistry;
import com.emoniph.witchery.brewing.action.BrewAction;
import com.emoniph.witchery.brewing.action.BrewActionRitualRecipe;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiCrafting;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class NEI_Handler_Cauldron
extends TemplateRecipeHandler {
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(92, 31, 24, 18), "witchery_brewing_plus", new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiCrafting.class;
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"tile.witchery:cauldron.name");
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("witchery_brewing_plus") && ((Object)((Object)this)).getClass() == NEI_Handler_Cauldron.class) {
            for (BrewActionRitualRecipe ritual : WitcheryBrewRegistry.INSTANCE.getRecipes()) {
                for (BrewActionRitualRecipe.Recipe recipe : ritual.getExpandedRecipes()) {
                    this.arecipes.add(new CachedKettleRecipe(recipe.result, recipe.ingredients, this.getPowerCost((BrewAction)ritual)));
                }
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (BrewActionRitualRecipe ritual : WitcheryBrewRegistry.INSTANCE.getRecipes()) {
            for (BrewActionRitualRecipe.Recipe recipe : ritual.getExpandedRecipes()) {
                if (!result.func_77969_a(recipe.result)) continue;
                this.arecipes.add(new CachedKettleRecipe(recipe.result, recipe.ingredients, this.getPowerCost((BrewAction)ritual)));
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (BrewActionRitualRecipe ritual : WitcheryBrewRegistry.INSTANCE.getRecipes()) {
            try {
                for (BrewActionRitualRecipe.Recipe recipe : ritual.getExpandedRecipes()) {
                    for (ItemStack stack : recipe.ingredients) {
                        if (!stack.func_77969_a(ingredient)) continue;
                        this.arecipes.add(new CachedKettleRecipe(recipe.result, recipe.ingredients, this.getPowerCost((BrewAction)ritual)));
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public String getGuiTexture() {
        return "witchery:textures/gui/witchesCauldron.png";
    }

    public void drawExtras(int recipeIndex) {
        int power = ((CachedKettleRecipe)((Object)this.arecipes.get(recipeIndex))).getPower();
        if (power == 0) {
            return;
        }
        String text = I18n.func_135052_a((String)"WitcheryExtras.nei.power", (Object[])new Object[]{power});
        GuiDraw.drawString((String)text, (int)5, (int)54, (int)0, (boolean)false);
    }

    public String getOverlayIdentifier() {
        return "witchery_brewing_plus";
    }

    private AltarPower getPowerCost(BrewAction recipe) {
        try {
            Field powerCostField = BrewAction.class.getDeclaredField("powerCost");
            powerCostField.setAccessible(true);
            return (AltarPower)powerCostField.get(recipe);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public class CachedKettleRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack result;
        PositionedStack[] inputs;
        int power;

        public CachedKettleRecipe(ItemStack result, ItemStack[] recipe, AltarPower powerCost) {
            super((TemplateRecipeHandler)NEI_Handler_Cauldron.this);
            this.inputs = new PositionedStack[6];
            this.result = new PositionedStack((Object)result, 119, 31);
            for (int i = 0; i < recipe.length; ++i) {
                this.inputs[i] = recipe[i] != null ? new PositionedStack((Object)recipe[i], i * 18 + 10, 6) : null;
            }
            if (powerCost != null) {
                this.power = powerCost.getPower();
            }
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public ArrayList<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> recipestacks = new ArrayList<PositionedStack>();
            for (PositionedStack posStack : this.inputs) {
                if (posStack == null) continue;
                recipestacks.add(posStack);
            }
            return recipestacks;
        }

        public int getPower() {
            return this.power;
        }
    }
}

