/*
 * Decompiled with CFR 0.152.
 */
package alkalus.main.core.util;

import alkalus.main.asm.AsmConfig;
import alkalus.main.core.util.ReflectionUtils;
import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockPoppetShelf;
import com.emoniph.witchery.util.Log;
import java.lang.reflect.Field;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class PoppetShelfUtils {
    private static ForgeChunkManager.Ticket getShelfTicket(BlockPoppetShelf.TileEntityPoppetShelf aShelf) {
        Field aChunkTicket = ReflectionUtils.getField(BlockPoppetShelf.TileEntityPoppetShelf.class, "");
        if (aChunkTicket != null) {
            return (ForgeChunkManager.Ticket)ReflectionUtils.getFieldValue(aChunkTicket, aShelf);
        }
        return null;
    }

    public static void initiate(BlockPoppetShelf.TileEntityPoppetShelf aShelf) {
        if (AsmConfig.allowPoppetShelfChunkLoading) {
            ForgeChunkManager.Ticket chunkTicket = PoppetShelfUtils.getShelfTicket(aShelf);
            if (!aShelf.func_145831_w().field_72995_K && chunkTicket == null) {
                chunkTicket = ForgeChunkManager.requestTicket((Object)Witchery.instance, (World)aShelf.func_145831_w(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
                if (chunkTicket != null) {
                    chunkTicket.getModData().func_74768_a("poppetX", aShelf.field_145851_c);
                    chunkTicket.getModData().func_74768_a("poppetY", aShelf.field_145848_d);
                    chunkTicket.getModData().func_74768_a("poppetZ", aShelf.field_145849_e);
                    aShelf.forceChunkLoading(chunkTicket);
                } else {
                    Log.instance().warning(String.format("The poppet shelf at %d, %d, %d failed to register a chunk loader.", aShelf.field_145851_c, aShelf.field_145848_d, aShelf.field_145849_e));
                }
            }
        }
    }

    public static void invalidate(BlockPoppetShelf.TileEntityPoppetShelf aShelf) {
        if (!aShelf.func_145831_w().field_72995_K && AsmConfig.allowPoppetShelfChunkLoading) {
            ForgeChunkManager.Ticket chunkTicket = PoppetShelfUtils.getShelfTicket(aShelf);
            if (chunkTicket != null) {
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)chunkTicket);
            } else {
                Log.instance().warning(String.format("Chunk loader ticket is null for poppet shelf at %d, %d, %d.", aShelf.field_145851_c, aShelf.field_145848_d, aShelf.field_145849_e));
            }
        }
    }
}

