/*
 * Decompiled with CFR 0.152.
 */
package net.p455w0rd.wirelesscraftingterminal.helpers;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.features.ILocatable;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.implementations.guiobjects.IPortableCell;
import appeng.api.implementations.tiles.IWirelessAccessPoint;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IMachineSet;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.container.interfaces.IInventorySlotAware;
import appeng.tile.networking.TileWireless;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.p455w0rd.wirelesscraftingterminal.api.networking.security.WCTIActionHost;

public class WirelessTerminalGuiObject
implements IActionHost,
IPortableCell,
IInventorySlotAware,
WCTIActionHost {
    private final ItemStack effectiveItem;
    private final IWirelessTermHandler wth;
    private final String encryptionKey;
    private final EntityPlayer myPlayer;
    private IGrid targetGrid;
    private IStorageGrid sg;
    private IMEMonitor<IAEItemStack> itemStorage;
    private IWirelessAccessPoint myWap;
    private double sqRange = Double.MAX_VALUE;
    private double myRange = Double.MAX_VALUE;
    private final int inventorySlot;

    public WirelessTerminalGuiObject(IWirelessTermHandler wh, ItemStack is, EntityPlayer ep, World w, int x, int y, int z) {
        IGridNode n;
        this.encryptionKey = wh.getEncryptionKey(is);
        this.effectiveItem = is;
        this.myPlayer = ep;
        this.wth = wh;
        this.inventorySlot = x;
        ILocatable obj = null;
        try {
            long encKey = Long.parseLong(this.encryptionKey);
            obj = AEApi.instance().registries().locatable().getLocatableBy(encKey);
        }
        catch (NumberFormatException encKey) {
            // empty catch block
        }
        if (obj instanceof IGridHost && (n = ((IGridHost)obj).getGridNode(ForgeDirection.UNKNOWN)) != null) {
            this.targetGrid = n.getGrid();
            if (this.targetGrid != null) {
                this.sg = (IStorageGrid)this.targetGrid.getCache(IStorageGrid.class);
                if (this.sg != null) {
                    this.itemStorage = this.sg.getItemInventory();
                }
            }
        }
    }

    public IGrid getTargetGrid() {
        return this.targetGrid;
    }

    public double getRange() {
        return this.myRange;
    }

    public IMEMonitor<IAEItemStack> getItemInventory() {
        if (this.sg == null) {
            return null;
        }
        return this.sg.getItemInventory();
    }

    public IMEMonitor<IAEFluidStack> getFluidInventory() {
        if (this.sg == null) {
            return null;
        }
        return this.sg.getFluidInventory();
    }

    public void addListener(IMEMonitorHandlerReceiver<IAEItemStack> l, Object verificationToken) {
        if (this.itemStorage != null) {
            this.itemStorage.addListener(l, verificationToken);
        }
    }

    public void removeListener(IMEMonitorHandlerReceiver<IAEItemStack> l) {
        if (this.itemStorage != null) {
            this.itemStorage.removeListener(l);
        }
    }

    public IItemList<IAEItemStack> getAvailableItems(IItemList out) {
        if (this.itemStorage != null) {
            return this.itemStorage.getAvailableItems(out);
        }
        return out;
    }

    public IItemList<IAEItemStack> getStorageList() {
        if (this.itemStorage != null) {
            return this.itemStorage.getStorageList();
        }
        return null;
    }

    public AccessRestriction getAccess() {
        if (this.itemStorage != null) {
            return this.itemStorage.getAccess();
        }
        return AccessRestriction.NO_ACCESS;
    }

    public boolean isPrioritized(IAEItemStack input) {
        if (this.itemStorage != null) {
            return this.itemStorage.isPrioritized((IAEStack)input);
        }
        return false;
    }

    public boolean canAccept(IAEItemStack input) {
        if (this.itemStorage != null) {
            return this.itemStorage.canAccept((IAEStack)input);
        }
        return false;
    }

    public int getPriority() {
        if (this.itemStorage != null) {
            return this.itemStorage.getPriority();
        }
        return 0;
    }

    public int getSlot() {
        if (this.itemStorage != null) {
            return this.itemStorage.getSlot();
        }
        return 0;
    }

    public boolean validForPass(int i) {
        return this.itemStorage.validForPass(i);
    }

    public IAEItemStack injectItems(IAEItemStack input, Actionable type, BaseActionSource src) {
        if (this.itemStorage != null) {
            return (IAEItemStack)this.itemStorage.injectItems((IAEStack)input, type, src);
        }
        return input;
    }

    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, BaseActionSource src) {
        if (this.itemStorage != null) {
            return (IAEItemStack)this.itemStorage.extractItems((IAEStack)request, mode, src);
        }
        return null;
    }

    public StorageChannel getChannel() {
        if (this.itemStorage != null) {
            return this.itemStorage.getChannel();
        }
        return StorageChannel.ITEMS;
    }

    public double extractAEPower(double amt, Actionable mode, PowerMultiplier usePowerMultiplier) {
        if (this.wth != null && this.effectiveItem != null) {
            if (mode == Actionable.SIMULATE) {
                return this.wth.hasPower(this.myPlayer, amt, this.effectiveItem) ? amt : 0.0;
            }
            return this.wth.usePower(this.myPlayer, amt, this.effectiveItem) ? amt : 0.0;
        }
        return 0.0;
    }

    public ItemStack getItemStack() {
        return this.effectiveItem;
    }

    public IConfigManager getConfigManager() {
        return this.wth.getConfigManager(this.effectiveItem);
    }

    public IGridNode getGridNode(ForgeDirection dir) {
        return this.getActionableNode();
    }

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.NONE;
    }

    public void securityBreak() {
    }

    @Override
    public IGridNode getActionableNode() {
        return this.getActionableNode(false);
    }

    @Override
    public IGridNode getActionableNode(boolean ignoreRange) {
        this.rangeCheck(ignoreRange);
        if (this.myWap != null) {
            return this.myWap.getActionableNode();
        }
        if (ignoreRange) {
            return this.getTargetGrid().getPivot();
        }
        return null;
    }

    public boolean rangeCheck() {
        return this.rangeCheck(false);
    }

    public boolean rangeCheck(boolean ignoreRange) {
        this.myRange = Double.MAX_VALUE;
        this.sqRange = Double.MAX_VALUE;
        if (this.targetGrid != null && this.itemStorage != null) {
            if (this.myWap != null) {
                return this.myWap.getGrid() == this.targetGrid && this.testWap(this.myWap);
            }
            IMachineSet tw = this.targetGrid.getMachines(TileWireless.class);
            this.myWap = null;
            for (IGridNode n : tw) {
                IWirelessAccessPoint wap = (IWirelessAccessPoint)n.getMachine();
                if (!this.testWap(wap, ignoreRange)) continue;
                this.myWap = wap;
            }
            return this.myWap != null;
        }
        return false;
    }

    private boolean testWap(IWirelessAccessPoint wap) {
        return this.testWap(wap, false);
    }

    private boolean testWap(IWirelessAccessPoint wap, boolean ignoreRange) {
        double rangeLimit = wap.getRange();
        rangeLimit *= rangeLimit;
        DimensionalCoord dc = wap.getLocation();
        if (dc.getWorld() == this.myPlayer.field_70170_p) {
            double offX = (double)dc.x - this.myPlayer.field_70165_t;
            double offY = (double)dc.y - this.myPlayer.field_70163_u;
            double offZ = (double)dc.z - this.myPlayer.field_70161_v;
            double r = offX * offX + offY * offY + offZ * offZ;
            if (r < rangeLimit && this.sqRange > r && !ignoreRange) {
                if (wap.isActive()) {
                    this.sqRange = r;
                    this.myRange = Math.sqrt(r);
                    return true;
                }
            } else if (wap.isActive() && ignoreRange) {
                this.sqRange = r;
                this.myRange = Math.sqrt(r);
                return true;
            }
        }
        return false;
    }

    public int getInventorySlot() {
        return this.inventorySlot;
    }
}

