/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.handlers.warpevents;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import shukaro.warptheory.handlers.IWarpEvent;
import shukaro.warptheory.util.ChatHelper;
import shukaro.warptheory.util.FormatCodes;
import shukaro.warptheory.util.MiscHelper;

public class WarpLightning
extends IWarpEvent {
    private final int _mMinWarpLevel;

    public WarpLightning(int pMinWarpLevel) {
        this._mMinWarpLevel = pMinWarpLevel;
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Override
    public String getName() {
        return "lightning";
    }

    @Override
    public int getSeverity() {
        return this._mMinWarpLevel;
    }

    @Override
    public boolean doEvent(World world, EntityPlayer player) {
        ChatHelper.sendToPlayer(player, FormatCodes.Purple.code + FormatCodes.Italic.code + StatCollector.func_74838_a((String)"chat.warptheory.lightning"));
        MiscHelper.modEventInt(player, "lightning", 5 + world.field_73012_v.nextInt(10));
        return true;
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent e) {
        if (e.phase != TickEvent.Phase.END || e.side != Side.SERVER) {
            return;
        }
        for (EntityPlayer player : (ArrayList)e.world.field_73010_i) {
            if (!MiscHelper.getWarpTag(player).func_74764_b("lightning")) continue;
            int lightning = MiscHelper.getWarpTag(player).func_74762_e("lightning");
            int x = (int)player.field_70165_t + e.world.field_73012_v.nextInt(3) - e.world.field_73012_v.nextInt(3);
            int y = (int)player.field_70163_u;
            int z = (int)player.field_70161_v + e.world.field_73012_v.nextInt(3) - e.world.field_73012_v.nextInt(3);
            if (e.world.field_73012_v.nextInt(100) != 0 || !e.world.func_72937_j(x, y, z)) continue;
            EntityLightningBolt bolt = new EntityLightningBolt(e.world, (double)x, (double)y, (double)z);
            e.world.func_72942_c((Entity)bolt);
            MiscHelper.getWarpTag(player).func_74768_a("lightning", --lightning);
            if (lightning > 0) continue;
            MiscHelper.getWarpTag(player).func_82580_o("lightning");
        }
    }
}

