/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.handlers.warpevents;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import shukaro.warptheory.handlers.IWarpEvent;
import shukaro.warptheory.util.ChatHelper;
import shukaro.warptheory.util.FormatCodes;
import shukaro.warptheory.util.MiscHelper;

public class WarpLivestockRain
extends IWarpEvent {
    private final int _mMinWarpLevel;

    public WarpLivestockRain(int pMinWarpLevel) {
        this._mMinWarpLevel = pMinWarpLevel;
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Override
    public String getName() {
        return "livestock";
    }

    @Override
    public int getSeverity() {
        return this._mMinWarpLevel;
    }

    @Override
    public boolean doEvent(World world, EntityPlayer player) {
        ChatHelper.sendToPlayer(player, FormatCodes.Purple.code + FormatCodes.Italic.code + StatCollector.func_74838_a((String)"chat.warptheory.livestock"));
        MiscHelper.modEventInt(player, this.getName(), 5 + world.field_73012_v.nextInt(10));
        return true;
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent e) {
        if (e.phase != TickEvent.Phase.END || e.side != Side.SERVER) {
            return;
        }
        block5: for (EntityPlayer player : (ArrayList)e.world.field_73010_i) {
            if (!MiscHelper.getWarpTag(player).func_74764_b("livestock")) continue;
            int livestock = MiscHelper.getWarpTag(player).func_74762_e("livestock");
            for (int i = 0; i < 6; ++i) {
                EntityCow victim;
                int targetX = (int)player.field_70165_t + e.world.field_73012_v.nextInt(8) - e.world.field_73012_v.nextInt(8);
                int targetY = (int)player.field_70163_u + e.world.field_73012_v.nextInt(8) - e.world.field_73012_v.nextInt(8);
                int targetZ = (int)player.field_70161_v + e.world.field_73012_v.nextInt(8) - e.world.field_73012_v.nextInt(8);
                boolean canDrop = true;
                for (int y = targetY; y < targetY + 25; ++y) {
                    if (e.world.func_147437_c(targetX, y, targetZ)) continue;
                    canDrop = false;
                    break;
                }
                if (!canDrop || !e.world.func_147437_c(targetX, targetY += 25, targetZ)) continue;
                switch (e.world.field_73012_v.nextInt(3)) {
                    case 0: {
                        victim = new EntityCow(e.world);
                        break;
                    }
                    case 1: {
                        victim = new EntityPig(e.world);
                        break;
                    }
                    case 2: {
                        victim = new EntitySheep(e.world);
                        break;
                    }
                    default: {
                        victim = new EntityChicken(e.world);
                    }
                }
                victim.func_70642_aH();
                victim.func_70012_b((double)targetX + e.world.field_73012_v.nextDouble(), (double)targetY + e.world.field_73012_v.nextDouble(), (double)targetZ + e.world.field_73012_v.nextDouble(), e.world.field_73012_v.nextFloat(), e.world.field_73012_v.nextFloat());
                if (!e.world.func_72838_d((Entity)victim)) continue;
                MiscHelper.getWarpTag(player).func_74768_a("livestock", --livestock);
                if (livestock > 0) continue block5;
                MiscHelper.getWarpTag(player).func_82580_o("livestock");
                continue block5;
            }
        }
    }
}

