/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.handlers.warpevents;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import shukaro.warptheory.handlers.IWarpEvent;
import shukaro.warptheory.util.MiscHelper;

public class WarpFakeSound
extends IWarpEvent {
    private final int _mMinWarpLevel;
    private final String name;
    private final String sound;
    private int distance = 16;

    public WarpFakeSound(int pMinWarpLevel, String name, String sound) {
        this._mMinWarpLevel = pMinWarpLevel;
        this.name = name;
        this.sound = sound;
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public WarpFakeSound(int pMinWarpLevel, String name, String sound, int distance) {
        this._mMinWarpLevel = pMinWarpLevel;
        this.name = name;
        this.sound = sound;
        this.distance = distance;
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getSeverity() {
        return this._mMinWarpLevel;
    }

    @Override
    public boolean doEvent(World world, EntityPlayer player) {
        MiscHelper.modEventInt(player, this.getName(), 1);
        return true;
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent e) {
        if (e.phase != TickEvent.Phase.END || e.side != Side.SERVER) {
            return;
        }
        for (EntityPlayer player : (ArrayList)e.world.field_73010_i) {
            int fakesound = MiscHelper.getWarpTag(player).func_74762_e(this.getName());
            if (fakesound <= 0 || e.world.func_82737_E() % 20L != 0L) continue;
            int targetX = (int)player.field_70165_t + e.world.field_73012_v.nextInt(2 * this.distance) - this.distance;
            int targetY = (int)player.field_70163_u + e.world.field_73012_v.nextInt(2 * this.distance) - this.distance;
            int targetZ = (int)player.field_70161_v + e.world.field_73012_v.nextInt(2 * this.distance) - this.distance;
            e.world.func_72908_a((double)targetX, (double)targetY, (double)targetZ, this.sound, 1.0f, 1.0f);
            MiscHelper.getWarpTag(player).func_74768_a(this.getName(), --fakesound);
        }
    }
}

