/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.handlers;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import shukaro.warptheory.handlers.ConfigHandler;
import shukaro.warptheory.handlers.IWarpEvent;
import shukaro.warptheory.handlers.WarpHandler;
import shukaro.warptheory.util.MiscHelper;

public abstract class IMultiWarpEvent
extends IWarpEvent {
    protected final ImmutableBiMap<Integer, String> eventLevels;
    protected final ImmutableList<Map.Entry<Integer, String>> reversedEventLevels;
    protected final Function<World, Integer> incrementFunction;

    protected IMultiWarpEvent(String name, int minWarp, int numLevels, Function<World, Integer> incrementFunction) {
        super(name, minWarp);
        this.incrementFunction = incrementFunction;
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        builder.put((Object)0, (Object)name);
        for (int i = 1; i < numLevels; ++i) {
            builder.put((Object)i, (Object)(name + i));
        }
        this.eventLevels = builder.build();
        this.reversedEventLevels = ImmutableList.copyOf((Collection)Lists.reverse((List)Lists.newArrayList((Iterable)this.eventLevels.entrySet())));
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public abstract int triggerEvent(int var1, int var2, World var3, EntityPlayer var4);

    public ImmutableBiMap<Integer, String> getEventLevels() {
        return this.eventLevels;
    }

    protected int calculateEventLevel(World world, EntityPlayer player) {
        int promotionWarp;
        if (!ConfigHandler.allowMultiWarpEffects) {
            return 0;
        }
        int eventLevel = 0;
        int totalWarp = WarpHandler.getTotalWarp(player);
        for (int i = 1; i < this.eventLevels.size() && world.field_73012_v.nextInt(this.minWarp + (promotionWarp = MathHelper.func_76125_a((int)(totalWarp - (i + 1) * this.minWarp), (int)0, (int)this.minWarp))) >= this.minWarp; ++i) {
            ++eventLevel;
        }
        return eventLevel;
    }

    @Override
    public boolean doEvent(World world, EntityPlayer player) {
        int eventLevel = this.calculateEventLevel(world, player);
        return this.doEvent((String)this.eventLevels.get((Object)eventLevel), world, player);
    }

    public boolean doEvent(String tagName, World world, EntityPlayer player) {
        this.sendChatMessage(player);
        MiscHelper.modEventInt(player, tagName, this.incrementFunction.apply(world));
        return true;
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent e) {
        if (e.phase != TickEvent.Phase.END || e.side != Side.SERVER) {
            return;
        }
        block0: for (EntityPlayer player : e.world.field_73010_i) {
            for (Map.Entry entry : this.reversedEventLevels) {
                String tag = (String)entry.getValue();
                if (!MiscHelper.getWarpTag(player).func_74764_b(tag)) continue;
                int eventAmount = MiscHelper.getWarpTag(player).func_74762_e(tag);
                int decrement = this.triggerEvent((Integer)entry.getKey(), eventAmount, e.world, player);
                this.decreaseTag(player, tag, decrement);
                continue block0;
            }
        }
    }
}

