/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import shukaro.warptheory.entity.IHealable;
import shukaro.warptheory.entity.IHurtable;
import shukaro.warptheory.util.ChatHelper;
import shukaro.warptheory.util.FormatCodes;

public class EntityDoppelganger
extends EntityCreature
implements IHealable,
IHurtable {
    protected static final int FIND_PLAYER_WAIT_TICKS = 20;
    protected static final int HEAL_WAIT_TICKS = 40;
    protected static final int UUID_DATA_WATCHER_ID = 16;
    protected static final String UUID_NBT_TAG = "playerUuid";
    protected static final Map<UUID, GameProfile> gameProfileCache = new HashMap<UUID, GameProfile>();
    protected int healWait;

    public EntityDoppelganger(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.healWait = 40;
    }

    public void initialize(EntityPlayer player) {
        this.field_70180_af.func_75692_b(16, (Object)player.func_110124_au().toString());
        String name = StatCollector.func_74837_a((String)"chat.warptheory.doppelganger.name", (Object[])new Object[]{player.getDisplayName()});
        this.func_94058_c(name);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)player.func_110138_aP());
        this.func_70606_j(player.func_110143_aJ());
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public ResourceLocation getPlayerSkin() {
        SkinManager skinManager;
        Map textureMap;
        String uuidString = this.field_70180_af.func_75681_e(16);
        if (uuidString.isEmpty()) {
            return null;
        }
        UUID uuid = UUID.fromString(uuidString);
        GameProfile gameProfile = gameProfileCache.get(uuid);
        if (gameProfile == null) {
            gameProfile = Minecraft.func_71410_x().func_152347_ac().fillProfileProperties(new GameProfile(uuid, null), true);
            gameProfileCache.put(uuid, gameProfile);
        }
        if ((textureMap = (skinManager = Minecraft.func_71410_x().func_152342_ad()).func_152788_a(gameProfile)).containsKey(MinecraftProfileTexture.Type.SKIN)) {
            return skinManager.func_152792_a((MinecraftProfileTexture)textureMap.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
        }
        return null;
    }

    @Override
    public void onHeal(LivingHealEvent e) {
        if (e.amount <= 0.5f) {
            return;
        }
        float currentDamage = this.func_110138_aP() - this.func_110143_aJ();
        float amount = Math.min(e.amount, currentDamage);
        if (amount <= 0.0f) {
            return;
        }
        Optional<EntityPlayerMP> player = this.findPlayer();
        if (!player.isPresent()) {
            return;
        }
        EntityPlayer entityPlayer = (EntityPlayer)player.get();
        if (entityPlayer.func_110143_aJ() < entityPlayer.func_110138_aP()) {
            entityPlayer.func_70691_i(amount);
            ChatHelper.sendToPlayer(entityPlayer, FormatCodes.Purple.code + FormatCodes.Italic.code + StatCollector.func_74838_a((String)"chat.warptheory.doppelganger.heal"));
        }
    }

    @Override
    public void onHurt(LivingHurtEvent e) {
        Optional<EntityPlayerMP> player = this.findPlayer();
        if (!player.isPresent()) {
            return;
        }
        EntityPlayer entityPlayer = (EntityPlayer)player.get();
        DamageSource damageSource = DamageSource.func_76354_b((Entity)this, (Entity)this);
        float damage = Math.min(e.ammount, this.func_110143_aJ());
        entityPlayer.func_70097_a(damageSource, damage);
        if (this.func_110143_aJ() > e.ammount) {
            ChatHelper.sendToPlayer(entityPlayer, FormatCodes.Purple.code + FormatCodes.Italic.code + StatCollector.func_74838_a((String)"chat.warptheory.doppelganger.hurt"));
        } else {
            ChatHelper.sendToPlayer(entityPlayer, FormatCodes.Purple.code + FormatCodes.Italic.code + StatCollector.func_74838_a((String)"chat.warptheory.doppelganger.die"));
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)"");
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_110143_aJ() < this.func_110138_aP()) {
            if (this.healWait > 0) {
                --this.healWait;
            } else {
                this.healWait = 40;
                this.func_70691_i(0.5f);
            }
        } else {
            this.healWait = 40;
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    protected boolean func_70650_aV() {
        return true;
    }

    public boolean func_70652_k(Entity entity) {
        return true;
    }

    protected Item func_146068_u() {
        return Items.field_151078_bh;
    }

    protected void func_70600_l(int par1) {
        Optional<EntityPlayerMP> player = this.findPlayer();
        if (!player.isPresent()) {
            return;
        }
        ItemStack head = new ItemStack(Items.field_151144_bL, 1, 2);
        head.func_77964_b(3);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("SkullOwner", player.get().getDisplayName());
        head.func_77982_d(nbt);
        this.func_70099_a(head, 0.0f);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        String uuid = this.field_70180_af.func_75681_e(16);
        if (!uuid.isEmpty()) {
            nbt.func_74778_a(UUID_NBT_TAG, uuid);
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b(UUID_NBT_TAG)) {
            this.field_70180_af.func_75692_b(16, (Object)nbt.func_74779_i(UUID_NBT_TAG));
        }
    }

    private Optional<EntityPlayerMP> findPlayer() {
        if (this.field_70170_p.field_72995_K) {
            return Optional.empty();
        }
        String uuid = this.field_70180_af.func_75681_e(16);
        UUID uuidObj = UUID.fromString(uuid);
        List players = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        for (EntityPlayerMP entityPlayer : players) {
            if (!entityPlayer.func_110124_au().equals(uuidObj)) continue;
            return Optional.of(entityPlayer);
        }
        return Optional.empty();
    }
}

