/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class Dependencies<D> {
    private final Map<Class, D> dependencies = new IdentityHashMap<Class, D>();
    private final Map<Class, DependenceWatcher<? extends D>> dependenciesWatchers = new IdentityHashMap<Class, DependenceWatcher<? extends D>>();

    public final <I extends D> void add(Class<? extends I> typeClass) {
        if (this.dependencies.containsKey(typeClass)) {
            return;
        }
        DependenceWatcher<D> dependenceWatcher = this.dependenciesWatchers.get(typeClass);
        if (dependenceWatcher != null) {
            this.add(dependenceWatcher.instantiate());
            return;
        }
        try {
            Constructor<I> constructor = typeClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            this.add(constructor.newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public final <I extends D> void add(I instance) {
        Class<?> typeClass = instance.getClass();
        if (this.dependencies.containsKey(typeClass)) {
            return;
        }
        this.dependencies.put(typeClass, instance);
    }

    public final <I extends D> I get(Class<I> typeClass) {
        D instance = this.dependencies.get(typeClass);
        if (instance != null) {
            return (I)instance;
        }
        this.add((I)typeClass);
        return (I)this.dependencies.get(typeClass);
    }

    public final boolean contains(Class<? extends D> typeClass) {
        return this.dependencies.containsKey(typeClass);
    }

    public final void subscribe(DependenceWatcher<? extends D> dependenceWatcher) {
        if (!this.dependenciesWatchers.containsKey(((DependenceWatcher)dependenceWatcher).dependenceClass)) {
            this.dependenciesWatchers.put(((DependenceWatcher)dependenceWatcher).dependenceClass, dependenceWatcher);
        }
    }

    public abstract class DependenceWatcher<W extends D> {
        private final Class<W> dependenceClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];

        protected DependenceWatcher() {
        }

        @Nonnull
        public abstract W instantiate();
    }
}

