/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.recipe.advanced;

import gnu.trove.map.TShortObjectMap;
import gnu.trove.map.hash.TShortObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import wanion.lib.recipe.advanced.IAdvancedRecipe;

public abstract class AbstractRecipeRegistry<R extends IAdvancedRecipe> {
    public final TShortObjectMap<List<R>> shapedRecipes = new TShortObjectHashMap();
    public final TShortObjectMap<List<R>> shapelessRecipes = new TShortObjectHashMap();

    public final void addRecipe(@Nonnull R recipe) {
        short recipeKey = recipe.getRecipeKey();
        if (recipeKey != 0) {
            if (!this.shapedRecipes.containsKey(recipeKey)) {
                this.shapedRecipes.put(recipeKey, new ArrayList());
            }
            ((List)this.shapedRecipes.get(recipeKey)).add(recipe);
        } else {
            short recipeSize = recipe.getRecipeSize();
            if (!this.shapelessRecipes.containsKey(recipeSize)) {
                this.shapelessRecipes.put(recipeSize, new ArrayList());
            }
            ((List)this.shapelessRecipes.get(recipeSize)).add(recipe);
        }
    }

    public final void removeRecipe(@Nullable R recipe) {
        if (recipe == null) {
            return;
        }
        short recipeKey = recipe.getRecipeKey();
        if (recipeKey != 0) {
            List shapedRecipeList = (List)this.shapedRecipes.get(recipeKey);
            if (shapedRecipeList != null) {
                shapedRecipeList.remove(recipe);
            }
        } else {
            List shapelessRecipeList = (List)this.shapelessRecipes.get(recipe.getRecipeSize());
            if (shapelessRecipeList != null) {
                shapelessRecipeList.remove(recipe);
            }
        }
    }

    public final R findMatchingRecipe(@Nonnull InventoryCrafting inventoryCrafting) {
        List recipeList;
        int x;
        int y;
        int root = (int)Math.sqrt(inventoryCrafting.func_70302_i_());
        int offSetX = 0;
        int offSetY = 0;
        int width = 0;
        int height = 0;
        short recipeKey = 0;
        short recipeSize = 0;
        boolean foundX = false;
        boolean foundY = false;
        for (int x2 = 0; !foundX && x2 < root; ++x2) {
            for (int y2 = 0; !foundX && y2 < root; ++y2) {
                if (inventoryCrafting.func_70301_a(y2 * root + x2) == null) continue;
                foundX = true;
            }
            if (!foundX) continue;
            offSetX = x2;
        }
        for (y = 0; !foundY && y < root; ++y) {
            for (x = 0; x < root; ++x) {
                if (inventoryCrafting.func_70301_a(y * root + x) != null) {
                    foundY = true;
                }
                if (!foundY) continue;
                offSetY = y;
            }
        }
        for (y = 0; y < root; ++y) {
            int actualX;
            int actualY;
            x = 0;
            while ((actualY = offSetY + y) < root && (actualX = offSetX + x++) < root) {
                if (inventoryCrafting.func_70301_a(actualY * root + actualX) == null) continue;
                int xDifference = actualX - (offSetX - 1);
                int yDifference = actualY - (offSetY - 1);
                if (xDifference > width) {
                    width = xDifference;
                }
                if (yDifference <= height) continue;
                height = yDifference;
            }
        }
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                if (inventoryCrafting.func_70301_a((offSetY + y) * root + (offSetX + x)) == null) continue;
                recipeSize = (short)(recipeSize + 1);
            }
        }
        short s = (short)(recipeKey | (recipeSize | width << 8 | height << 12));
        recipeKey = s;
        List list = recipeList = this.shapedRecipes.containsKey(s) ? (List)this.shapedRecipes.get(recipeKey) : (List)this.shapelessRecipes.get(recipeSize);
        if (recipeList != null) {
            for (IAdvancedRecipe recipe : recipeList) {
                if (!recipe.recipeMatch(inventoryCrafting, offSetX, offSetY)) continue;
                return (R)recipe;
            }
        }
        return null;
    }
}

