/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.stevescarts;

import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.addons.stevescarts.StevesCartsModule;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class HUDCargoManager
implements IWailaDataProvider {
    private static String[] colors = new String[]{"NA", "Red", "Blue", "Yellow", "Green", "Dis."};
    private static String[] sides = new String[]{"Yellow", "Blue", "Green", "Red"};

    @Override
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    @Override
    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        int side;
        if (!config.getConfig("stevescarts.showall")) {
            return currenttip;
        }
        if (config.getConfig("stevescarts.shifttoggle") && !accessor.getPlayer().func_70093_af()) {
            currenttip.add(SpecialChars.ITALIC + "Press shift for more data");
            return currenttip;
        }
        NBTTagCompound tag = accessor.getNBTData();
        if (config.getConfig("stevescarts.colorblind") && (side = accessor.getSide().ordinal() - 2) >= 0) {
            currenttip.add("Looking at side " + SpecialChars.WHITE + sides[side]);
        }
        int layout = accessor.getNBTInteger(tag, "layout");
        switch (layout) {
            case 0: {
                currenttip.add("Slots : " + SpecialChars.WHITE + "Shared");
                break;
            }
            case 1: {
                currenttip.add("Slots : " + SpecialChars.WHITE + "By side");
                break;
            }
            case 2: {
                currenttip.add("Slots : " + SpecialChars.WHITE + "By color");
            }
        }
        try {
            ArrayList itemSelection = (ArrayList)StevesCartsModule.ItemSelections.get(accessor.getTileEntity());
            int toCart = accessor.getNBTInteger(tag, "tocart");
            int doReturn = accessor.getNBTInteger(tag, "doReturn");
            for (int i = 0; i < 4; ++i) {
                int target = accessor.getNBTInteger(tag, "target" + String.valueOf(i));
                int color = accessor.getNBTInteger(tag, "color" + String.valueOf(i));
                int amount = accessor.getNBTInteger(tag, "amount" + String.valueOf(i));
                if (color == 5) continue;
                String direction = (toCart & 1 << i) != 0 ? "Load" : "Unload";
                String shouldReturn = (doReturn & 1 << i) != 0 ? "Ret." : "Cont.";
                String sAmount = amount == 0 ? "All" : String.valueOf(this.getAmount(amount) + " " + this.getAmountType(amount));
                String selection = (String)StevesCartsModule.GetSelectionName.invoke(StevesCartsModule.CargoItemSelection.cast(itemSelection.get(target)), new Object[0]);
                currenttip.add(String.format("Side %s %s[ %s ]%s[ %s , %s]%s[ %s ]", SpecialChars.WHITE + colors[color] + SpecialChars.GRAY, SpecialChars.TAB + SpecialChars.ALIGNRIGHT, SpecialChars.WHITE + selection + SpecialChars.GRAY, SpecialChars.TAB + SpecialChars.ALIGNRIGHT, SpecialChars.WHITE + direction + SpecialChars.GRAY, SpecialChars.TAB + SpecialChars.ALIGNRIGHT + SpecialChars.WHITE + shouldReturn + SpecialChars.GRAY, SpecialChars.TAB + SpecialChars.ALIGNRIGHT, SpecialChars.WHITE + sAmount + SpecialChars.GRAY));
            }
        }
        catch (Exception e) {
            currenttip = WailaExceptionHandler.handleErr(e, accessor.getTileEntity().getClass().getName(), currenttip);
        }
        return currenttip;
    }

    @Override
    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public int getAmount(int id) {
        switch (id) {
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 8;
            }
            case 4: {
                return 16;
            }
            case 5: {
                return 32;
            }
            case 6: {
                return 64;
            }
            case 7: {
                return 1;
            }
            case 8: {
                return 2;
            }
            case 9: {
                return 3;
            }
            case 10: {
                return 5;
            }
        }
        return 0;
    }

    public String getAmountType(int id) {
        if (id <= 6) {
            return "I";
        }
        return "S";
    }

    @Override
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        if (te != null) {
            te.func_145841_b(tag);
        }
        return tag;
    }
}

