/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.core;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.wirelessredstone.core.WirelessBolt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import org.lwjgl.opengl.GL11;

public class RenderWirelessBolt {
    static double interpPosX;
    static double interpPosY;
    static double interpPosZ;

    public static void render(float frame, Entity entity) {
        GL11.glPushMatrix();
        RenderUtils.translateToWorldCoords((Entity)entity, (float)frame);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        CCRenderState state = CCRenderState.instance();
        state.resetInstance();
        state.setBrightnessInstance(0xF000F0);
        CCRenderState.changeTexture((String)"wrcbe_core:textures/lightning_glowstone.png");
        state.startDrawingInstance(7);
        for (WirelessBolt bolt : WirelessBolt.clientboltlist) {
            RenderWirelessBolt.renderBolt(bolt, 0);
        }
        state.drawInstance();
        CCRenderState.changeTexture((String)"wrcbe_core:textures/lightning_redstone.png");
        state.startDrawingInstance(7);
        for (WirelessBolt bolt : WirelessBolt.clientboltlist) {
            RenderWirelessBolt.renderBolt(bolt, 1);
        }
        state.drawInstance();
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
    }

    private static void renderBolt(WirelessBolt bolt, int pass) {
        Tessellator t = Tessellator.field_78398_a;
        float boltage = bolt.particleAge < 0 ? 0.0f : (float)bolt.particleAge / (float)bolt.particleMaxAge;
        float mainalpha = pass == 0 ? (1.0f - boltage) * 0.4f : 1.0f - boltage * 0.5f;
        int expandTime = (int)(bolt.length * 3.0);
        int renderstart = (int)((float)(expandTime / 2 - bolt.particleMaxAge + bolt.particleAge) / (float)(expandTime / 2) * (float)bolt.numsegments0);
        int renderend = (int)((float)(bolt.particleAge + expandTime) / (float)expandTime * (float)bolt.numsegments0);
        for (WirelessBolt.Segment rendersegment : bolt.segments) {
            double roundEndZ;
            double roundEndY;
            double roundEndX;
            double diffMag;
            double diffZ;
            double diffY;
            double diffX;
            if (rendersegment.segmentno < renderstart || rendersegment.segmentno > renderend) continue;
            EntityLivingBase viewEntity = Minecraft.func_71410_x().field_71451_h;
            double startX = rendersegment.startpoint.point.x;
            double startY = rendersegment.startpoint.point.y;
            double startZ = rendersegment.startpoint.point.z;
            double playerX = viewEntity.field_70165_t - startX;
            double playerY = viewEntity.field_70163_u + (double)viewEntity.func_70047_e() - startY;
            double playerZ = viewEntity.field_70161_v - startZ;
            double playerMag = Math.sqrt(playerX * playerX + playerY * playerY + playerZ * playerZ);
            double width = (double)0.025f * (playerMag / 5.0 + 1.0) * (double)(1.0f + rendersegment.light) * 0.5;
            double prevDiffX = rendersegment.prevdiff.x;
            double prevDiffY = rendersegment.prevdiff.y;
            double prevDiffZ = rendersegment.prevdiff.z;
            double nextDiffX = rendersegment.nextdiff.x;
            double nextDiffY = rendersegment.nextdiff.y;
            double nextDiffZ = rendersegment.nextdiff.z;
            double crossPrevX = playerY * prevDiffZ - playerZ * prevDiffY;
            double crossPrevY = playerZ * prevDiffX - playerX * prevDiffZ;
            double crossPrevZ = playerX * prevDiffY - playerY * prevDiffX;
            double crossPrevMag = Math.sqrt(crossPrevX * crossPrevX + crossPrevY * crossPrevY + crossPrevZ * crossPrevZ);
            crossPrevX /= crossPrevMag;
            crossPrevY /= crossPrevMag;
            crossPrevZ /= crossPrevMag;
            crossPrevX *= width / (double)rendersegment.sinprev;
            crossPrevY *= width / (double)rendersegment.sinprev;
            crossPrevZ *= width / (double)rendersegment.sinprev;
            double crossNextX = playerY * nextDiffZ - playerZ * nextDiffY;
            double crossNextY = playerZ * nextDiffX - playerX * nextDiffZ;
            double crossNextZ = playerX * nextDiffY - playerY * nextDiffX;
            double crossNextMag = Math.sqrt(crossNextX * crossNextX + crossNextY * crossNextY + crossNextZ * crossNextZ);
            crossNextX /= crossNextMag;
            crossNextY /= crossNextMag;
            crossNextZ /= crossNextMag;
            double endX = rendersegment.endpoint.point.x;
            double endY = rendersegment.endpoint.point.y;
            double endZ = rendersegment.endpoint.point.z;
            t.func_78369_a(1.0f, 1.0f, 1.0f, mainalpha * rendersegment.light);
            t.func_78374_a(endX - (crossNextX *= width / (double)rendersegment.sinnext), endY - (crossNextY *= width / (double)rendersegment.sinnext), endZ - (crossNextZ *= width / (double)rendersegment.sinnext), 0.5, 0.0);
            t.func_78374_a(startX - crossPrevX, startY - crossPrevY, startZ - crossPrevZ, 0.5, 0.0);
            t.func_78374_a(startX + crossPrevX, startY + crossPrevY, startZ + crossPrevZ, 0.5, 1.0);
            t.func_78374_a(endX + crossNextX, endY + crossNextY, endZ + crossNextZ, 0.5, 1.0);
            if (rendersegment.next == null) {
                diffX = rendersegment.diff.x;
                diffY = rendersegment.diff.y;
                diffZ = rendersegment.diff.z;
                diffMag = Math.sqrt(diffX * diffX + diffY * diffY + diffZ * diffZ);
                roundEndX = endX + (diffX /= diffMag) * width;
                roundEndY = endY + (diffY /= diffMag) * width;
                roundEndZ = endZ + (diffZ /= diffMag) * width;
                t.func_78374_a(roundEndX - crossNextX, roundEndY - crossNextY, roundEndZ - crossNextZ, 0.0, 0.0);
                t.func_78374_a(endX - crossNextX, endY - crossNextY, endZ - crossNextZ, 0.5, 0.0);
                t.func_78374_a(endX + crossNextX, endY + crossNextY, endZ + crossNextZ, 0.5, 1.0);
                t.func_78374_a(roundEndX + crossNextX, roundEndY + crossNextY, roundEndZ + crossNextZ, 0.0, 1.0);
            }
            if (rendersegment.prev != null) continue;
            diffX = rendersegment.diff.x;
            diffY = rendersegment.diff.y;
            diffZ = rendersegment.diff.z;
            diffMag = Math.sqrt(diffX * diffX + diffY * diffY + diffZ * diffZ);
            roundEndX = startX - (diffX /= diffMag) * width;
            roundEndY = startY - (diffY /= diffMag) * width;
            roundEndZ = startZ - (diffZ /= diffMag) * width;
            t.func_78374_a(startX - crossPrevX, startY - crossPrevY, startZ - crossPrevZ, 0.5, 0.0);
            t.func_78374_a(roundEndX - crossPrevX, roundEndY - crossPrevY, roundEndZ - crossPrevZ, 0.0, 0.0);
            t.func_78374_a(roundEndX + crossPrevX, roundEndY + crossPrevY, roundEndZ + crossPrevZ, 0.0, 1.0);
            t.func_78374_a(startX + crossPrevX, startY + crossPrevY, startZ + crossPrevZ, 0.5, 1.0);
        }
    }
}

