/*
 * Decompiled with CFR 0.152.
 */
package tterrag.wailaplugins.plugins;

import com.enderio.core.common.Lang;
import com.enderio.core.common.util.BlockCoord;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorState;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IGenome;
import forestry.apiculture.BeekeepingLogic;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.multiblock.TileAlveary;
import forestry.arboriculture.genetics.Tree;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.arboriculture.tiles.TileTreeContainer;
import forestry.core.access.IOwnable;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.TileEngine;
import forestry.core.tiles.TileForestry;
import forestry.core.utils.StringUtil;
import forestry.plugins.PluginApiculture;
import java.lang.reflect.Field;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;
import tterrag.wailaplugins.api.Plugin;
import tterrag.wailaplugins.plugins.PluginBase;

@Plugin(name="Forestry", deps={"Forestry"})
public class PluginForestry
extends PluginBase {
    private static Field _throttle;
    private static Field _maxHeat;
    private static NumberFormat pctFmt;
    private static Lang forLang;
    public static final String LEAF_BRED_SPECIES = "leafBredSpecies";
    public static final String QUEEN_STACK = "queenStack";
    public static final String DRONE_STACK = "droneStack";
    public static final String ERRORS = "errors";
    public static final String BREED_PROGRESS = "breedProgress";
    public static final String TREE = "treeData";
    public static final String ENERGY_STORED = "rfStored";
    public static final String MAX_ENERGY_STORED = "maxRfStored";
    public static final String HEAT = "engineHeat";
    public static final String OWNER = "tileOwner";

    public PluginForestry() {
        try {
            _throttle = BeekeepingLogic.class.getDeclaredField("throttle");
        }
        catch (NoSuchFieldException e) {
            _throttle = BeekeepingLogic.class.getDeclaredField("queenWorkCycleThrottle");
        }
        _throttle.setAccessible(true);
        _maxHeat = TileEngine.class.getDeclaredField("maxHeat");
        _maxHeat.setAccessible(true);
        pctFmt.setMinimumFractionDigits(2);
    }

    @Override
    public void load(IWailaRegistrar registrar) {
        super.load(registrar);
        this.registerBody(TileForestry.class, TileTreeContainer.class, TileAlveary.class);
        this.registerNBT(TileForestry.class, TileTreeContainer.class, TileAlveary.class);
        this.addConfig("power");
        this.addConfig("heat");
        this.addConfig("sapling");
        this.addConfig("leaves");
        this.addConfig("apiary");
    }

    @Override
    protected void getBody(ItemStack stack, List<String> currenttip, IWailaDataAccessor accessor) {
        Block block = accessor.getBlock();
        TileEntity tile = accessor.getTileEntity();
        World world = accessor.getWorld();
        EntityPlayer player = accessor.getPlayer();
        MovingObjectPosition pos = accessor.getPosition();
        NBTTagCompound tag = accessor.getNBTData();
        int x = pos.field_72311_b;
        int y = pos.field_72312_c;
        int z = pos.field_72309_d;
        if (tag.func_74764_b(ENERGY_STORED) && this.getConfig("power")) {
            currenttip.add(tag.func_74762_e(ENERGY_STORED) + " / " + tag.func_74762_e(MAX_ENERGY_STORED) + " RF");
        }
        if (tag.func_74764_b(HEAT) && this.getConfig("heat")) {
            currenttip.add(lang.localize(HEAT, new Object[]{(double)tag.func_74762_e(HEAT) / 10.0 + "\u00b0C"}));
        }
        if (tag.func_74764_b(TREE) && this.getConfig("sapling")) {
            Tree tree = new Tree(tag.func_74775_l(TREE));
            this.addGenomeTooltip(tag, (TileTreeContainer)tile, (ITree)tree, player, currenttip);
        }
        if (tile instanceof TileLeaves && this.getConfig("leaves") && ((TileLeaves)tile).isPollinated()) {
            currenttip.add(lang.localize("pollinated", new Object[]{tag.func_74779_i(LEAF_BRED_SPECIES)}));
        }
        if (tile instanceof IBeeHousing && this.getConfig("apiary")) {
            ItemStack queenstack = null;
            ItemStack dronestack = null;
            if (tag.func_74764_b(QUEEN_STACK)) {
                queenstack = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l(QUEEN_STACK));
            }
            if (tag.func_74764_b(DRONE_STACK)) {
                dronestack = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l(DRONE_STACK));
            }
            Bee queen = null;
            if (queenstack != null) {
                queen = new Bee(queenstack.func_77978_p());
                String queenSpecies = this.getSpeciesName((IGenome)queen.getGenome(), true);
                currenttip.add(EnumChatFormatting.WHITE + lang.localize("mainbee", new Object[]{this.getNameForBeeType(queenstack), EnumChatFormatting.GREEN + queenSpecies}));
                if (queen.isAnalyzed()) {
                    this.addIndentedBeeInfo((IBee)queen, currenttip);
                }
            }
            Bee drone = null;
            if (queen != null && queen.getMate() != null) {
                drone = new Bee(queen.getMate());
            } else if (dronestack != null) {
                drone = new Bee(dronestack.func_77978_p());
            }
            if (drone != null) {
                currenttip.add(String.format(EnumChatFormatting.WHITE + lang.localize("secondarybee"), lang.localize("drone"), EnumChatFormatting.GREEN + this.getSpeciesName((IGenome)drone.getGenome(), true)));
                if (drone.isAnalyzed()) {
                    this.addIndentedBeeInfo((IBee)drone, currenttip);
                }
            }
            if (tag.func_74764_b(ERRORS) || tag.func_74764_b(BREED_PROGRESS)) {
                int[] ids = tag.func_74759_k(ERRORS);
                HashSet errs = Sets.newHashSet();
                for (int i : ids) {
                    errs.add(ForestryAPI.errorStateRegistry.getErrorState((short)i));
                }
                if (!errs.isEmpty()) {
                    Object object = errs.iterator();
                    while (object.hasNext()) {
                        IErrorState err = (IErrorState)object.next();
                        currenttip.add(EnumChatFormatting.WHITE + String.format(lang.localize("breedError"), EnumChatFormatting.RED + forLang.localize(err.getDescription())));
                    }
                } else {
                    currenttip.add(EnumChatFormatting.WHITE + String.format(lang.localize(BREED_PROGRESS), EnumChatFormatting.AQUA + pctFmt.format(tag.func_74769_h(BREED_PROGRESS))));
                }
            }
        }
    }

    private void addGenomeTooltip(NBTTagCompound tag, TileTreeContainer te, ITree tree, EntityPlayer player, List<String> currenttip) {
        UUID owner = UUID.fromString(tag.func_74779_i(OWNER));
        if (owner.equals(player.func_146103_bH().getId()) && (tree.isAnalyzed() || te instanceof TileLeaves)) {
            this.addTreeTooltip(tree, currenttip);
        } else if (tree != null) {
            currenttip.add(EnumChatFormatting.ITALIC + (tree.isAnalyzed() ? lang.localize("notOwner") : lang.localize("notAnalyzed")));
        }
    }

    private void addTreeTooltip(ITree tree, List<String> currenttip) {
        if (Proxies.common.isShiftDown()) {
            tree.addTooltip(currenttip);
        } else {
            currenttip.add(this.getTMI());
        }
    }

    private String getTMI() {
        return EnumChatFormatting.ITALIC + "<" + StringUtil.localize((String)"gui.tooltip.tmi") + ">";
    }

    private String getSpeciesName(IGenome genome, boolean active) {
        return active ? genome.getActiveAllele((IChromosomeType)EnumBeeChromosome.SPECIES).getName() : genome.getInactiveAllele((IChromosomeType)EnumBeeChromosome.SPECIES).getName();
    }

    private String getNameForBeeType(ItemStack bee) {
        return PluginApiculture.items.beeDroneGE == bee.func_77973_b() ? lang.localize("drone") : (PluginApiculture.items.beePrincessGE == bee.func_77973_b() ? lang.localize("princess") : lang.localize("queen"));
    }

    private void addIndentedBeeInfo(IBee bee, List<String> currenttip) {
        if (Proxies.common.isShiftDown()) {
            ArrayList<String> tt = new ArrayList<String>();
            bee.addTooltip(tt);
            for (int i = 0; i < tt.size(); ++i) {
                tt.set(i, (i == 0 ? ">" : "") + SpecialChars.TAB + (String)tt.get(i));
            }
            currenttip.addAll(tt);
        } else {
            currenttip.add(this.getTMI());
        }
    }

    @Override
    protected void getNBTData(TileEntity te, NBTTagCompound tag, World world, BlockCoord pos) {
        ITreeGenome mate;
        if (te instanceof TileLeaves && (mate = ((TileLeaves)te).getTree().getMate()) != null) {
            tag.func_74778_a(LEAF_BRED_SPECIES, mate.getActiveAllele((IChromosomeType)EnumTreeChromosome.SPECIES).getName());
        }
        if (te instanceof IBeeHousing) {
            IBeeHousing housing = (IBeeHousing)te;
            IBeekeepingLogic logic = housing.getBeekeepingLogic();
            IBeeHousingInventory inv = housing.getBeeInventory();
            IErrorLogic errs = housing.getErrorLogic();
            if (logic != null) {
                ItemStack queen = inv.getQueen();
                ItemStack drone = inv.getDrone();
                if (queen != null) {
                    NBTTagCompound queenTag = new NBTTagCompound();
                    queen.func_77955_b(queenTag);
                    tag.func_74782_a(QUEEN_STACK, (NBTBase)queenTag);
                }
                if (drone != null) {
                    NBTTagCompound droneTag = new NBTTagCompound();
                    drone.func_77955_b(droneTag);
                    tag.func_74782_a(DRONE_STACK, (NBTBase)droneTag);
                }
                ImmutableSet errors = errs.getErrorStates();
                ArrayList ids = Lists.newArrayList();
                for (IErrorState error : errors) {
                    ids.add(Integer.valueOf(error.getID()));
                }
                tag.func_74783_a(ERRORS, ArrayUtils.toPrimitive((Integer[])ids.toArray(new Integer[0])));
                if (queen != null && PluginApiculture.items.beeQueenGE == queen.func_77973_b()) {
                    Bee queenBee = new Bee(queen.func_77978_p());
                    float throttle = _throttle.getInt(logic);
                    float maxAge = queenBee.getMaxHealth();
                    float age = Math.abs((float)queenBee.getHealth() - maxAge);
                    float step = 1.0f / maxAge;
                    float progress = step * (throttle / 550.0f);
                    tag.func_74780_a(BREED_PROGRESS, (double)(age / maxAge + progress));
                }
            }
        }
        if (te instanceof TileTreeContainer) {
            ITree tree = ((TileTreeContainer)te).getTree();
            NBTTagCompound treeTag = new NBTTagCompound();
            tree.writeToNBT(treeTag);
            tag.func_74782_a(TREE, (NBTBase)treeTag);
        }
        if (te instanceof TileEngine) {
            tag.func_74768_a(ENERGY_STORED, ((TileEngine)te).getEnergyManager().getTotalEnergyStored());
            tag.func_74768_a(MAX_ENERGY_STORED, ((TileEngine)te).getEnergyManager().getMaxEnergyStored());
            tag.func_74768_a(HEAT, ((TileEngine)te).getHeat());
        }
        if (te instanceof IOwnable) {
            GameProfile owner = ((IOwnable)te).getOwner();
            tag.func_74778_a(OWNER, owner.getId().toString());
        }
    }

    static {
        pctFmt = NumberFormat.getPercentInstance();
        forLang = new Lang("for");
    }
}

