/*
 * Decompiled with CFR 0.152.
 */
package wealthyturtle.uiesingularities.proxy;

import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import fox.spiteful.avaritia.Config;
import fox.spiteful.avaritia.crafting.CompressorManager;
import fox.spiteful.avaritia.crafting.Grinder;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;
import wealthyturtle.uiesingularities.NEI;
import wealthyturtle.uiesingularities.UniversalSingularity;
import wealthyturtle.uiesingularities.UniversalSingularityItem;
import wealthyturtle.uiesingularities.UniversalSingularityWrapper;

public class CommonProxy {
    private final boolean hideDisabledSingularities;
    protected final List<UniversalSingularityItem> singularities = new ArrayList<UniversalSingularityItem>();
    private final Map<String, Set<String>> allowed = new HashMap<String, Set<String>>();
    private final boolean coalSingularityEasterEgg;

    public CommonProxy() {
        List<UniversalSingularity> universalSingularities = Arrays.asList(new UniversalSingularity("vanilla", Arrays.asList(new UniversalSingularityWrapper("coal", "blockCoal", 3648, 0x282828, 789516, false), new UniversalSingularityWrapper("emerald", "blockEmerald", 729, 6347651, 2926406, false), new UniversalSingularityWrapper("diamond", "blockDiamond", 729, 4910545, 3201981, false))), new UniversalSingularity("general", Arrays.asList(new UniversalSingularityWrapper("aluminum", "blockAluminum", 1824, 0xEDEDED, 0xC5C5C5, false), new UniversalSingularityWrapper("brass", "blockBrass", 1824, 14194228, 9133851, false), new UniversalSingularityWrapper("bronze", "blockBronze", 1824, 13275214, 13204005, false), new UniversalSingularityWrapper("charcoal", "blockCharcoal", 7296, 6313283, 1052171, false), new UniversalSingularityWrapper("electrum", "blockElectrum", 912, 16641882, 15721042, false), new UniversalSingularityWrapper("invar", "blockInvar", 1824, 13686734, 11318449, false), new UniversalSingularityWrapper("magnesium", "blockMagnesium", 3648, 9665644, 7824471), new UniversalSingularityWrapper("osmium", "blockOsmium", 406, 4808172, 2831023, false), new UniversalSingularityWrapper("peridot", "blockPeridot", 608, 5809451, 5149222, false), new UniversalSingularityWrapper("ruby", "blockRuby", 608, 0xB44848, 0x993D3D, false), new UniversalSingularityWrapper("sapphire", "blockSapphire", 608, 5338065, 4614862, false), new UniversalSingularityWrapper("steel", "blockSteel", 912, 0x9F9F9F, 0x888888, false), new UniversalSingularityWrapper("titanium", "blockTitanium", 2024, 14399962, 4598599, false), new UniversalSingularityWrapper("tungsten", "blockTungsten", 244, 0x8B8B8B, 0x161616, false), new UniversalSingularityWrapper("uranium", "blockUranium", 507, 52032, 50238, false), new UniversalSingularityWrapper("zinc", "blockZinc", 3648, 0xDBD4D4, 0x636161, false), new UniversalSingularityWrapper("tricalciumphosphate", "blockTricalciumPhosphate", 365, 16445185, 6907137, false), new UniversalSingularityWrapper("palladium", "blockPalladium", 136, 0xF0F0F0, 0xE2E2E2, false), new UniversalSingularityWrapper("damascusSteel", "blockDamascusSteel", 153, 0x9F9F9F, 0x888888, false), new UniversalSingularityWrapper("blackSteel", "blockBlackSteel", 304, 0x909090, 0x3F3F3F, false), new UniversalSingularityWrapper("electrumFlux", "blockElectrumFlux", 16, 13678157, 10749446, false), new UniversalSingularityWrapper("quicksilver", "blockQuicksilver", 1824, 8180679, 2850931, false), new UniversalSingularityWrapper("shadowSteel", "blockShadowSteel", 406, 8942434, 7758676, false), new UniversalSingularityWrapper("iridium", "blockIridium", 62, 0xFFFFFF, 0x6A6A6A, false), new UniversalSingularityWrapper("netherstar", "blockNetherStar", 75, 0xFFFFFF, 8946876, false), new UniversalSingularityWrapper("platinum", "blockPlatinum", 406, 16184295, 12369043, false), new UniversalSingularityWrapper("naquadria", "blockNaquadria", 66, 0xFFFFFF, 0, false), new UniversalSingularityWrapper("plutonium", "blockPlutonium", 244, 13314602, 7147533, false), new UniversalSingularityWrapper("meteoricIron", "blockMeteoricIron", 912, 0x272727, 0, false), new UniversalSingularityWrapper("desh", "blockDesh", 203, 0x383838, 0, false), new UniversalSingularityWrapper("europium", "blockEuropium", 62, 0x3DADADA, 0x555555, false))), new UniversalSingularity("bigReactors", Arrays.asList(new UniversalSingularityWrapper("blutonium", "blockBlutonium", 9999, 4604630, 1769702, false), new UniversalSingularityWrapper("cyanite", "blockCyanite", 9999, 6074331, 34799, false), new UniversalSingularityWrapper("graphite", "blockGraphite", 9999, 0x5D5D5D, 0x444444, false), new UniversalSingularityWrapper("ludicrite", "blockLudicrite", 9999, 15729128, 15795121, false), new UniversalSingularityWrapper("yellorium", "blockYellorium", 9999, 14277468, 15466301, false))), new UniversalSingularity("draconicEvolution", Arrays.asList(new UniversalSingularityWrapper("draconium", "blockDraconium", 226, 9329856, 8145582, false), new UniversalSingularityWrapper("draconiumAwakened", "blockDraconiumAwakened", 1, 16740864, 0xFF6600, false))), new UniversalSingularity("enderIO", Arrays.asList(new UniversalSingularityWrapper("conductiveIron", "blockConductiveIron", 912, 13278621, 12817561, false), new UniversalSingularityWrapper("electricalSteel", "blockElectricalSteel", 912, 0x949494, 0x8D8D8D, false), new UniversalSingularityWrapper("energeticAlloy", "blockEnergeticAlloy", 191, 16754232, 16751649, false), new UniversalSingularityWrapper("darkSteel", "blockDarkSteel", 912, 0x3C3C3C, 0x383838, false), new UniversalSingularityWrapper("pulsatingIron", "blockPulsatingIron", 912, 8583838, 6941320, false), new UniversalSingularityWrapper("redstoneAlloy", "blockRedstoneAlloy", 912, 15882071, 14040124, false), new UniversalSingularityWrapper("soularium", "blockSoularium", 456, 6047015, 5914149, false), new UniversalSingularityWrapper("vibrantAlloy", "blockVibrantAlloy", 145, 10996306, 10009408, false))), new UniversalSingularity("extraPlanets", Arrays.asList(new UniversalSingularityWrapper("blueGem", "blockBlueGem", 95, 3725311, 247542, false), new UniversalSingularityWrapper("carbon", "blockCarbon", 66, 0x1D1D1D, 986895, false), new UniversalSingularityWrapper("crystal", "blockCrystal", 78, 0xE2E2E2, 0xC1C1C1, false), new UniversalSingularityWrapper("redGem", "blockRedGem", 68, 16726796, 16331008, false), new UniversalSingularityWrapper("whiteGem", "blockWhiteGem", 70, 0xC6C6C6, 0xA5A5A5, false))), new UniversalSingularity("extraTiC", Arrays.asList(new UniversalSingularityWrapper("fairy", "blockFairy", 90, 16745411, 16737716, false), new UniversalSingularityWrapper("pokefennium", "blockPokefennium", 71, 4418419, 4739937, false))), new UniversalSingularity("extraUtilities", Arrays.asList(new UniversalSingularityWrapper("unstable", "blockUnstable", 66, 0xC5C5C5, 0xB1B1B1, false))), new UniversalSingularity("mekanism", Arrays.asList(new UniversalSingularityWrapper("refinedGlowstone", "blockRefinedGlowstone", 67, 16044086, 14394914, false), new UniversalSingularityWrapper("refinedObsidian", "blockRefinedObsidian", 82, 5719407, 5456490, false))), new UniversalSingularity("metallurgy", Arrays.asList(new UniversalSingularityWrapper("bitumen", "blockBitumen", 93, 0x242424, 0x313131, false), new UniversalSingularityWrapper("potash", "blockPotash", 85, 15700227, 14320643, false), new UniversalSingularityWrapper("angmallen", "blockAngmallen", 65, 14800778, 14075745, false), new UniversalSingularityWrapper("hepatizon", "blockHepatizon", 82, 0x755E75, 6377057, false), new UniversalSingularityWrapper("desichalkos", "blockDesichalkos", 88, 7483304, 5251446, false), new UniversalSingularityWrapper("celenegil", "blockCelenegil", 81, 9751624, 6590760, false), new UniversalSingularityWrapper("haderoth", "blockHaderoth", 72, 7812126, 5842967, false), new UniversalSingularityWrapper("tartarite", "blockTartarite", 83, 11416576, 7939072, false), new UniversalSingularityWrapper("amordrine", "blockAmordrine", 68, 11111857, 9399194, false), new UniversalSingularityWrapper("inolashite", "blockInolashite", 67, 4237949, 3377252, false))), new UniversalSingularity("pneumaticCraft", Collections.singletonList(new UniversalSingularityWrapper("compressedIron", "blockIronCompressed", 93, 0x636363, 0x515151, false))), new UniversalSingularity("projectRed", Collections.singletonList(new UniversalSingularityWrapper("electrotine", "blockElectrotine", 1215, 1001861, 868210, false))), new UniversalSingularity("redstoneArsenal", Arrays.asList(new UniversalSingularityWrapper("crystalFlux", "blockCrystalFlux", 76, 16659258, 15208730, false))), new UniversalSingularity("tinkersConstruct", Arrays.asList(new UniversalSingularityWrapper("aluminumBrass", "blockAluminumBrass", 1824, 14859854, 13939016, false), new UniversalSingularityWrapper("alumite", "blockAlumite", 229, 15314394, 14850257, false), new UniversalSingularityWrapper("ardite", "blockArdite", 304, 13781248, 0x960000, false), new UniversalSingularityWrapper("cobalt", "blockCobalt", 1824, 2324189, 146587, false), new UniversalSingularityWrapper("ender", "blockEnder", 608, 45715, 37500, false), new UniversalSingularityWrapper("glue", "blockGlue", 912, 0xDBD0D0, 13549503, false), new UniversalSingularityWrapper("manyullyn", "blockManyullyn", 380, 11107808, 9595587, false))));
        Configuration config = new Configuration(new File("." + File.separatorChar + "config" + File.separatorChar + "UniversalSingularities.cfg"));
        this.hideDisabledSingularities = config.get("general", "hideDisabledSingularitiesInNei", true).getBoolean() && Loader.isModLoaded((String)"NotEnoughItems");
        universalSingularities.forEach(universalSingularity -> {
            if (config.get(universalSingularity.name, "enabled", true).getBoolean()) {
                for (int i = 0; i < universalSingularity.singularities.size(); ++i) {
                    UniversalSingularityWrapper universalSingularityWrapper = universalSingularity.singularities.get(i);
                    if (!config.get(universalSingularity.name, universalSingularityWrapper.name, universalSingularityWrapper.enabled).getBoolean()) continue;
                    if (!this.allowed.containsKey(universalSingularity.name)) {
                        this.allowed.put(universalSingularity.name, new HashSet());
                    }
                    this.allowed.get(universalSingularity.name).add(universalSingularityWrapper.name);
                }
                this.singularities.add(new UniversalSingularityItem(universalSingularity.name, universalSingularity.singularities));
            }
        });
        this.coalSingularityEasterEgg = config.get("general", "coalSingularityEasterEgg", true).getBoolean();
        if (config.hasChanged()) {
            config.save();
        }
    }

    public final void preInit() {
        this.singularities.forEach(singularity -> GameRegistry.registerItem((Item)singularity, (String)("universal." + singularity.name + ".singularity")));
    }

    public void init() {
    }

    public final void postInit() {
        if (Config.craftingOnly) {
            return;
        }
        this.addToRecipeInput();
    }

    private void addToRecipeInput() {
        this.singularities.forEach(singularity -> {
            for (int i = 0; i < singularity.universalSingularities.size(); ++i) {
                UniversalSingularityWrapper universalSingularityWrapper = singularity.universalSingularities.get(i);
                if (this.allowed.containsKey(singularity.name) && this.allowed.get(singularity.name).contains(universalSingularityWrapper.name)) {
                    List oreList = OreDictionary.getOres((String)universalSingularityWrapper.oreName, (boolean)false);
                    if (oreList != null && !oreList.isEmpty()) {
                        CompressorManager.addOreRecipe((ItemStack)new ItemStack((Item)singularity, 1, i), (int)universalSingularityWrapper.recipeBaseValue, (String)universalSingularityWrapper.oreName);
                        Grinder.catalyst.getInput().add(new ItemStack((Item)singularity, 1, i));
                        continue;
                    }
                    if (!this.hideDisabledSingularities) continue;
                    NEI.hide(new ItemStack((Item)singularity, 1, i));
                    continue;
                }
                if (!this.hideDisabledSingularities) continue;
                NEI.hide(new ItemStack((Item)singularity, 1, i));
            }
        });
        if (this.coalSingularityEasterEgg && this.allowed.containsKey("vanilla") && this.allowed.get("vanilla").contains("coal")) {
            GameRegistry.registerFuelHandler((IFuelHandler)new CoalSingularityFuelHandler(this.getSingularityByName("vanilla")));
        }
    }

    public UniversalSingularityItem getSingularityByName(@Nonnull String name) {
        for (UniversalSingularityItem singularity : this.singularities) {
            if (!singularity.name.equals(name)) continue;
            return singularity;
        }
        return null;
    }

    private static class CoalSingularityFuelHandler
    implements IFuelHandler {
        private final UniversalSingularityItem vanillaSingularity;
        private final int burnTime;

        private CoalSingularityFuelHandler(@Nonnull UniversalSingularityItem vanillaSingularity) {
            this.vanillaSingularity = vanillaSingularity;
            this.burnTime = 16000 * CompressorManager.getCost((ItemStack)new ItemStack(Blocks.field_150402_ci));
        }

        public int getBurnTime(ItemStack fuel) {
            return fuel != null && fuel.func_77973_b() == this.vanillaSingularity && fuel.func_77960_j() == 0 ? this.burnTime : 0;
        }
    }
}

