/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.storage.MapData;
import twilightforest.TFFeature;
import twilightforest.world.ChunkProviderTwilightForest;
import twilightforest.world.TFWorldChunkManager;
import twilightforest.world.WorldProviderTwilightForest;

public class TFMagicMapData
extends MapData {
    private static final int FEATURE_DATA_BYTE = 18;
    public List<MapData.MapCoord> featuresVisibleOnMap = new ArrayList<MapData.MapCoord>();
    public static final byte CONQ_OFFSET = 80;

    public TFMagicMapData(String par1Str) {
        super(par1Str);
    }

    public void func_76184_a(NBTTagCompound par1NBTTagCompound) {
        super.func_76184_a(par1NBTTagCompound);
        byte[] featureStorage = par1NBTTagCompound.func_74770_j("features");
        if (featureStorage.length > 0) {
            this.func_76192_a(featureStorage);
        }
    }

    public void func_76187_b(NBTTagCompound par1NBTTagCompound) {
        super.func_76187_b(par1NBTTagCompound);
        if (this.featuresVisibleOnMap.size() > 0) {
            byte[] featureStorage = this.makeFeatureStorageArray();
            par1NBTTagCompound.func_74773_a("features", featureStorage);
        }
    }

    public void addFeatureToMap(TFFeature feature, int x, int z, boolean conq) {
        byte relativeX = (byte)(x - this.field_76201_a >> this.field_76197_d);
        byte relativeZ = (byte)(z - this.field_76199_b >> this.field_76197_d);
        byte rangeX = 64;
        byte rangeY = 64;
        if (relativeX >= -rangeX && relativeZ >= -rangeY && relativeX <= rangeX && relativeZ <= rangeY) {
            byte markerIcon = (byte)feature.featureID;
            markerIcon = (byte)(markerIcon + (conq ? 80 : 0));
            byte mapX = (byte)(relativeX << 1);
            byte mapZ = (byte)(relativeZ << 1);
            byte mapRotation = 8;
            boolean featureFound = false;
            for (MapData.MapCoord existingCoord : this.featuresVisibleOnMap) {
                if (existingCoord.field_76214_b != mapX || existingCoord.field_76215_c != mapZ) continue;
                featureFound = true;
            }
            if (!featureFound) {
                this.featuresVisibleOnMap.add(new MapData.MapCoord((MapData)this, markerIcon, mapX, mapZ, mapRotation));
            }
        }
    }

    public void checkExistingFeatures(World world) {
        ArrayList<MapData.MapCoord> toRemove = null;
        for (MapData.MapCoord coord : this.featuresVisibleOnMap) {
            WorldChunkManager worldChunkManager;
            int worldX = (coord.field_76214_b << this.field_76197_d - 1) + this.field_76201_a;
            int worldZ = (coord.field_76215_c << this.field_76197_d - 1) + this.field_76199_b;
            if (world == null || !((worldChunkManager = world.func_72959_q()) instanceof TFWorldChunkManager)) continue;
            TFWorldChunkManager tfManager = (TFWorldChunkManager)worldChunkManager;
            if (coord.field_76216_a == 0) {
                if (toRemove == null) {
                    toRemove = new ArrayList<MapData.MapCoord>();
                }
                toRemove.add(coord);
                continue;
            }
            if (coord.field_76216_a >= 80) continue;
            ChunkProviderTwilightForest chunkProvider = ((WorldProviderTwilightForest)world.field_73011_w).getChunkProvider();
            coord.field_76216_a = (byte)tfManager.getFeatureID(worldX, worldZ, world);
            if (!chunkProvider.isStructureConquered(worldX, 0, worldZ)) continue;
            coord.field_76216_a = (byte)(coord.field_76216_a + 80);
        }
        if (toRemove != null) {
            this.featuresVisibleOnMap.removeAll(toRemove);
        }
    }

    public void func_76192_a(byte[] par1ArrayOfByte) {
        if (par1ArrayOfByte[0] == 18) {
            this.featuresVisibleOnMap.clear();
            for (int i = 0; i < (par1ArrayOfByte.length - 1) / 3; ++i) {
                byte markerIcon = par1ArrayOfByte[i * 3 + 1];
                byte mapX = par1ArrayOfByte[i * 3 + 2];
                byte mapZ = par1ArrayOfByte[i * 3 + 3];
                byte mapRotation = 8;
                this.featuresVisibleOnMap.add(new MapData.MapCoord((MapData)this, markerIcon, mapX, mapZ, mapRotation));
            }
        } else {
            super.func_76192_a(par1ArrayOfByte);
        }
    }

    public byte[] makeFeatureStorageArray() {
        byte[] storage = new byte[this.featuresVisibleOnMap.size() * 3 + 1];
        storage[0] = 18;
        for (int i = 0; i < this.featuresVisibleOnMap.size(); ++i) {
            MapData.MapCoord featureCoord = this.featuresVisibleOnMap.get(i);
            storage[i * 3 + 1] = featureCoord.field_76216_a;
            storage[i * 3 + 2] = featureCoord.field_76214_b;
            storage[i * 3 + 3] = featureCoord.field_76215_c;
        }
        return storage;
    }
}

