/*
 * Decompiled with CFR 0.152.
 */
package travellersgear.common.util;

import baubles.api.BaublesApi;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.world.WorldEvent;
import travellersgear.TravellersGear;
import travellersgear.api.IEventGear;
import travellersgear.api.TGSaveData;
import travellersgear.api.TravellersGearAPI;
import travellersgear.client.ToolDisplayInfo;
import travellersgear.common.network.MessageNBTSync;
import travellersgear.common.network.MessagePlayerInventorySync;
import travellersgear.common.util.ModCompatability;
import travellersgear.common.util.Utils;

public class TGEventHandler {
    TGSaveData worldData;
    static HashMap<String, ItemStack[]> previousInv = new HashMap();

    @SubscribeEvent
    public void onLoad(WorldEvent.Load event) {
        if (event.world.field_73011_w.field_76574_g == 0 && !event.world.field_72995_K) {
            this.worldData = (TGSaveData)event.world.func_72943_a(TGSaveData.class, "TG-SaveData");
            if (this.worldData == null) {
                this.worldData = new TGSaveData("TG-SaveData");
                event.world.func_72823_a("TG-SaveData", (WorldSavedData)this.worldData);
            }
            TGSaveData.setInstance(this.worldData);
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.type != TickEvent.Type.PLAYER) {
            return;
        }
        if (event.phase.equals((Object)TickEvent.Phase.START) && event.player != null) {
            ItemStack[] prev = previousInv.get(event.player.func_70005_c_());
            NBTTagList list = TravellersGearAPI.getDisplayTools(event.player);
            int[] targetedSlots = new int[list.func_74745_c()];
            for (int i = 0; i < list.func_74745_c(); ++i) {
                targetedSlots[i] = ToolDisplayInfo.readFromNBT((NBTTagCompound)list.func_150305_b((int)i)).slot;
            }
            if (list != null && targetedSlots != null && targetedSlots.length > 0) {
                if (prev == null || prev.length != targetedSlots.length) {
                    TravellersGear.packetHandler.sendToAll((IMessage)new MessagePlayerInventorySync(event.player));
                } else {
                    boolean packet = false;
                    for (int i = 0; i < prev.length; ++i) {
                        if (ItemStack.func_77989_b((ItemStack)prev[i], (ItemStack)event.player.field_71071_by.field_70462_a[targetedSlots[i]])) continue;
                        packet = true;
                    }
                    if (packet) {
                        TravellersGear.packetHandler.sendToAll((IMessage)new MessagePlayerInventorySync(event.player));
                    }
                }
            }
            for (ItemStack stack : TravellersGearAPI.getExtendedInventory(event.player)) {
                if (stack == null || ModCompatability.getTravellersGearSlot(stack) == -1) continue;
                Utils.tickTravGear(event.player, stack);
            }
        }
        if (event.phase.equals((Object)TickEvent.Phase.END) && event.player != null) {
            NBTTagList list = TravellersGearAPI.getDisplayTools(event.player);
            int[] targetedSlots = new int[list.func_74745_c()];
            for (int i = 0; i < list.func_74745_c(); ++i) {
                targetedSlots[i] = ToolDisplayInfo.readFromNBT((NBTTagCompound)list.func_150305_b((int)i)).slot;
            }
            ItemStack[] newPrev = new ItemStack[targetedSlots.length];
            for (int i = 0; i < newPrev.length; ++i) {
                newPrev[i] = event.player.field_71071_by.field_70462_a[targetedSlots[i]];
            }
            previousInv.put(event.player.func_70005_c_(), newPrev);
        }
    }

    @SubscribeEvent
    public void playerDrops(PlayerDropsEvent event) {
        if (!event.entityPlayer.field_70170_p.field_72995_K && !event.entityPlayer.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            ItemStack[] tg = TravellersGearAPI.getExtendedInventory(event.entityPlayer);
            for (int i = 0; i < tg.length; ++i) {
                if (tg[i] == null) continue;
                EntityItem ei = new EntityItem(event.entityPlayer.field_70170_p, event.entityPlayer.field_70165_t, event.entityPlayer.field_70163_u, event.entityPlayer.field_70161_v, tg[i]);
                ei.field_145804_b = 40;
                float f1 = event.entityPlayer.field_70170_p.field_73012_v.nextFloat() * 0.5f;
                float f2 = event.entityPlayer.field_70170_p.field_73012_v.nextFloat() * 3.141593f * 2.0f;
                ei.field_70159_w = -MathHelper.func_76126_a((float)f2) * f1;
                ei.field_70179_y = MathHelper.func_76134_b((float)f2) * f1;
                ei.field_70181_x = 0.2000000029802322;
                event.drops.add(ei);
                tg[i] = null;
            }
            TravellersGearAPI.setExtendedInventory(event.entityPlayer, tg);
            TravellersGear.packetHandler.sendToAll((IMessage)new MessageNBTSync(event.entityPlayer));
        }
    }

    @SubscribeEvent
    public void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            TravellersGear.packetHandler.sendToAll((IMessage)new MessageNBTSync(event.player));
        }
    }

    @SubscribeEvent
    public void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            TravellersGear.packetHandler.sendToAll((IMessage)new MessageNBTSync(event.player));
        }
    }

    @SubscribeEvent
    public void onPlayerDamaged(LivingHurtEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            for (Object[] gear : this.buildEventGearList((EntityPlayer)event.entityLiving)) {
                ItemStack stack = (ItemStack)gear[0];
                TGEventHandler.triggerGear((EntityPlayer)event.entityLiving, (Integer)gear[1], (Event)event);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerAttacking(AttackEntityEvent event) {
        for (Object[] gear : this.buildEventGearList(event.entityPlayer)) {
            ItemStack stack = (ItemStack)gear[0];
            TGEventHandler.triggerGear(event.entityPlayer, (Integer)gear[1], (Event)event);
        }
    }

    @SubscribeEvent
    public void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            for (Object[] gear : this.buildEventGearList((EntityPlayer)event.entityLiving)) {
                ItemStack stack = (ItemStack)gear[0];
                TGEventHandler.triggerGear((EntityPlayer)event.entityLiving, (Integer)gear[1], (Event)event);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerFall(LivingFallEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            for (Object[] gear : this.buildEventGearList((EntityPlayer)event.entityLiving)) {
                ItemStack stack = (ItemStack)gear[0];
                TGEventHandler.triggerGear((EntityPlayer)event.entityLiving, (Integer)gear[1], (Event)event);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTargeted(LivingSetAttackTargetEvent event) {
        if (event.target instanceof EntityPlayer) {
            for (Object[] gear : this.buildEventGearList((EntityPlayer)event.target)) {
                ItemStack stack = (ItemStack)gear[0];
                TGEventHandler.triggerGear((EntityPlayer)event.target, (Integer)gear[1], (Event)event);
            }
        }
    }

    public Object[][] buildEventGearList(EntityPlayer player) {
        int i;
        IInventory inv;
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        ItemStack[] is = player.field_71071_by.field_70460_b;
        for (int armor = 0; armor < is.length; ++armor) {
            if (is[armor] == null || !(is[armor].func_77973_b() instanceof IEventGear)) continue;
            list.add(new Object[]{is[armor], 9 + armor});
        }
        if (TravellersGear.BAUBLES && (inv = BaublesApi.getBaubles((EntityPlayer)player)) != null) {
            for (i = 0; i < inv.func_70302_i_(); ++i) {
                if (inv.func_70301_a(i) == null || !(inv.func_70301_a(i).func_77973_b() instanceof IEventGear)) continue;
                list.add(new Object[]{inv.func_70301_a(i), 13 + i});
            }
        }
        is = TravellersGearAPI.getExtendedInventory(player);
        for (int tg = 0; tg < is.length; ++tg) {
            if (is[tg] == null || !(is[tg].func_77973_b() instanceof IEventGear)) continue;
            list.add(new Object[]{is[tg], 17 + tg});
        }
        if (TravellersGear.MARI && (inv = ModCompatability.getMariInventory(player)) != null) {
            for (i = 0; i < inv.func_70302_i_(); ++i) {
                if (inv.func_70301_a(i) == null || !(inv.func_70301_a(i).func_77973_b() instanceof IEventGear)) continue;
                list.add(new Object[]{inv.func_70301_a(i), 21 + i});
            }
        }
        if (TravellersGear.TCON && (inv = ModCompatability.getTConArmorInv(player)) != null) {
            for (i = 1; i < 3; ++i) {
                if (inv.func_70301_a(i) == null || !(inv.func_70301_a(i).func_77973_b() instanceof IEventGear)) continue;
                list.add(new Object[]{inv.func_70301_a(i), 24 + i});
            }
        }
        if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof IEventGear) {
            list.add(list.size() / 2, new Object[]{player.func_71045_bC(), player.field_71071_by.field_70461_c});
        }
        return (Object[][])list.toArray((T[])new Object[0][]);
    }

    public static void triggerGear(EntityPlayer player, int slot, Event event) {
        switch (slot) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                ItemStack[] mainInv = player.field_71071_by.field_70462_a;
                TGEventHandler.triggerItemEvent(mainInv[slot], player, true, event);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                ItemStack[] armorInv = player.field_71071_by.field_70460_b;
                TGEventHandler.triggerItemEvent(armorInv[slot - 9], player, false, event);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                IInventory baubInv = BaublesApi.getBaubles((EntityPlayer)player);
                TGEventHandler.triggerItemEvent(baubInv.func_70301_a(slot - 4 - 9), player, false, event);
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                ItemStack[] tgInv = TravellersGearAPI.getExtendedInventory(player);
                TGEventHandler.triggerItemEvent(tgInv[slot - 8 - 9], player, false, event);
                TravellersGearAPI.setExtendedInventory(player, tgInv);
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                IInventory mariInv = ModCompatability.getMariInventory(player);
                TGEventHandler.triggerItemEvent(mariInv.func_70301_a(slot - 12 - 9), player, false, event);
                break;
            }
            case 24: 
            case 25: {
                IInventory tconInv = ModCompatability.getTConArmorInv(player);
                TGEventHandler.triggerItemEvent(tconInv.func_70301_a(slot - 15 - 9), player, false, event);
                break;
            }
        }
    }

    static void triggerItemEvent(ItemStack stack, EntityPlayer player, boolean e, Event event) {
        if (stack != null && stack.func_77973_b() instanceof IEventGear) {
            if (event instanceof LivingHurtEvent) {
                ((IEventGear)stack.func_77973_b()).onUserDamaged((LivingHurtEvent)event, stack);
            }
            if (event instanceof AttackEntityEvent) {
                ((IEventGear)stack.func_77973_b()).onUserAttacking((AttackEntityEvent)event, stack);
            }
            if (event instanceof LivingEvent.LivingJumpEvent) {
                ((IEventGear)stack.func_77973_b()).onUserJump((LivingEvent.LivingJumpEvent)event, stack);
            }
            if (event instanceof LivingFallEvent) {
                ((IEventGear)stack.func_77973_b()).onUserFall((LivingFallEvent)event, stack);
            }
            if (event instanceof LivingSetAttackTargetEvent) {
                ((IEventGear)stack.func_77973_b()).onUserTargeted((LivingSetAttackTargetEvent)event, stack);
            }
        }
    }
}

