/*
 * Decompiled with CFR 0.152.
 */
package travellersgear.common.network;

import baubles.api.BaublesApi;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import travellersgear.TravellersGear;
import travellersgear.api.IActiveAbility;
import travellersgear.api.TravellersGearAPI;
import travellersgear.common.network.MessageNBTSync;
import travellersgear.common.util.ModCompatability;

public class MessageActiveAbility
implements IMessage {
    int dim;
    int playerid;
    int slot;

    public MessageActiveAbility() {
    }

    public MessageActiveAbility(EntityPlayer player, int slot) {
        this.dim = player.field_70170_p.field_73011_w.field_76574_g;
        this.playerid = player.func_145782_y();
        this.slot = slot;
    }

    public void fromBytes(ByteBuf buf) {
        this.dim = buf.readInt();
        this.playerid = buf.readInt();
        this.slot = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dim);
        buf.writeInt(this.playerid);
        buf.writeInt(this.slot);
    }

    public static void performAbility(EntityPlayer player, int slot) {
        switch (slot) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                ItemStack[] mainInv = player.field_71071_by.field_70462_a;
                MessageActiveAbility.activateItem(mainInv[slot], player, true);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                ItemStack[] armorInv = player.field_71071_by.field_70460_b;
                MessageActiveAbility.activateItem(armorInv[slot - 9], player, false);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                IInventory baubInv = BaublesApi.getBaubles((EntityPlayer)player);
                MessageActiveAbility.activateItem(baubInv.func_70301_a(slot - 4 - 9), player, false);
                ModCompatability.setPlayerBaubles(player, baubInv);
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                ItemStack[] tgInv = TravellersGearAPI.getExtendedInventory(player);
                MessageActiveAbility.activateItem(tgInv[slot - 8 - 9], player, false);
                TravellersGearAPI.setExtendedInventory(player, tgInv);
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                IInventory mariInv = ModCompatability.getMariInventory(player);
                MessageActiveAbility.activateItem(mariInv.func_70301_a(slot - 12 - 9), player, false);
                break;
            }
            case 24: 
            case 25: {
                IInventory tconInv = ModCompatability.getTConArmorInv(player);
                MessageActiveAbility.activateItem(tconInv.func_70301_a(slot - 15 - 9), player, false);
                break;
            }
        }
    }

    static void activateItem(ItemStack stack, EntityPlayer player, boolean e) {
        if (stack != null && stack.func_77973_b() instanceof IActiveAbility && ((IActiveAbility)stack.func_77973_b()).canActivate(player, stack, e)) {
            ((IActiveAbility)stack.func_77973_b()).activate(player, stack);
        }
    }

    public static class Handler
    implements IMessageHandler<MessageActiveAbility, IMessage> {
        public IMessage onMessage(MessageActiveAbility message, MessageContext ctx) {
            WorldServer world = DimensionManager.getWorld((int)message.dim);
            if (world == null) {
                return null;
            }
            Entity ent = world.func_73045_a(message.playerid);
            if (!(ent instanceof EntityPlayer)) {
                return null;
            }
            EntityPlayer player = (EntityPlayer)ent;
            MessageActiveAbility.performAbility(player, message.slot);
            TravellersGear.packetHandler.sendToAll((IMessage)new MessageNBTSync(player));
            return null;
        }
    }
}

