/*
 * Decompiled with CFR 0.152.
 */
package travellersgear.common.items;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import travellersgear.TravellersGear;
import travellersgear.api.ITravellersGear;
import travellersgear.client.ModelSimpleGear;
import vazkii.botania.api.item.ICosmeticAttachable;

@Optional.Interface(iface="vazkii.botania.api.item.ICosmeticAttachable", modid="Botania")
public class ItemTravellersGear
extends Item
implements IBauble,
ITravellersGear,
ICosmeticAttachable {
    public static String[] subNames = new String[]{"cloak", "belt", "ringGold", "ringSilver", "pauldrons", "vambraces", "title"};
    IIcon[] icons = new IIcon[subNames.length];
    static String[] titles = new String[]{"treepuncher", "titan", "librarian", "bursar", "archchancellor", "justicar", "explorer", "defender", "seeker", "boxFox", "freshPrince"};

    public ItemTravellersGear() {
        this.func_77627_a(true);
        this.func_77637_a(TravellersGear.creativeTab);
        this.func_77625_d(1);
    }

    public void func_94581_a(IIconRegister ir) {
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = ir.func_94245_a("travellersgear:simplegear_" + subNames[i]);
        }
    }

    public IIcon func_77617_a(int meta) {
        if (meta >= 0 && meta < this.icons.length) {
            return this.icons[meta];
        }
        return this.icons[0];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < subNames.length; ++i) {
            list.add(new ItemStack((Item)this, 1, i));
        }
        for (String tit : titles) {
            ItemStack scr = new ItemStack((Item)this, 1, 6);
            scr.func_77982_d(new NBTTagCompound());
            scr.func_77978_p().func_74778_a("title", "TG.personaltitle." + tit);
            list.add(scr);
        }
    }

    public String func_77667_c(ItemStack stack) {
        String subName = stack.func_77960_j() < subNames.length ? subNames[stack.func_77960_j()] : "";
        return this.func_77658_a() + "." + subName;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        ItemStack cosmetic;
        String type = this.getSlot(stack) >= 0 ? "tg." + this.getSlot(stack) : "bauble." + this.getBaubleType(stack);
        list.add(StatCollector.func_74837_a((String)("TG.desc.gearSlot." + type), (Object[])new Object[0]));
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("title")) {
            list.add(StatCollector.func_74838_a((String)stack.func_77978_p().func_74779_i("title")));
        }
        if (Loader.isModLoaded((String)"Botania") && (cosmetic = this.getCosmeticItem(stack)) != null) {
            list.add(String.format(StatCollector.func_74838_a((String)"botaniamisc.hasCosmetic"), cosmetic.func_82833_r()).replaceAll("&", "\u00a7"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        String subName = stack.func_77960_j() < subNames.length ? subNames[stack.func_77960_j()] : "";
        return subName.startsWith("cloak") ? "travellersgear:textures/models/cloak.png" : "travellersgear:textures/models/tgTextures.png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack stack, int armorSlot) {
        String subName;
        String string = subName = stack.func_77960_j() < subNames.length ? subNames[stack.func_77960_j()] : "";
        if (subName.startsWith("belt") || subName.startsWith("pauldrons") || subName.startsWith("vambraces") || subName.startsWith("cloak")) {
            return ModelSimpleGear.getModel(entityLiving, stack);
        }
        return null;
    }

    @Override
    public int getSlot(ItemStack stack) {
        String subName;
        String string = subName = stack.func_77960_j() < subNames.length ? subNames[stack.func_77960_j()] : "";
        if (subName.startsWith("cloak")) {
            return 0;
        }
        if (subName.startsWith("pauldrons")) {
            return 1;
        }
        if (subName.startsWith("vambraces")) {
            return 2;
        }
        if (subName.startsWith("title")) {
            return 3;
        }
        return -1;
    }

    public boolean canEquip(ItemStack stack, EntityLivingBase living) {
        return true;
    }

    public boolean canUnequip(ItemStack stack, EntityLivingBase living) {
        return true;
    }

    public BaubleType getBaubleType(ItemStack stack) {
        String subName;
        String string = subName = stack.func_77960_j() < subNames.length ? subNames[stack.func_77960_j()] : "";
        if (subName.startsWith("ring")) {
            return BaubleType.RING;
        }
        if (subName.startsWith("belt")) {
            return BaubleType.BELT;
        }
        if (subName.startsWith("necklace")) {
            return BaubleType.AMULET;
        }
        return null;
    }

    public void onEquipped(ItemStack stack, EntityLivingBase living) {
        this.onEquippedOrLoaded(stack, living);
    }

    public void onUnequipped(ItemStack stack, EntityLivingBase living) {
    }

    public void onWornTick(ItemStack stack, EntityLivingBase living) {
        if (living.field_70173_aa == 1) {
            this.onEquippedOrLoaded(stack, living);
        }
    }

    public void onEquippedOrLoaded(ItemStack stack, EntityLivingBase living) {
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        IInventory baubles = BaublesApi.getBaubles((EntityPlayer)player);
        if (baubles != null) {
            for (int i = 0; i < baubles.func_70302_i_(); ++i) {
                if (baubles.func_70301_a(i) != null || !baubles.func_94041_b(i, stack)) continue;
                if (!world.field_72995_K) {
                    baubles.func_70299_a(i, stack.func_77946_l());
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                    }
                }
                this.onEquipped(stack, (EntityLivingBase)player);
                break;
            }
        }
        return stack;
    }

    @Override
    public void onTravelGearTick(EntityPlayer player, ItemStack stack) {
    }

    @Override
    public void onTravelGearEquip(EntityPlayer player, ItemStack stack) {
    }

    @Override
    public void onTravelGearUnequip(EntityPlayer player, ItemStack stack) {
    }

    public int func_82790_a(ItemStack stack, int pass) {
        String subName;
        String string = subName = stack.func_77960_j() < subNames.length ? subNames[stack.func_77960_j()] : "";
        if (!subName.startsWith("cloak") || !stack.func_77942_o()) {
            return 0xFFFFFF;
        }
        NBTTagCompound tag = stack.func_77978_p().func_74775_l("display");
        if (tag == null) {
            return 0xFFFFFF;
        }
        return tag.func_74764_b("colour") ? tag.func_74762_e("colour") : 0xFFFFFF;
    }

    public void setColorForItemStack(ItemStack stack, int colour) {
        String subName;
        String string = subName = stack.func_77960_j() < subNames.length ? subNames[stack.func_77960_j()] : "";
        if (!subName.startsWith("cloak")) {
            return;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = stack.func_77978_p().func_74775_l("display");
        tag.func_74768_a("colour", colour);
        stack.func_77978_p().func_74782_a("display", (NBTBase)tag);
    }

    public WeightedRandomChestContent getChestGenBase(ChestGenHooks chest, Random random, WeightedRandomChestContent original) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("title", "TG.personaltitle." + titles[random.nextInt(titles.length)]);
        original.field_76297_b.func_77982_d(tag);
        return original;
    }

    @Optional.Method(modid="Botania")
    public ItemStack getCosmeticItem(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        ItemStack cosmetic = ItemStack.func_77949_a((NBTTagCompound)stack.func_77978_p().func_74775_l("botaniaCosmeticOverride"));
        return cosmetic;
    }

    @Optional.Method(modid="Botania")
    public void setCosmeticItem(ItemStack stack, ItemStack cosmetic) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (cosmetic == null) {
            stack.func_77978_p().func_82580_o("botaniaCosmeticOverride");
        } else {
            NBTTagCompound cosTag = cosmetic.func_77955_b(new NBTTagCompound());
            stack.func_77978_p().func_74782_a("botaniaCosmeticOverride", (NBTBase)cosTag);
        }
    }
}

