/*
 * Decompiled with CFR 0.152.
 */
package travellersgear.client;

import baubles.api.BaublesApi;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IResource;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import travellersgear.TravellersGear;
import travellersgear.api.RenderTravellersGearEvent;
import travellersgear.api.TravellersGearAPI;
import travellersgear.client.BlockRenderArmorStand;
import travellersgear.client.KeyHandler;
import travellersgear.client.TileRenderArmorStand;
import travellersgear.client.ToolDisplayInfo;
import travellersgear.client.gui.GuiArmorStand;
import travellersgear.client.gui.GuiButtonGear;
import travellersgear.client.gui.GuiConfigDisplayItems;
import travellersgear.client.gui.GuiTravellersInv;
import travellersgear.client.gui.GuiTravellersInvCustomization;
import travellersgear.client.handlers.ActiveAbilityHandler;
import travellersgear.client.handlers.CustomizeableGuiHandler;
import travellersgear.common.CommonProxy;
import travellersgear.common.blocks.TileEntityArmorStand;
import travellersgear.common.inventory.SlotRestricted;
import travellersgear.common.network.MessageOpenGui;
import travellersgear.common.network.MessageRequestNBTSync;
import travellersgear.common.network.MessageSlotSync;
import travellersgear.common.util.ModCompatability;
import travellersgear.common.util.TGClientCommand;
import travellersgear.common.util.Utils;
import vazkii.botania.api.item.IBaubleRender;
import vazkii.botania.api.item.ICosmeticAttachable;

public class ClientProxy
extends CommonProxy {
    public static HashMap<String, ItemStack[]> equipmentMap = new HashMap();
    public static HashMap<String, ToolDisplayInfo[]> toolDisplayMap = new HashMap();
    public static String[] keyBindings;
    public static int[] equipmentButtonPos;
    public static float activeAbilityGuiSpeed;
    public static float titleOffset;
    public static Configuration config;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        equipmentButtonPos = config.get("Options", "Button Position", new int[]{27, 9}, "The position of the Equipment Button in the Inventory").getIntList();
        activeAbilityGuiSpeed = config.getFloat("Radial Speed", "Options", 0.15f, 0.05f, 1.0f, "The speed at which the radial for active abilities opens. Default is 15% per tick, minimum is 5%, maximum is 100%");
        titleOffset = (float)config.get("Options", "Title Offset", 0.0, "Configures the vertical offset of the title above the players head. 0 is default, set to 1 to render above the players name, the other offsets will use that scale.").getDouble();
        Property prop = config.get("Local", "Key Bindings", new String[]{"one", "two", "three"}, "Hotkey binding for active abilities");
        if (prop.getStringList().length < 3) {
            prop.setToDefault();
        }
        keyBindings = prop.getStringList();
        config.save();
        CustomizeableGuiHandler.instance.preInit(event);
    }

    public static void bindKey(int num, String item) {
        if (num >= 0 && num < 3) {
            ClientProxy.keyBindings[num] = item;
            config.save();
        }
    }

    @SubscribeEvent
    public void loadTextures(TextureStitchEvent event) {
        ArrayList<ResourceLocation> txts = new ArrayList<ResourceLocation>();
        txts.add(new ResourceLocation("travellersgear", "textures/gui/inventory_book.png"));
        txts.add(new ResourceLocation("travellersgear", "textures/gui/inventory_digital.png"));
        txts.add(new ResourceLocation("travellersgear", "textures/gui/inventory_epic.png"));
        int c = 0;
        ResourceLocation customN = new ResourceLocation("travellersgear", "textures/gui/inventory_custom" + c + ".png");
        while (this.resourceExists(customN) && c < 32) {
            txts.add(customN);
            customN = new ResourceLocation("travellersgear", "textures/gui/inventory_custom" + ++c + ".png");
        }
        CustomizeableGuiHandler.invTextures = txts.toArray(new ResourceLocation[0]);
    }

    boolean resourceExists(ResourceLocation rl) {
        IResource r = null;
        try {
            r = Minecraft.func_71410_x().func_110442_L().func_110536_a(rl);
        }
        catch (Exception e) {
            return false;
        }
        return r != null;
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        switch (ID) {
            case 0: {
                return new GuiTravellersInv(player);
            }
            case 1: {
                return new GuiArmorStand(player.field_71071_by, (TileEntityArmorStand)world.func_147438_o(x, y, z));
            }
            case 2: {
                return new GuiTravellersInvCustomization(player);
            }
            case 3: {
                return new GuiConfigDisplayItems(player);
            }
        }
        return null;
    }

    @SubscribeEvent
    public void guiPostInit(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.gui instanceof GuiInventory) {
            int xSize = 176;
            int ySize = 166;
            int guiLeft = (event.gui.field_146294_l - xSize) / 2;
            int guiTop = (event.gui.field_146295_m - ySize) / 2;
            if (!event.gui.field_146297_k.field_71439_g.func_70651_bq().isEmpty() && ModCompatability.isNeiHidden()) {
                guiLeft = 160 + (event.gui.field_146294_l - xSize - 200) / 2;
            }
            event.buttonList.add(new GuiButtonGear(106, guiLeft + equipmentButtonPos[0], guiTop + equipmentButtonPos[1]));
        }
    }

    @SubscribeEvent
    public void guiDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (Loader.isModLoaded((String)"GalacticraftCore") && event.gui instanceof GuiInventory) {
            List bList = null;
            try {
                bList = (List)GuiScreen.class.getDeclaredFields()[4].get(event.gui);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (bList != null) {
                for (Object o : bList) {
                    if (!(o instanceof GuiButtonGear)) continue;
                    return;
                }
            }
            int xSize = 176;
            int ySize = 166;
            int guiLeft = (event.gui.field_146294_l - xSize) / 2;
            int guiTop = (event.gui.field_146295_m - ySize) / 2;
            if (!event.gui.field_146297_k.field_71439_g.func_70651_bq().isEmpty() && ModCompatability.isNeiHidden()) {
                guiLeft = 160 + (event.gui.field_146294_l - xSize - 200) / 2;
            }
            bList.add(new GuiButtonGear(106, guiLeft + equipmentButtonPos[0], guiTop + equipmentButtonPos[1]));
        }
    }

    @SubscribeEvent
    public void guiPostAction(GuiScreenEvent.ActionPerformedEvent.Post event) {
        if (event.gui instanceof GuiInventory && event.button.getClass().equals(GuiButtonGear.class)) {
            boolean[] hidden = new boolean[CustomizeableGuiHandler.moveableInvElements.size()];
            for (int bme = 0; bme < hidden.length; ++bme) {
                hidden[bme] = CustomizeableGuiHandler.moveableInvElements.get((int)bme).hideElement;
            }
            TravellersGear.packetHandler.sendToServer((IMessage)new MessageSlotSync((EntityPlayer)event.gui.field_146297_k.field_71439_g, hidden));
            TravellersGear.packetHandler.sendToServer((IMessage)new MessageOpenGui((EntityPlayer)event.gui.field_146297_k.field_71439_g, 0));
        }
    }

    @SubscribeEvent
    public void renderPlayerSpecialPre(RenderPlayerEvent.Specials.Pre event) {
        int i;
        if (BaublesApi.getBaubles(event.entityPlayer) != null) {
            for (i = 0; i < BaublesApi.getBaubles(event.entityPlayer).func_70302_i_(); ++i) {
                ItemStack bb = BaublesApi.getBaubles(event.entityPlayer).func_70301_a(i);
                if (bb == null || bb.func_77973_b().getArmorModel((EntityLivingBase)event.entityPlayer, bb, 0) == null) continue;
                GL11.glPushMatrix();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                ClientProxy.renderTravellersItem(bb, i, event.entityPlayer, event.renderer, event.partialRenderTick);
                GL11.glPopMatrix();
            }
        }
        if (equipmentMap.get(event.entityPlayer.func_70005_c_()) != null) {
            for (i = 0; i < equipmentMap.get(event.entityPlayer.func_70005_c_()).length; ++i) {
                ItemStack eq = equipmentMap.get(event.entityPlayer.func_70005_c_())[i];
                if (eq == null || eq.func_77973_b().getArmorModel((EntityLivingBase)event.entityPlayer, eq, 0) == null) continue;
                if (i == 0) {
                    event.renderCape = false;
                }
                GL11.glPushMatrix();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                ClientProxy.renderTravellersItem(eq, i, event.entityPlayer, event.renderer, event.partialRenderTick);
                GL11.glPopMatrix();
            }
            if (Loader.isModLoaded((String)"Botania")) {
                this.handleBotaniaRenders(event.entityPlayer, (RenderPlayerEvent)event);
            }
        } else if (event.entityPlayer.func_82114_b() != null) {
            TravellersGear.packetHandler.sendToServer((IMessage)new MessageRequestNBTSync(event.entityPlayer, (EntityPlayer)Minecraft.func_71410_x().field_71439_g));
        }
        if (toolDisplayMap.get(event.entityPlayer.func_70005_c_()) != null) {
            for (ToolDisplayInfo tdi : toolDisplayMap.get(event.entityPlayer.func_70005_c_())) {
                boolean isBlock;
                if (tdi == null) continue;
                ItemStack stack = event.entityPlayer.field_71071_by.func_70301_a(tdi.slot);
                if (tdi.hideWhenEquipped && ItemStack.func_77989_b((ItemStack)stack, (ItemStack)event.entityPlayer.func_71045_bC()) || stack == null) continue;
                GL11.glPushMatrix();
                boolean bl = isBlock = MinecraftForgeClient.getItemRenderer((ItemStack)stack, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.EQUIPPED) == null && stack.func_94608_d() == 0 && stack.func_77973_b() instanceof ItemBlock;
                if (tdi.rotateWithHead) {
                    GL11.glRotatef((float)(event.entityPlayer.field_70759_as - event.entityPlayer.field_70761_aq), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)event.entityPlayer.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
                }
                GL11.glTranslated((double)0.5, (double)0.5, (double)0.0);
                GL11.glScalef((float)tdi.scale[0], (float)tdi.scale[1], (float)tdi.scale[2]);
                GL11.glTranslated((double)-0.5, (double)-0.5, (double)0.0);
                GL11.glTranslated((double)(-0.5 / (double)tdi.scale[0]), (double)(-0.25 / (double)tdi.scale[1]), (double)0.0);
                if (tdi.translation != null && tdi.translation.length > 2) {
                    GL11.glTranslatef((float)(tdi.translation[0] / tdi.scale[0]), (float)(tdi.translation[1] / tdi.scale[1]), (float)(tdi.translation[2] / tdi.scale[2]));
                }
                GL11.glTranslated((double)0.5, (double)0.5, (double)0.0);
                if (tdi.rotation != null && tdi.rotation.length > 2) {
                    GL11.glRotatef((float)tdi.rotation[1], (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)tdi.rotation[2], (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glRotatef((float)tdi.rotation[0], (float)1.0f, (float)0.0f, (float)0.0f);
                }
                if (!isBlock) {
                    GL11.glTranslated((double)-0.5, (double)-0.5, (double)0.0);
                }
                Minecraft.func_71410_x().func_110434_K().func_110577_a(Minecraft.func_71410_x().func_110434_K().func_130087_a(stack.func_94608_d()));
                if (MinecraftForgeClient.getItemRenderer((ItemStack)stack, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.EQUIPPED) == null) {
                    if (stack.func_94608_d() == 0 && stack.func_77973_b() instanceof ItemBlock) {
                        Block b = Block.func_149634_a((Item)stack.func_77973_b());
                        if (b.func_149701_w() != 0) {
                            GL11.glDepthMask((boolean)false);
                            RenderBlocks.getInstance().func_147800_a(b, stack.func_77960_j(), 1.0f);
                            GL11.glDepthMask((boolean)true);
                        } else {
                            RenderBlocks.getInstance().func_147800_a(b, stack.func_77960_j(), 1.0f);
                        }
                    } else {
                        for (int pass = 0; pass < stack.func_77973_b().getRenderPasses(stack.func_77960_j()); ++pass) {
                            IIcon icon = event.entityPlayer.func_70620_b(stack, pass);
                            ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)icon.func_94209_e(), (float)icon.func_94206_g(), (float)icon.func_94212_f(), (float)icon.func_94210_h(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
                        }
                    }
                } else {
                    GL11.glEnable((int)3042);
                    OpenGlHelper.func_148821_a((int)770, (int)771, (int)0, (int)1);
                    IItemRenderer customRender = MinecraftForgeClient.getItemRenderer((ItemStack)stack, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.EQUIPPED);
                    customRender.renderItem(IItemRenderer.ItemRenderType.EQUIPPED, stack, new Object[]{RenderBlocks.getInstance(), event.entityPlayer});
                }
                GL11.glPopMatrix();
            }
        }
    }

    public static float interpolateRotation(float par1, float par2, float par3) {
        float f3;
        for (f3 = par2 - par1; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        return par1 + par3 * f3;
    }

    public static boolean renderTravellersItem(ItemStack stack, int slot, EntityPlayer player, RenderPlayer renderer, float partialRenderTick) {
        float f4;
        RenderTravellersGearEvent renderEvent = new RenderTravellersGearEvent(player, renderer, stack, partialRenderTick);
        MinecraftForge.EVENT_BUS.post((Event)renderEvent);
        if (!renderEvent.shouldRender) {
            return false;
        }
        ModelBiped m = stack.func_77973_b().getArmorModel((EntityLivingBase)player, stack, 4 + slot);
        if (m == null) {
            return false;
        }
        String tex = stack.func_77973_b().getArmorTexture(stack, (Entity)player, 4 + slot, null);
        if (tex != null && !tex.isEmpty()) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation(stack.func_77973_b().getArmorTexture(stack, (Entity)player, 0, null)));
        }
        m.field_78118_o = renderer.field_77109_a.field_78118_o;
        m.field_78120_m = renderer.field_77109_a.field_78120_m;
        m.field_78119_l = renderer.field_77109_a.field_78119_l;
        m.field_78095_p = renderer.field_77109_a.field_78095_p;
        m.field_78093_q = renderer.field_77109_a.field_78093_q;
        m.field_78091_s = renderer.field_77109_a.field_78091_s;
        m.field_78117_n = renderer.field_77109_a.field_78117_n;
        float f2 = ClientProxy.interpolateRotation(player.field_70760_ar, player.field_70761_aq, partialRenderTick);
        float f3 = ClientProxy.interpolateRotation(player.field_70758_at, player.field_70759_as, partialRenderTick);
        if (player.func_70115_ae() && player.field_70154_o instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase1 = (EntityLivingBase)player.field_70154_o;
            f2 = ClientProxy.interpolateRotation(entitylivingbase1.field_70760_ar, entitylivingbase1.field_70761_aq, partialRenderTick);
            f4 = Math.min(85.0f, Math.max(-85.0f, MathHelper.func_76142_g((float)(f3 - f2))));
            f2 = f3 - f4;
            if (f4 * f4 > 2500.0f) {
                f2 += f4 * 0.2f;
            }
        }
        float f13 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * partialRenderTick;
        f4 = (float)player.field_70173_aa + partialRenderTick;
        float f5 = 0.0625f;
        float f6 = Math.min(1.0f, player.field_70722_aY + (player.field_70721_aZ - player.field_70722_aY) * partialRenderTick);
        float f7 = (float)(player.func_70631_g_() ? 3 : 1) * (player.field_70754_ba - player.field_70721_aZ * (1.0f - partialRenderTick));
        m.func_78086_a((EntityLivingBase)player, f7, f6, partialRenderTick);
        m.func_78088_a((Entity)player, f7, f6, f4, f3 - f2, f13, f5);
        return true;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onTooltip(ItemTooltipEvent event) {
        if (Minecraft.func_71410_x().field_71462_r != null && Minecraft.func_71410_x().field_71462_r.getClass().equals(GuiTravellersInv.class)) {
            if (event.itemStack.func_77973_b().getClass().getName().endsWith("Knapsack")) {
                GuiTravellersInv guiContainer = (GuiTravellersInv)Minecraft.func_71410_x().field_71462_r;
                int mX = Mouse.getEventX() * guiContainer.field_146294_l / guiContainer.field_146297_k.field_71443_c;
                int mY = guiContainer.field_146295_m - Mouse.getEventY() * guiContainer.field_146295_m / guiContainer.field_146297_k.field_71440_d - 1;
                if (Utils.getSlotAtPosition(guiContainer, mX -= (guiContainer.field_146294_l - 218) / 2, mY -= (guiContainer.field_146295_m - 200) / 2) instanceof SlotRestricted && ((SlotRestricted)Utils.getSlotAtPosition((GuiContainer)guiContainer, (int)mX, (int)mY)).type == SlotRestricted.SlotType.TINKERS_BAG) {
                    event.toolTip.add(1, EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"TG.guitext.rightclickToOpen"));
                }
            }
            event.toolTip.add(EnumChatFormatting.LIGHT_PURPLE + StatCollector.func_74838_a((String)"TG.guitext.linkInChat"));
        }
    }

    @SubscribeEvent
    public void renderPlayerPre(RenderPlayerEvent.Pre event) {
        if (TravellersGearAPI.getTitleForPlayer(event.entityPlayer) == null || TravellersGearAPI.getTitleForPlayer(event.entityPlayer).isEmpty()) {
            return;
        }
        String title = StatCollector.func_74838_a((String)TravellersGearAPI.getTitleForPlayer(event.entityPlayer));
        if (!(RenderManager.field_78727_a.field_78734_h.equals((Object)event.entityPlayer) || title == null || title.isEmpty() || event.entityPlayer.func_70093_af() || Minecraft.func_71410_x().field_71474_y.field_74319_N)) {
            double d0 = event.entityPlayer.field_70142_S + (event.entityPlayer.field_70165_t - event.entityPlayer.field_70142_S) * (double)event.partialRenderTick;
            double d1 = event.entityPlayer.field_70137_T + (event.entityPlayer.field_70163_u - event.entityPlayer.field_70137_T) * (double)event.partialRenderTick;
            double d2 = event.entityPlayer.field_70136_U + (event.entityPlayer.field_70161_v - event.entityPlayer.field_70136_U) * (double)event.partialRenderTick;
            d0 -= RenderManager.field_78725_b;
            d1 -= RenderManager.field_78726_c;
            d2 -= RenderManager.field_78723_d;
            int maxDist = 64;
            double d3 = event.entityPlayer.func_70068_e((Entity)RenderManager.field_78727_a.field_78734_h);
            if (d3 <= (double)(maxDist * maxDist)) {
                FontRenderer fontrenderer = RenderManager.field_78727_a.func_78716_a();
                float f = 0.75f;
                float f1 = 0.016666668f * f;
                float fOffset = 0.375f * titleOffset;
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)d0 + 0.0f), (float)((float)d1 + event.entityPlayer.field_70131_O + 0.2625f + fOffset), (float)((float)d2));
                GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)(-RenderManager.field_78727_a.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)RenderManager.field_78727_a.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glScalef((float)(-f1), (float)(-f1), (float)f1);
                GL11.glDisable((int)2896);
                GL11.glDepthMask((boolean)false);
                GL11.glDisable((int)2929);
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                Tessellator tessellator = Tessellator.field_78398_a;
                int b0 = 0;
                if (event.entityPlayer.func_70005_c_().equalsIgnoreCase("deadmau5")) {
                    b0 = -10;
                }
                GL11.glDisable((int)3553);
                tessellator.func_78382_b();
                int j = fontrenderer.func_78256_a(title) / 2;
                tessellator.func_78369_a(0.0f, 0.0f, 0.0f, 0.25f);
                tessellator.func_78377_a((double)(-j - 1), (double)(-1 + b0), 0.0);
                tessellator.func_78377_a((double)(-j - 1), (double)(8 + b0), 0.0);
                tessellator.func_78377_a((double)(j + 1), (double)(8 + b0), 0.0);
                tessellator.func_78377_a((double)(j + 1), (double)(-1 + b0), 0.0);
                tessellator.func_78381_a();
                GL11.glEnable((int)3553);
                fontrenderer.func_78276_b(title, -fontrenderer.func_78256_a(title) / 2, b0, 0x20FFFFFF);
                GL11.glEnable((int)2929);
                GL11.glDepthMask((boolean)true);
                fontrenderer.func_78276_b(title, -fontrenderer.func_78256_a(title) / 2, b0, -1);
                GL11.glEnable((int)2896);
                GL11.glDisable((int)3042);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
            }
        }
    }

    @Override
    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)ActiveAbilityHandler.instance);
        CustomizeableGuiHandler.instance.init();
        FMLCommonHandler.instance().bus().register((Object)new KeyHandler());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRenderArmorStand());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityArmorStand.class, (TileEntitySpecialRenderer)new TileRenderArmorStand());
        ClientCommandHandler.instance.func_71560_a((ICommand)new TGClientCommand());
    }

    @Override
    public World getClientWorld() {
        return FMLClientHandler.instance().getClient().field_71441_e;
    }

    @Optional.Method(modid="Botania")
    public void handleBotaniaRenders(EntityPlayer player, RenderPlayerEvent event) {
        ItemStack[] tgInv = equipmentMap.get(player.func_70005_c_());
        for (int i = 0; i < tgInv.length; ++i) {
            ICosmeticAttachable attachable;
            ItemStack cosmetic;
            ItemStack eq = tgInv[i];
            if (eq == null || !(eq.func_77973_b() instanceof ICosmeticAttachable) || (cosmetic = (attachable = (ICosmeticAttachable)eq.func_77973_b()).getCosmeticItem(eq)) == null) continue;
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ((IBaubleRender)cosmetic.func_77973_b()).onPlayerBaubleRender(cosmetic, event, IBaubleRender.RenderType.BODY);
            GL11.glPopMatrix();
        }
        float yaw = player.field_70758_at + (player.field_70759_as - player.field_70758_at) * event.partialRenderTick;
        float yawOffset = player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * event.partialRenderTick;
        float pitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * event.partialRenderTick;
        GL11.glPushMatrix();
        GL11.glRotatef((float)yawOffset, (float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glRotatef((float)(yaw - 270.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)pitch, (float)0.0f, (float)0.0f, (float)1.0f);
        for (int i = 0; i < tgInv.length; ++i) {
            ICosmeticAttachable attachable;
            ItemStack cosmetic;
            ItemStack eq = tgInv[i];
            if (eq == null || !(eq.func_77973_b() instanceof ICosmeticAttachable) || (cosmetic = (attachable = (ICosmeticAttachable)eq.func_77973_b()).getCosmeticItem(eq)) == null) continue;
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ((IBaubleRender)cosmetic.func_77973_b()).onPlayerBaubleRender(cosmetic, event, IBaubleRender.RenderType.HEAD);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }
}

