/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.thaumicexploration.misc.brazier;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import flaxbeard.thaumicexploration.misc.brazier.SoulBrazierQueueData;
import flaxbeard.thaumicexploration.misc.brazier.SoulBrazierUtils;
import flaxbeard.thaumicexploration.tile.TileEntitySoulBrazier;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import thaumcraft.common.Thaumcraft;

public class SoulBrazierQueue {
    @SubscribeEvent
    public void onConnected(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer aJoiningPlayer = event.player;
        UUID aPlayerUUID = SoulBrazierUtils.getPlayerUUID(aJoiningPlayer);
        int queueSize = SoulBrazierUtils.doesPlayerHaveWarpQueued(aPlayerUUID);
        if (queueSize > 0) {
            String aPlayerName = aJoiningPlayer.func_146103_bH().getName();
            for (int i = 0; i < queueSize; ++i) {
                SoulBrazierQueueData aQueueData = SoulBrazierUtils.getPlayerDataFromWarpQueue(aPlayerUUID);
                int aCurrentWarp = Thaumcraft.proxy.getPlayerKnowledge().getWarpPerm(aPlayerName);
                int aTotalWarp = aCurrentWarp + aQueueData.aQueuedWarpToAdd;
                Thaumcraft.proxy.getPlayerKnowledge().setWarpPerm(aPlayerName, aTotalWarp);
                if (!SoulBrazierUtils.removePlayerDataFromWarpQueue(aPlayerUUID, aQueueData.aTileX, aQueueData.aTileY, aQueueData.aTileZ, aQueueData.aDimension)) continue;
                SoulBrazierQueue.updateSoulBrazier(SoulBrazierQueue.getWorldFromID(aQueueData.aDimension), aQueueData.aTileX, aQueueData.aTileY, aQueueData.aTileZ);
            }
        }
    }

    private static World getWorldFromID(int aID) {
        return MinecraftServer.func_71276_C().func_71218_a(aID);
    }

    private static boolean updateSoulBrazier(World aWorld, int aX, int aY, int aZ) {
        TileEntity aTile = aWorld.func_147438_o(aX, aY, aZ);
        if (aTile instanceof TileEntitySoulBrazier) {
            TileEntitySoulBrazier aBrazier = (TileEntitySoulBrazier)aTile;
            aBrazier.hasWarpQueue = false;
            return true;
        }
        return false;
    }
}

