/*
 * Decompiled with CFR 0.152.
 */
package tb.common.block;

import DummyCore.Utils.MathUtils;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockNetherrack;
import net.minecraft.block.BlockObsidian;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSoulSand;
import net.minecraft.block.BlockStone;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.oredict.OreDictionary;
import tb.init.TBBlocks;

public class BlockTBLeaves
extends BlockLeaves {
    public static final String[] names = new String[]{"goldenOakLeaves", "peacefullTreeLeaves", "netherTreeLeaves", "enderTreeLeaves"};
    public static final String[] textures = new String[]{"goldenOak/leaves", "peacefullTree/leaves", "netherTree/leaves", "enderTree/leaves"};
    public static IIcon[] icons = new IIcon[names.length];

    public boolean canEntityDestroy(IBlockAccess world, int x, int y, int z, Entity entity) {
        if (world.func_72805_g(x, y, z) % 4 == 3 && entity instanceof EntityDragon) {
            return false;
        }
        return super.canEntityDestroy(world, x, y, z, entity);
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        if (world.func_72805_g(x, y, z) % 4 == 2) {
            return true;
        }
        return super.isFlammable(world, x, y, z, face);
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        if (world.func_72805_g(x, y, z) % 4 == 2) {
            return 0;
        }
        return super.getFlammability(world, x, y, z, face);
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        if (world.func_72805_g(x, y, z) % 4 == 2) {
            return 0;
        }
        return super.getFlammability(world, x, y, z, face);
    }

    public boolean isFireSource(World world, int x, int y, int z, ForgeDirection side) {
        if (world.func_72805_g(x, y, z) % 4 == 2) {
            return true;
        }
        return super.isFireSource(world, x, y, z, side);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        return 0xFFFFFF;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) % 4 == 3) {
            return 11;
        }
        return super.getLightValue(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess w, int x, int y, int z, int meta) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World w, int x, int y, int z, Random rnd) {
        super.func_149734_b(w, x, y, z, rnd);
        switch (w.func_72805_g(x, y, z) % 4) {
            case 0: {
                w.func_72869_a("reddust", (double)x + rnd.nextDouble(), (double)y + rnd.nextDouble(), (double)z + rnd.nextDouble(), 1.0, 1.0, 0.0);
                break;
            }
            case 1: {
                w.func_72869_a("heart", (double)x + rnd.nextDouble(), (double)y + rnd.nextDouble(), (double)z + rnd.nextDouble(), 0.0, 10.0, 0.0);
                break;
            }
            case 2: {
                if (!(rnd.nextFloat() <= 0.01f) || !w.func_147437_c(x, y - 1, z)) break;
                w.func_72869_a("dripLava", (double)x + rnd.nextDouble(), (double)y, (double)z + rnd.nextDouble(), 0.0, 0.0, 0.0);
                break;
            }
            case 3: {
                w.func_72869_a("portal", (double)x + rnd.nextDouble(), (double)y + rnd.nextDouble(), (double)z + rnd.nextDouble(), MathUtils.randomDouble((Random)rnd), MathUtils.randomDouble((Random)rnd), MathUtils.randomDouble((Random)rnd));
            }
        }
    }

    public Item func_149650_a(int meta, Random rnd, int fortune) {
        return Item.func_150898_a((Block)TBBlocks.sapling);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int p_149741_1_) {
        return 0xFFFFFF;
    }

    public void func_149674_a(World w, int x, int y, int z, Random rnd) {
        super.func_149674_a(w, x, y, z, rnd);
        int meta = w.func_72805_g(x, y, z) % 4;
        switch (meta) {
            case 1: {
                this.peacefulEffect(w, x, y, z, rnd);
                break;
            }
            case 2: {
                this.netherEffect(w, x, y, z, rnd);
                break;
            }
            case 3: {
                this.endEffect(w, x, y, z, rnd);
            }
        }
    }

    private void peacefulEffect(World w, int x, int y, int z, Random rnd) {
        if (rnd.nextDouble() > 0.03) {
            return;
        }
        int dy = y;
        while (--dy >= y - 6) {
            Block b = w.func_147439_a(x, dy, z);
            if (b.isAir((IBlockAccess)w, x, dy, z)) continue;
            this.spawnBiomeEntity(w, x, dy, z, w.func_72807_a(x, z), EnumCreatureType.creature, rnd);
            break;
        }
    }

    private void netherEffect(World w, int x, int y, int z, Random rnd) {
        int dy = y;
        while (--dy >= y - 8) {
            Block b = w.func_147439_a(x, dy, z);
            if (b.isAir((IBlockAccess)w, x, dy, z)) continue;
            if (this.isNetherBlock(b) && rnd.nextDouble() <= 0.05) {
                this.spawnBiomeEntity(w, x, dy, z, BiomeGenBase.field_76778_j, rnd.nextBoolean() ? EnumCreatureType.creature : EnumCreatureType.monster, rnd);
                break;
            }
            if (!this.isOverworldBlock(b, w, x, dy, z)) continue;
            Block setTo = BlockTBLeaves.getNetherBlock(rnd.nextFloat());
            w.func_147465_d(x, dy, z, setTo, 0, 3);
            break;
        }
    }

    private void endEffect(World w, int x, int y, int z, Random rnd) {
        int dy = y;
        while (--dy >= y - 11) {
            Block b = w.func_147439_a(x, dy, z);
            if (b.isAir((IBlockAccess)w, x, dy, z)) continue;
            if (this.isEndBlock(b) && rnd.nextDouble() <= 0.02) {
                this.spawnBiomeEntity(w, x, dy, z, BiomeGenBase.field_76779_k, rnd.nextBoolean() ? EnumCreatureType.creature : EnumCreatureType.monster, rnd);
                break;
            }
            if (!this.isOverworldBlock(b, w, x, dy, z)) continue;
            Block setTo = BlockTBLeaves.getEndBlock(rnd.nextFloat());
            w.func_147465_d(x, dy, z, setTo, 0, 3);
            break;
        }
    }

    private void spawnBiomeEntity(World w, int x, int y, int z, BiomeGenBase biome, EnumCreatureType type, Random rnd) {
        if (biome == null) {
            return;
        }
        List list = biome.func_76747_a(type);
        if (list == null || list.isEmpty()) {
            return;
        }
        BiomeGenBase.SpawnListEntry entry = (BiomeGenBase.SpawnListEntry)list.get(rnd.nextInt(list.size()));
        if (entry == null || entry.field_76300_b == null || !EntityLiving.class.isAssignableFrom(entry.field_76300_b)) {
            return;
        }
        try {
            EntityLiving entity = (EntityLiving)entry.field_76300_b.getConstructor(World.class).newInstance(w);
            entity.func_70080_a((double)x + 0.5, (double)(y + 1), (double)z + 0.5, 0.0f, 0.0f);
            entity.func_110161_a(null);
            Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)entity, (World)w, (float)((float)entity.field_70165_t), (float)((float)entity.field_70163_u), (float)((float)entity.field_70161_v));
            if (canSpawn == Event.Result.ALLOW || canSpawn == Event.Result.DEFAULT && BlockTBLeaves.canSpawn(entity)) {
                w.func_72838_d((Entity)entity);
            }
        }
        catch (Exception e) {
            FMLLog.warning((String)"[TB] Failed to create biome entity of class %s: ", (Object[])new Object[]{entry.field_76300_b.getName()});
            e.printStackTrace();
        }
    }

    public static boolean canSpawn(EntityLiving entity) {
        return entity.field_70170_p.func_72855_b(entity.field_70121_D) && entity.field_70170_p.func_72945_a((Entity)entity, entity.field_70121_D).isEmpty() && !entity.field_70170_p.func_72953_d(entity.field_70121_D);
    }

    private boolean isOverworldBlock(Block b, World w, int x, int y, int z) {
        if (b instanceof BlockDirt || b instanceof BlockGrass || b instanceof BlockGravel || b instanceof BlockSand || b instanceof BlockStone) {
            return true;
        }
        ItemStack stk = new ItemStack(b, 1, w.func_72805_g(x, y, z));
        for (int id : OreDictionary.getOreIDs((ItemStack)stk)) {
            String ore = OreDictionary.getOreName((int)id);
            if (ore == null || ore.isEmpty() || !ore.contains("dirt") && !ore.contains("grass") && !ore.contains("sand") && !ore.contains("gravel") && !ore.contains("stone")) continue;
            return true;
        }
        return false;
    }

    private boolean isNetherBlock(Block b) {
        return b instanceof BlockNetherrack || b instanceof BlockSoulSand || b == Blocks.field_150449_bY;
    }

    private boolean isEndBlock(Block b) {
        return b == Blocks.field_150377_bs || b instanceof BlockObsidian;
    }

    private static Block getNetherBlock(float r) {
        return (double)r <= 0.6 ? Blocks.field_150424_aL : ((double)r <= 0.9 ? Blocks.field_150425_aM : Blocks.field_150449_bY);
    }

    private static Block getEndBlock(float r) {
        return (double)r <= 0.9 ? Blocks.field_150377_bs : Blocks.field_150343_Z;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess p_149720_1_, int p_149720_2_, int p_149720_3_, int p_149720_4_) {
        return 0xFFFFFF;
    }

    protected int func_150123_b(int meta) {
        return meta == 0 ? 50 : 30;
    }

    protected void func_150124_c(World w, int x, int y, int z, int meta, int chance) {
        if (meta == 0 && w.field_73012_v.nextInt(chance) == 0) {
            this.func_149642_a(w, x, y, z, new ItemStack(Items.field_151153_ao, 1, 0));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return icons[meta % 4];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item i, CreativeTabs tab, List<ItemStack> list) {
        for (int f = 0; f < names.length; ++f) {
            list.add(new ItemStack(i, 1, f));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        for (int i = 0; i < icons.length; ++i) {
            BlockTBLeaves.icons[i] = reg.func_94245_a("thaumicbases:" + textures[i]);
        }
        this.field_149761_L = reg.func_94245_a(this.func_149641_N());
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        if (world.func_72805_g(x, y, z) % 4 == 0) {
            return new ArrayList<ItemStack>();
        }
        return super.onSheared(item, world, x, y, z, fortune);
    }

    public String[] func_150125_e() {
        return names;
    }
}

